<?php
/**
 * Sistema Médico - Editar Paciente
 */
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$page_title = 'Editar Paciente';

$database = new Database();
$db = $database->getConnection();

$paciente_id = $_GET['id'] ?? 0;

if (!$paciente_id) {
    header('Location: buscar_paciente.php');
    exit();
}

// Obtener datos del paciente
$query = "SELECT * FROM pacientes WHERE id = :id";
$stmt = $db->prepare($query);
$stmt->bindParam(':id', $paciente_id);
$stmt->execute();
$paciente = $stmt->fetch();

if (!$paciente) {
    header('Location: buscar_paciente.php');
    exit();
}

// Obtener alertas médicas
$query = "SELECT * FROM alertas_medicas WHERE paciente_id = :id ORDER BY activo DESC, severidad DESC";
$stmt = $db->prepare($query);
$stmt->bindParam(':id', $paciente_id);
$stmt->execute();
$alertas = $stmt->fetchAll();

$mensaje = '';
$tipo_mensaje = '';

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['actualizar_datos'])) {
        // Actualizar datos del paciente
        $nombre = trim($_POST['nombre'] ?? '');
        $apellido = trim($_POST['apellido'] ?? '');
        $cedula = trim($_POST['cedula'] ?? '');
        $fecha_nacimiento = $_POST['fecha_nacimiento'] ?? '';
        $telefono = trim($_POST['telefono'] ?? '');
        $domicilio = trim($_POST['domicilio'] ?? '');

        try {
            $query = "UPDATE pacientes 
                      SET nombre = :nombre, apellido = :apellido, cedula = :cedula, 
                          fecha_nacimiento = :fecha_nacimiento, telefono = :telefono, domicilio = :domicilio
                      WHERE id = :id";
            
            $stmt = $db->prepare($query);
            $stmt->bindParam(':nombre', $nombre);
            $stmt->bindParam(':apellido', $apellido);
            $stmt->bindParam(':cedula', $cedula);
            $stmt->bindParam(':fecha_nacimiento', $fecha_nacimiento);
            $stmt->bindParam(':telefono', $telefono);
            $stmt->bindParam(':domicilio', $domicilio);
            $stmt->bindParam(':id', $paciente_id);
            $stmt->execute();

            $mensaje = 'Datos del paciente actualizados exitosamente';
            $tipo_mensaje = 'success';

            // Recargar datos
            $stmt = $db->prepare("SELECT * FROM pacientes WHERE id = :id");
            $stmt->bindParam(':id', $paciente_id);
            $stmt->execute();
            $paciente = $stmt->fetch();

        } catch (Exception $e) {
            $mensaje = 'Error al actualizar datos: ' . $e->getMessage();
            $tipo_mensaje = 'error';
        }
    }
    elseif (isset($_POST['agregar_alerta'])) {
        // Agregar nueva alerta
        $tipo = $_POST['tipo_alerta'] ?? '';
        $descripcion = trim($_POST['descripcion_alerta'] ?? '');
        $severidad = $_POST['severidad_alerta'] ?? 'media';

        try {
            $query = "INSERT INTO alertas_medicas (paciente_id, tipo, descripcion, severidad) 
                      VALUES (:paciente_id, :tipo, :descripcion, :severidad)";
            
            $stmt = $db->prepare($query);
            $stmt->bindParam(':paciente_id', $paciente_id);
            $stmt->bindParam(':tipo', $tipo);
            $stmt->bindParam(':descripcion', $descripcion);
            $stmt->bindParam(':severidad', $severidad);
            $stmt->execute();

            // Actualizar flag de alertas en paciente
            $query = "UPDATE pacientes SET tiene_alertas = 1 WHERE id = :id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':id', $paciente_id);
            $stmt->execute();

            $mensaje = 'Alerta médica agregada exitosamente';
            $tipo_mensaje = 'success';

            // Recargar alertas
            $stmt = $db->prepare("SELECT * FROM alertas_medicas WHERE paciente_id = :id ORDER BY activo DESC, severidad DESC");
            $stmt->bindParam(':id', $paciente_id);
            $stmt->execute();
            $alertas = $stmt->fetchAll();

        } catch (Exception $e) {
            $mensaje = 'Error al agregar alerta: ' . $e->getMessage();
            $tipo_mensaje = 'error';
        }
    }
    elseif (isset($_POST['desactivar_alerta'])) {
        // Desactivar alerta
        $alerta_id = $_POST['alerta_id'] ?? 0;

        try {
            $query = "UPDATE alertas_medicas SET activo = 0 WHERE id = :id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':id', $alerta_id);
            $stmt->execute();

            // Verificar si quedan alertas activas
            $query = "SELECT COUNT(*) as total FROM alertas_medicas WHERE paciente_id = :paciente_id AND activo = 1";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':paciente_id', $paciente_id);
            $stmt->execute();
            $total_alertas = $stmt->fetch()['total'];

            if ($total_alertas == 0) {
                $query = "UPDATE pacientes SET tiene_alertas = 0 WHERE id = :id";
                $stmt = $db->prepare($query);
                $stmt->bindParam(':id', $paciente_id);
                $stmt->execute();
            }

            $mensaje = 'Alerta desactivada exitosamente';
            $tipo_mensaje = 'success';

            // Recargar alertas
            $stmt = $db->prepare("SELECT * FROM alertas_medicas WHERE paciente_id = :id ORDER BY activo DESC, severidad DESC");
            $stmt->bindParam(':id', $paciente_id);
            $stmt->execute();
            $alertas = $stmt->fetchAll();

        } catch (Exception $e) {
            $mensaje = 'Error al desactivar alerta: ' . $e->getMessage();
            $tipo_mensaje = 'error';
        }
    }
}

include '../includes/header.php';
?>

<div class="card">
    <div class="card-header">
        <h2>Editar Datos del Paciente</h2>
    </div>
    <div class="card-body">
        <?php if ($mensaje): ?>
            <div class="alert alert-<?php echo $tipo_mensaje; ?>">
                <?php echo htmlspecialchars($mensaje); ?>
            </div>
        <?php endif; ?>

        <form method="POST" action="">
            <h3 style="color: var(--medical-blue); margin-bottom: 20px; border-bottom: 2px solid var(--medical-light-blue); padding-bottom: 10px;">
                Datos Personales
            </h3>

            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                <div class="form-group">
                    <label for="nombre">Nombre *</label>
                    <input type="text" id="nombre" name="nombre" value="<?php echo htmlspecialchars($paciente['nombre']); ?>" required>
                </div>

                <div class="form-group">
                    <label for="apellido">Apellido *</label>
                    <input type="text" id="apellido" name="apellido" value="<?php echo htmlspecialchars($paciente['apellido']); ?>" required>
                </div>

                <div class="form-group">
                    <label for="cedula">Cédula *</label>
                    <input type="text" id="cedula" name="cedula" value="<?php echo htmlspecialchars($paciente['cedula']); ?>" required>
                </div>

                <div class="form-group">
                    <label for="fecha_nacimiento">Fecha de Nacimiento *</label>
                    <input type="date" id="fecha_nacimiento" name="fecha_nacimiento" value="<?php echo $paciente['fecha_nacimiento']; ?>" required>
                </div>

                <div class="form-group">
                    <label for="telefono">Teléfono</label>
                    <input type="tel" id="telefono" name="telefono" value="<?php echo htmlspecialchars($paciente['telefono']); ?>">
                </div>
            </div>

            <div class="form-group">
                <label for="domicilio">Domicilio</label>
                <textarea id="domicilio" name="domicilio" rows="3"><?php echo htmlspecialchars($paciente['domicilio']); ?></textarea>
            </div>

            <div style="display: flex; gap: 15px; margin-top: 20px;">
                <button type="submit" name="actualizar_datos" class="btn btn-success">💾 Actualizar Datos</button>
                <a href="ficha_paciente.php?id=<?php echo $paciente_id; ?>" class="btn btn-secondary">Volver a la Ficha</a>
            </div>
        </form>
    </div>
</div>

<!-- Gestión de alertas médicas -->
<div class="card">
    <div class="card-header">
        <h2>Alertas Médicas</h2>
    </div>
    <div class="card-body">
        <!-- Alertas existentes -->
        <?php if (count($alertas) > 0): ?>
            <h3 style="color: var(--medical-blue); margin-bottom: 15px;">Alertas Registradas</h3>
            <?php foreach ($alertas as $alerta): ?>
                <div style="background: <?php echo $alerta['activo'] ? 'var(--medical-light-blue)' : '#f0f0f0'; ?>; padding: 15px; border-radius: 8px; margin-bottom: 15px; border-left: 4px solid <?php echo $alerta['activo'] ? 'var(--alert-orange)' : 'var(--secondary-color)'; ?>;">
                    <div style="display: flex; justify-content: space-between; align-items: start;">
                        <div style="flex: 1;">
                            <p style="margin: 0 0 5px 0;">
                                <strong><?php echo strtoupper(str_replace('_', ' ', $alerta['tipo'])); ?></strong>
                                <?php if (!$alerta['activo']): ?>
                                    <span style="background: var(--secondary-color); color: white; padding: 2px 8px; border-radius: 4px; font-size: 12px; margin-left: 10px;">INACTIVA</span>
                                <?php endif; ?>
                            </p>
                            <p style="margin: 0 0 5px 0;"><?php echo htmlspecialchars($alerta['descripcion']); ?></p>
                            <p style="margin: 0; font-size: 12px; color: var(--secondary-color);">
                                Severidad: <?php echo ucfirst($alerta['severidad']); ?> | 
                                Registrada: <?php echo date('d/m/Y', strtotime($alerta['fecha_registro'])); ?>
                            </p>
                        </div>
                        <?php if ($alerta['activo']): ?>
                            <form method="POST" action="" style="margin-left: 15px;">
                                <input type="hidden" name="alerta_id" value="<?php echo $alerta['id']; ?>">
                                <button type="submit" name="desactivar_alerta" class="btn btn-danger" style="padding: 8px 15px; font-size: 13px;" onclick="return confirm('¿Está seguro de desactivar esta alerta?')">
                                    Desactivar
                                </button>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p>No hay alertas médicas registradas para este paciente.</p>
        <?php endif; ?>

        <!-- Formulario para agregar nueva alerta -->
        <h3 style="color: var(--medical-blue); margin: 30px 0 15px; border-top: 2px solid var(--border-color); padding-top: 30px;">
            Agregar Nueva Alerta
        </h3>

        <form method="POST" action="">
            <div class="form-group">
                <label for="tipo_alerta">Tipo de Alerta *</label>
                <select id="tipo_alerta" name="tipo_alerta" required>
                    <option value="">Seleccione...</option>
                    <option value="alergia">Alergia</option>
                    <option value="resistencia_medicamento">Resistencia a Medicamento</option>
                    <option value="medicamento_permanente">Medicamento de por Vida</option>
                    <option value="otra_dolencia">Otra Dolencia o Condición</option>
                </select>
            </div>

            <div class="form-group">
                <label for="descripcion_alerta">Descripción *</label>
                <textarea id="descripcion_alerta" name="descripcion_alerta" rows="3" required></textarea>
            </div>

            <div class="form-group">
                <label for="severidad_alerta">Severidad *</label>
                <select id="severidad_alerta" name="severidad_alerta" required>
                    <option value="baja">Baja</option>
                    <option value="media" selected>Media</option>
                    <option value="alta">Alta</option>
                    <option value="critica">Crítica</option>
                </select>
            </div>

            <button type="submit" name="agregar_alerta" class="btn btn-warning">⚠️ Agregar Alerta</button>
        </form>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

