<?php
/**
 * Sistema Médico - Buscar Paciente
 */
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$page_title = 'Buscar Paciente';

$database = new Database();
$db = $database->getConnection();

$resultados = [];
$busqueda_realizada = false;

// Procesar búsqueda
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['buscar'])) {
    $termino = trim($_GET['termino'] ?? '');
    
    if (!empty($termino)) {
        $query = "SELECT p.*, 
                  (SELECT COUNT(*) FROM alertas_medicas WHERE paciente_id = p.id AND activo = 1) as total_alertas
                  FROM pacientes p
                  WHERE p.nombre LIKE :termino 
                  OR p.apellido LIKE :termino 
                  OR p.cedula LIKE :termino
                  ORDER BY p.apellido, p.nombre";
        
        $stmt = $db->prepare($query);
        $termino_busqueda = "%{$termino}%";
        $stmt->bindParam(':termino', $termino_busqueda);
        $stmt->execute();
        
        $resultados = $stmt->fetchAll();
        $busqueda_realizada = true;
    }
}

include '../includes/header.php';
?>

<div class="card">
    <div class="card-header">
        <h2>Buscar Paciente</h2>
    </div>
    <div class="card-body">
        <form method="GET" action="" class="search-box">
            <input type="text" 
                   name="termino" 
                   placeholder="Buscar por nombre, apellido o cédula..." 
                   value="<?php echo htmlspecialchars($_GET['termino'] ?? ''); ?>"
                   required>
            <button type="submit" name="buscar" class="btn btn-primary">🔍 Buscar</button>
        </form>

        <?php if ($busqueda_realizada): ?>
            <?php if (count($resultados) > 0): ?>
                <div class="alert alert-success">
                    Se encontraron <?php echo count($resultados); ?> paciente(s).
                </div>

                <div class="table-responsive">
                    <table id="tablaPacientes">
                        <thead>
                            <tr>
                                <th>Cédula</th>
                                <th>Nombre Completo</th>
                                <th>Fecha Nacimiento</th>
                                <th>Edad</th>
                                <th>Teléfono</th>
                                <th>Alertas</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($resultados as $paciente): ?>
                                <?php
                                $fecha_nac = new DateTime($paciente['fecha_nacimiento']);
                                $hoy = new DateTime();
                                $edad = $hoy->diff($fecha_nac)->y;
                                ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($paciente['cedula']); ?></td>
                                    <td><?php echo htmlspecialchars($paciente['nombre'] . ' ' . $paciente['apellido']); ?></td>
                                    <td><?php echo date('d/m/Y', strtotime($paciente['fecha_nacimiento'])); ?></td>
                                    <td><?php echo $edad; ?> años</td>
                                    <td><?php echo htmlspecialchars($paciente['telefono']); ?></td>
                                    <td>
                                        <?php if ($paciente['total_alertas'] > 0): ?>
                                            <span class="alert-emergency" style="padding: 5px 10px; border-radius: 5px; font-size: 12px;">
                                                ⚠️ <?php echo $paciente['total_alertas']; ?> alerta(s)
                                            </span>
                                        <?php else: ?>
                                            <span style="color: green;">✓ Sin alertas</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="ficha_paciente.php?id=<?php echo $paciente['id']; ?>" class="btn btn-primary" style="padding: 8px 15px; font-size: 13px;">
                                            Ver Ficha
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-warning">
                    No se encontraron pacientes con el término de búsqueda: <strong><?php echo htmlspecialchars($_GET['termino']); ?></strong>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <div style="margin-top: 30px;">
            <a href="nuevo_paciente.php" class="btn btn-success">➕ Registrar Nuevo Paciente</a>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

