<?php
/**
 * Sistema Médico - Actualizar Cita
 */
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$page_title = 'Actualizar Cita';

$database = new Database();
$db = $database->getConnection();

$cita_id = $_GET['id'] ?? 0;

if (!$cita_id) {
    header('Location: citas.php');
    exit();
}

// Obtener datos de la cita
$query = "SELECT c.*, p.nombre, p.apellido, p.cedula, u.nombre_completo as medico
          FROM citas c
          INNER JOIN pacientes p ON c.paciente_id = p.id
          INNER JOIN usuarios u ON c.medico_id = u.id
          WHERE c.id = :id";
$stmt = $db->prepare($query);
$stmt->bindParam(':id', $cita_id);
$stmt->execute();
$cita = $stmt->fetch();

if (!$cita) {
    header('Location: citas.php');
    exit();
}

$mensaje = '';
$tipo_mensaje = '';

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $estado = $_POST['estado'] ?? '';
    $observaciones = trim($_POST['observaciones'] ?? '');

    try {
        $query = "UPDATE citas SET estado = :estado, observaciones = :observaciones WHERE id = :id";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(':estado', $estado);
        $stmt->bindParam(':observaciones', $observaciones);
        $stmt->bindParam(':id', $cita_id);
        $stmt->execute();

        $mensaje = 'Cita actualizada exitosamente';
        $tipo_mensaje = 'success';

        // Recargar datos
        $stmt = $db->prepare("SELECT c.*, p.nombre, p.apellido, p.cedula, u.nombre_completo as medico
                              FROM citas c
                              INNER JOIN pacientes p ON c.paciente_id = p.id
                              INNER JOIN usuarios u ON c.medico_id = u.id
                              WHERE c.id = :id");
        $stmt->bindParam(':id', $cita_id);
        $stmt->execute();
        $cita = $stmt->fetch();

    } catch (Exception $e) {
        $mensaje = 'Error al actualizar cita: ' . $e->getMessage();
        $tipo_mensaje = 'error';
    }
}

include '../includes/header.php';
?>

<div class="card">
    <div class="card-header">
        <h2>Información de la Cita</h2>
    </div>
    <div class="card-body">
        <div class="patient-details">
            <div class="detail-item">
                <span class="detail-label">Paciente</span>
                <span class="detail-value"><?php echo htmlspecialchars($cita['nombre'] . ' ' . $cita['apellido']); ?></span>
            </div>
            <div class="detail-item">
                <span class="detail-label">Cédula</span>
                <span class="detail-value"><?php echo htmlspecialchars($cita['cedula']); ?></span>
            </div>
            <div class="detail-item">
                <span class="detail-label">Fecha y Hora</span>
                <span class="detail-value"><?php echo date('d/m/Y H:i', strtotime($cita['fecha_cita'])); ?></span>
            </div>
            <div class="detail-item">
                <span class="detail-label">Médico</span>
                <span class="detail-value"><?php echo htmlspecialchars($cita['medico']); ?></span>
            </div>
            <div class="detail-item">
                <span class="detail-label">Tipo</span>
                <span class="detail-value"><?php echo ucfirst($cita['tipo']); ?></span>
            </div>
        </div>

        <div style="margin-top: 20px;">
            <p><strong>Motivo:</strong> <?php echo nl2br(htmlspecialchars($cita['motivo'])); ?></p>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h2>Actualizar Estado de la Cita</h2>
    </div>
    <div class="card-body">
        <?php if ($mensaje): ?>
            <div class="alert alert-<?php echo $tipo_mensaje; ?>">
                <?php echo htmlspecialchars($mensaje); ?>
            </div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label for="estado">Estado de la Cita *</label>
                <select id="estado" name="estado" required>
                    <option value="pendiente" <?php echo $cita['estado'] == 'pendiente' ? 'selected' : ''; ?>>Pendiente</option>
                    <option value="confirmada" <?php echo $cita['estado'] == 'confirmada' ? 'selected' : ''; ?>>Confirmada</option>
                    <option value="completada" <?php echo $cita['estado'] == 'completada' ? 'selected' : ''; ?>>Completada</option>
                    <option value="cancelada" <?php echo $cita['estado'] == 'cancelada' ? 'selected' : ''; ?>>Cancelada</option>
                </select>
            </div>

            <div class="form-group">
                <label for="observaciones">Observaciones</label>
                <textarea id="observaciones" name="observaciones" rows="4"><?php echo htmlspecialchars($cita['observaciones']); ?></textarea>
            </div>

            <div style="display: flex; gap: 15px; margin-top: 20px;">
                <button type="submit" class="btn btn-success">💾 Actualizar Cita</button>
                <a href="citas.php" class="btn btn-secondary">Volver a Citas</a>
                <a href="ficha_paciente.php?id=<?php echo $cita['paciente_id']; ?>" class="btn btn-primary">Ver Paciente</a>
            </div>
        </form>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

