# Actualización del Sistema Médico - Módulo de Facturación

## Fecha: 2025

## Resumen de Cambios

Se ha implementado un sistema completo de **facturación, gestión de productos/servicios y reportes** con control de acceso basado en roles (administrador y colaborador).

---

## Nuevas Funcionalidades

### 1. Sistema de Roles y Permisos

#### Roles Implementados:

**Administrador (`admin`)**
- Acceso completo a todos los módulos
- Gestión de productos y servicios
- Visualización de reportes y estadísticas
- Exportación de datos a Excel/PDF
- Anulación de facturas
- Todas las funcionalidades de médico y colaborador

**Médico (`medico`)**
- Gestión de pacientes
- Registro de consultas médicas
- Gestión de citas
- Visualización de historiales

**Colaborador (`colaborador`)**
- Registro de pacientes
- Creación de facturas
- Asociación de productos y servicios a pacientes
- Visualización de facturas
- Marcar facturas como pagadas

#### Credenciales de Acceso:

| Usuario | Contraseña | Rol |
|---------|-----------|-----|
| centro | medico | Administrador |
| colaborador | medico | Colaborador |

**Nota:** Se recomienda cambiar las contraseñas después de la instalación.

---

### 2. Gestión de Productos (Solo Administrador)

**Ubicación:** 📦 Productos (menú lateral)

**Funcionalidades:**
- ✅ Crear nuevos productos
- ✅ Editar productos existentes
- ✅ Desactivar/Activar productos
- ✅ Gestión de stock
- ✅ Control de stock mínimo
- ✅ Historial de cambios de precios
- ✅ Categorización de productos
- ✅ Alertas de stock bajo

**Campos del Producto:**
- Categoría
- Código único
- Nombre
- Descripción
- Precio (₲)
- Stock actual
- Stock mínimo
- Estado (activo/inactivo)

**Categorías Predefinidas:**
- Medicamentos
- Material Médico
- Insumos

**Productos de Ejemplo Incluidos:**
- Paracetamol 500mg
- Ibuprofeno 400mg
- Amoxicilina 500mg
- Jeringa 5ml
- Guantes látex
- Gasas estériles

---

### 3. Gestión de Servicios (Solo Administrador)

**Ubicación:** 🏥 Servicios (menú lateral)

**Funcionalidades:**
- ✅ Crear nuevos servicios
- ✅ Editar servicios existentes
- ✅ Desactivar/Activar servicios
- ✅ Definir duración estimada
- ✅ Historial de cambios de precios
- ✅ Categorización de servicios

**Campos del Servicio:**
- Categoría
- Código único
- Nombre
- Descripción
- Precio (₲)
- Duración estimada (minutos)
- Estado (activo/inactivo)

**Categorías Predefinidas:**
- Consultas
- Procedimientos
- Análisis
- Terapias

**Servicios de Ejemplo Incluidos:**
- Consulta General
- Consulta Especializada
- Curaciones
- Inyección
- Análisis de Sangre
- Electrocardiograma
- Fisioterapia

---

### 4. Sistema de Facturación (Colaborador y Administrador)

**Ubicación:** 💰 Facturación (menú lateral)

#### Proceso de Facturación:

**Paso 1: Buscar Paciente**
- Búsqueda por cédula, nombre o apellido
- Visualización de alertas médicas del paciente
- Selección del paciente

**Paso 2: Agregar Productos**
- Selección de productos del catálogo
- Definición de cantidad
- Verificación automática de stock
- Cálculo automático de subtotales

**Paso 3: Agregar Servicios**
- Selección de servicios del catálogo
- Definición de cantidad
- Cálculo automático de subtotales

**Paso 4: Detalles de Pago**
- Método de pago:
  - Efectivo
  - Tarjeta
  - Transferencia
  - Cheque
  - Otro
- Observaciones adicionales

**Paso 5: Confirmación**
- Visualización del total
- Creación de la factura
- Actualización automática de stock
- Generación de número de factura único

#### Características:

- ✅ Múltiples productos por factura
- ✅ Múltiples servicios por factura
- ✅ Cálculo automático de totales
- ✅ Numeración automática de facturas (FAC-00000001)
- ✅ Control de stock en tiempo real
- ✅ Visualización de alertas médicas
- ✅ Estados de factura: Pendiente, Pagada, Cancelada, Anulada

---

### 5. Gestión de Facturas (Colaborador y Administrador)

**Ubicación:** 📄 Ver Facturas (menú lateral)

**Funcionalidades:**

**Filtros:**
- Por estado: Todas, Pendientes, Pagadas, Anuladas
- Por fecha: Todas, Hoy, Última semana, Este mes

**Acciones sobre Facturas:**
- ✅ Ver detalle completo
- ✅ Marcar como pagada (Colaborador y Admin)
- ✅ Anular factura (Solo Admin)
- ✅ Imprimir factura
- ✅ Devolución automática de stock al anular

**Información Mostrada:**
- Número de factura
- Fecha de emisión
- Paciente
- Total
- Estado
- Método de pago
- Usuario que emitió

---

### 6. Detalle de Factura

**Funcionalidades:**
- ✅ Información completa del paciente
- ✅ Información de la factura
- ✅ Detalle de productos con cantidades y precios
- ✅ Detalle de servicios con cantidades y precios
- ✅ Observaciones
- ✅ Totales (subtotal, descuento, impuesto, total)
- ✅ Función de impresión
- ✅ Diseño optimizado para impresión

---

### 7. Reportes y Recaudación (Solo Administrador)

**Ubicación:** 📊 Reportes (menú lateral)

#### Resumen General:

**Tarjetas de Estadísticas:**
- Total de facturas
- Facturas pagadas
- Facturas pendientes
- Total recaudado (₲)
- Total pendiente (₲)
- Facturas anuladas

#### Reportes Detallados:

**1. Recaudación Diaria**
- Fecha
- Cantidad de facturas
- Total recaudado por día

**2. Productos Más Vendidos (Top 10)**
- Código y nombre del producto
- Cantidad vendida
- Total de ingresos generados

**3. Servicios Más Solicitados (Top 10)**
- Código y nombre del servicio
- Cantidad solicitada
- Total de ingresos generados

**4. Recaudación por Método de Pago**
- Método de pago
- Cantidad de facturas
- Total recaudado por método

**5. Productos con Stock Bajo**
- Alerta visual de productos con stock <= stock mínimo
- Código, nombre, stock actual y stock mínimo

#### Filtros de Reportes:
- Fecha desde
- Fecha hasta
- Exportación a Excel o PDF

---

### 8. Exportación de Datos (Solo Administrador)

**Formatos Disponibles:**

#### Excel (CSV)
- ✅ Compatible con Microsoft Excel
- ✅ Compatible con Google Sheets
- ✅ Codificación UTF-8 con BOM
- ✅ Formato de moneda en Guaraníes
- ✅ Incluye todos los reportes

**Contenido del archivo Excel:**
- Encabezado con información del centro
- Resumen general
- Recaudación diaria
- Productos más vendidos
- Servicios más solicitados

#### PDF (HTML imprimible)
- ✅ Diseño profesional
- ✅ Colores corporativos
- ✅ Gráficos visuales
- ✅ Tablas organizadas
- ✅ Pie de página con fecha de generación
- ✅ Listo para imprimir o guardar como PDF

**Acceso:**
- Desde la página de Reportes
- Botones: 📊 Excel / 📄 PDF
- Respeta los filtros de fecha seleccionados

---

## Estructura de Base de Datos

### Nuevas Tablas Creadas:

#### 1. `categorias`
- Categorías para productos y servicios
- Tipos: producto, servicio

#### 2. `productos`
- Gestión completa de productos
- Control de stock
- Precios
- Estados

#### 3. `servicios`
- Gestión completa de servicios
- Precios
- Duración estimada
- Estados

#### 4. `facturas`
- Registro de facturas
- Numeración automática
- Estados: pendiente, pagada, cancelada, anulada
- Métodos de pago
- Totales

#### 5. `factura_productos`
- Detalle de productos en cada factura
- Cantidades
- Precios unitarios
- Subtotales

#### 6. `factura_servicios`
- Detalle de servicios en cada factura
- Cantidades
- Precios unitarios
- Subtotales

#### 7. `historial_precios`
- Auditoría de cambios de precios
- Registro de usuario que realizó el cambio
- Fecha del cambio
- Precio anterior y nuevo

### Vistas Creadas:

#### 1. `reporte_recaudacion_diaria`
- Resumen de recaudación por día

#### 2. `reporte_recaudacion_mensual`
- Resumen de recaudación por mes

#### 3. `productos_mas_vendidos`
- Top de productos más vendidos

#### 4. `servicios_mas_solicitados`
- Top de servicios más solicitados

---

## Archivos Nuevos Creados

### Base de Datos:
- `database/update_facturacion.sql` - Script de actualización

### Sistema de Permisos:
- `includes/permissions.php` - Gestión de roles y permisos

### Páginas de Administrador:
- `pages/admin/productos.php` - Gestión de productos
- `pages/admin/servicios.php` - Gestión de servicios
- `pages/admin/reportes.php` - Reportes y estadísticas
- `pages/admin/exportar_reportes.php` - Exportación a Excel/PDF

### Páginas de Facturación:
- `pages/facturacion.php` - Nueva factura
- `pages/facturas.php` - Listado de facturas
- `pages/ver_factura.php` - Detalle de factura

### Documentación:
- `ACTUALIZACION_FACTURACION.md` - Este archivo

---

## Archivos Modificados

### `includes/header.php`
- ✅ Integración del sistema de permisos
- ✅ Menú dinámico según rol del usuario
- ✅ Visualización del rol actual
- ✅ Información del usuario logueado

### `database/schema.sql`
- ✅ Actualizado con las nuevas tablas

---

## Instalación de la Actualización

### Paso 1: Backup de la Base de Datos

```bash
mysqldump -u root -p centrobd > backup_centrobd_$(date +%Y%m%d).sql
```

### Paso 2: Ejecutar Script de Actualización

```bash
mysql -u consutorio -pConsult@s centrobd < database/update_facturacion.sql
```

O desde MySQL:

```sql
USE centrobd;
SOURCE /ruta/completa/database/update_facturacion.sql;
```

### Paso 3: Copiar Archivos Nuevos

```bash
# Copiar todos los archivos del sistema actualizado
cp -r sistema-medico/* /var/www/html/sistema-medico/
```

### Paso 4: Verificar Permisos

```bash
# Asegurar permisos correctos
chmod -R 755 /var/www/html/sistema-medico/
chown -R www-data:www-data /var/www/html/sistema-medico/
```

### Paso 5: Limpiar Caché del Navegador

- Presionar `Ctrl + Shift + Delete`
- Seleccionar "Caché" e "Imágenes y archivos en caché"
- Hacer clic en "Borrar datos"

### Paso 6: Probar el Sistema

1. Iniciar sesión como administrador (centro / medico)
2. Verificar que aparezcan los nuevos menús
3. Probar creación de productos
4. Probar creación de servicios
5. Probar facturación
6. Probar reportes
7. Probar exportación

---

## Guía de Uso Rápida

### Para Administradores:

1. **Configurar Productos y Servicios**
   - Ir a 📦 Productos
   - Crear productos necesarios
   - Ir a 🏥 Servicios
   - Crear servicios necesarios

2. **Ver Reportes**
   - Ir a 📊 Reportes
   - Seleccionar rango de fechas
   - Exportar a Excel o PDF si es necesario

3. **Gestionar Facturas**
   - Ver todas las facturas en 📄 Ver Facturas
   - Anular facturas si es necesario
   - Marcar como pagadas

### Para Colaboradores:

1. **Crear Factura**
   - Ir a 💰 Facturación
   - Buscar paciente
   - Agregar productos y servicios
   - Seleccionar método de pago
   - Confirmar factura

2. **Gestionar Facturas**
   - Ver facturas en 📄 Ver Facturas
   - Marcar como pagadas
   - Imprimir facturas

---

## Características de Seguridad

- ✅ Control de acceso basado en roles
- ✅ Validación de permisos en cada página
- ✅ Auditoría de cambios de precios
- ✅ Prevención de SQL injection con prepared statements
- ✅ Sanitización de datos de entrada
- ✅ Transacciones de base de datos para integridad
- ✅ Devolución automática de stock al anular facturas

---

## Moneda y Formato

- **Moneda:** Guaraníes (₲)
- **Formato de números:** 1.000.000 (punto como separador de miles)
- **Formato de fechas:** dd/mm/YYYY
- **Formato de hora:** HH:mm (24 horas)

---

## Compatibilidad

- ✅ Compatible con la versión anterior del sistema
- ✅ No afecta módulos existentes (pacientes, consultas, citas)
- ✅ Responsive para móviles
- ✅ Compatible con navegadores modernos

---

## Soporte y Mantenimiento

### Tareas Recomendadas:

**Diarias:**
- Revisar facturas pendientes
- Verificar stock de productos

**Semanales:**
- Revisar reportes de recaudación
- Verificar productos con stock bajo

**Mensuales:**
- Exportar reportes mensuales
- Backup de base de datos
- Revisar historial de precios

---

## Resolución de Problemas

### Problema: No aparecen los nuevos menús

**Solución:**
1. Verificar que el script SQL se ejecutó correctamente
2. Limpiar caché del navegador
3. Cerrar sesión y volver a iniciar

### Problema: Error al crear factura

**Solución:**
1. Verificar que existan productos/servicios activos
2. Verificar que el paciente exista
3. Verificar stock disponible

### Problema: No se puede exportar a Excel/PDF

**Solución:**
1. Verificar permisos de administrador
2. Verificar que existan datos en el rango de fechas
3. Verificar permisos de escritura en el servidor

---

## Próximas Mejoras Sugeridas

- [ ] Gráficos visuales en reportes (Chart.js)
- [ ] Notificaciones de stock bajo por email
- [ ] Descuentos e impuestos en facturas
- [ ] Múltiples métodos de pago por factura
- [ ] Cuentas corrientes de pacientes
- [ ] Impresión térmica de facturas
- [ ] Envío de facturas por email
- [ ] Integración con sistemas de facturación electrónica

---

**Sistema Médico v2.0 con Facturación**  
**Actualización completada: 2025**  
**Desarrollado para: Centro Médico**
