<?php
/**
 * Calendario de Vacunas - Paciente
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_rol('paciente');

$titulo_pagina = 'Calendario de Vacunas';

$dueno_id = $_SESSION['usuario_id'];

try {
    $db = Database::getInstance()->getConnection();
    
    // Obtener todas las vacunas de todas las mascotas del dueño
    $stmt = $db->prepare("SELECT v.*, m.nombre as mascota_nombre, m.tipo_mascota, u.nombre_completo as profesional_nombre
                          FROM vacunas v
                          INNER JOIN mascotas m ON v.mascota_id = m.id
                          LEFT JOIN usuarios u ON v.profesional_id = u.id
                          WHERE m.dueno_id = :dueno_id AND m.activo = 1
                          ORDER BY v.proxima_dosis ASC, v.fecha_aplicacion DESC");
    $stmt->execute(['dueno_id' => $dueno_id]);
    $vacunas = $stmt->fetchAll();
    
    // Clasificar vacunas
    $vacunas_vencidas = [];
    $vacunas_proximas = [];
    $vacunas_al_dia = [];
    
    $hoy = new DateTime();
    
    foreach ($vacunas as $vacuna) {
        if ($vacuna['proxima_dosis']) {
            $proxima = new DateTime($vacuna['proxima_dosis']);
            $diff = $proxima->diff($hoy);
            
            if ($proxima < $hoy) {
                $vacunas_vencidas[] = $vacuna;
            } elseif ($diff->days <= 30) {
                $vacunas_proximas[] = $vacuna;
            } else {
                $vacunas_al_dia[] = $vacuna;
            }
        } else {
            $vacunas_al_dia[] = $vacuna;
        }
    }
    
} catch (PDOException $e) {
    die("Error en la base de datos: " . $e->getMessage());
}

include '../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-12">
        <h1><i class="bi bi-shield-check"></i> Calendario de Vacunas</h1>
        <p class="text-muted">Mantenga al día las vacunas de sus mascotas</p>
    </div>
</div>

<!-- Resumen -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card bg-danger text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2">Vacunas Vencidas</h6>
                <h2 class="card-title mb-0"><?php echo count($vacunas_vencidas); ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2">Próximas (30 días)</h6>
                <h2 class="card-title mb-0"><?php echo count($vacunas_proximas); ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2">Al Día</h6>
                <h2 class="card-title mb-0"><?php echo count($vacunas_al_dia); ?></h2>
            </div>
        </div>
    </div>
</div>

<!-- Vacunas Vencidas -->
<?php if (count($vacunas_vencidas) > 0): ?>
    <div class="card mb-4 border-danger">
        <div class="card-header bg-danger text-white">
            <h5 class="mb-0"><i class="bi bi-exclamation-triangle-fill"></i> Vacunas Vencidas - ¡Requieren Atención Inmediata!</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Mascota</th>
                            <th>Vacuna</th>
                            <th>Última Aplicación</th>
                            <th>Debió Aplicarse</th>
                            <th>Días Vencida</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($vacunas_vencidas as $vacuna): ?>
                            <?php
                            $proxima = new DateTime($vacuna['proxima_dosis']);
                            $hoy = new DateTime();
                            $dias_vencida = $hoy->diff($proxima)->days;
                            ?>
                            <tr>
                                <td>
                                    <strong><?php echo htmlspecialchars($vacuna['mascota_nombre']); ?></strong>
                                    <br><small class="text-muted"><?php echo ucfirst($vacuna['tipo_mascota']); ?></small>
                                </td>
                                <td><?php echo htmlspecialchars($vacuna['nombre_vacuna']); ?></td>
                                <td><?php echo formatear_fecha($vacuna['fecha_aplicacion']); ?></td>
                                <td><?php echo formatear_fecha($vacuna['proxima_dosis']); ?></td>
                                <td><span class="badge bg-danger"><?php echo $dias_vencida; ?> días</span></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="alert alert-danger mb-0 mt-3">
                <i class="bi bi-exclamation-triangle-fill"></i> 
                <strong>¡Importante!</strong> Contacte con la veterinaria lo antes posible para programar estas vacunas.
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Vacunas Próximas -->
<?php if (count($vacunas_proximas) > 0): ?>
    <div class="card mb-4 border-warning">
        <div class="card-header bg-warning text-white">
            <h5 class="mb-0"><i class="bi bi-clock"></i> Vacunas Próximas (30 días)</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Mascota</th>
                            <th>Vacuna</th>
                            <th>Última Aplicación</th>
                            <th>Próxima Dosis</th>
                            <th>Días Restantes</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($vacunas_proximas as $vacuna): ?>
                            <?php
                            $proxima = new DateTime($vacuna['proxima_dosis']);
                            $hoy = new DateTime();
                            $dias_restantes = $hoy->diff($proxima)->days;
                            ?>
                            <tr>
                                <td>
                                    <strong><?php echo htmlspecialchars($vacuna['mascota_nombre']); ?></strong>
                                    <br><small class="text-muted"><?php echo ucfirst($vacuna['tipo_mascota']); ?></small>
                                </td>
                                <td><?php echo htmlspecialchars($vacuna['nombre_vacuna']); ?></td>
                                <td><?php echo formatear_fecha($vacuna['fecha_aplicacion']); ?></td>
                                <td><?php echo formatear_fecha($vacuna['proxima_dosis']); ?></td>
                                <td><span class="badge bg-warning"><?php echo $dias_restantes; ?> días</span></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Vacunas Al Día -->
<?php if (count($vacunas_al_dia) > 0): ?>
    <div class="card border-success">
        <div class="card-header bg-success text-white">
            <h5 class="mb-0"><i class="bi bi-check-circle"></i> Vacunas Al Día</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Mascota</th>
                            <th>Vacuna</th>
                            <th>Última Aplicación</th>
                            <th>Próxima Dosis</th>
                            <th>Profesional</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($vacunas_al_dia as $vacuna): ?>
                            <tr>
                                <td>
                                    <strong><?php echo htmlspecialchars($vacuna['mascota_nombre']); ?></strong>
                                    <br><small class="text-muted"><?php echo ucfirst($vacuna['tipo_mascota']); ?></small>
                                </td>
                                <td><?php echo htmlspecialchars($vacuna['nombre_vacuna']); ?></td>
                                <td><?php echo formatear_fecha($vacuna['fecha_aplicacion']); ?></td>
                                <td>
                                    <?php if ($vacuna['proxima_dosis']): ?>
                                        <?php echo formatear_fecha($vacuna['proxima_dosis']); ?>
                                    <?php else: ?>
                                        <span class="badge bg-success">Completa</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo htmlspecialchars($vacuna['profesional_nombre'] ?? '-'); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if (count($vacunas) === 0): ?>
    <div class="card">
        <div class="card-body text-center py-5">
            <i class="bi bi-shield-check" style="font-size: 5rem; color: #ccc;"></i>
            <h4 class="mt-3">No hay vacunas registradas</h4>
            <p class="text-muted">Cuando sus mascotas reciban vacunas, aparecerán aquí</p>
        </div>
    </div>
<?php endif; ?>

<?php include '../includes/footer.php'; ?>
