<?php
/**
 * Encabezado Común
 * Sistema de Administración de Veterinaria
 */

if (!defined('BASE_PATH')) {
    die('Acceso no autorizado');
}

$nombre_usuario = $_SESSION['nombre'] ?? 'Usuario';
$rol_usuario = $_SESSION['rol'] ?? '';
$rol_texto = '';

switch ($rol_usuario) {
    case 'administrador':
        $rol_texto = 'Administrador';
        break;
    case 'colaborador':
        $rol_texto = 'Colaborador';
        break;
    case 'paciente':
        $rol_texto = 'Dueño de Mascota';
        break;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="base-url" content="<?php echo BASE_URL; ?>">
    <title><?php echo $titulo_pagina ?? APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/style.css">
    <?php if (isset($css_adicional)): ?>
        <?php foreach ($css_adicional as $css): ?>
            <link rel="stylesheet" href="<?php echo $css; ?>">
        <?php endforeach; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Barra de navegación -->
    <nav class="navbar navbar-dark bg-primary fixed-top" style="padding: 0;">
        <!-- Fila superior: Logo y nombre -->
        <div class="container-fluid bg-primary" style="padding: 0.5rem 1rem; border-bottom: 1px solid rgba(255,255,255,0.1);">
            <a class="navbar-brand" href="<?php echo BASE_URL; ?>/index.php" style="margin: 0; font-size: 1.2rem;">
                <img src="<?php echo BASE_URL; ?>/assets/images/logo.png" alt="Logo" height="35" class="d-inline-block align-text-top me-2">
                <strong><?php echo APP_NAME; ?></strong>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" style="border: none;">
                <span class="navbar-toggler-icon"></span>
            </button>
        </div>
        
        <!-- Fila inferior: Menús -->
        <div class="container-fluid" style="padding: 0.25rem 1rem;">
            <div class="collapse navbar-collapse" id="navbarNav">
                <!-- Perfil de usuario a la izquierda -->
                <ul class="navbar-nav me-3" style="margin: 0;">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" style="white-space: nowrap;">
                            <i class="bi bi-person-circle"></i> <span class="d-none d-xl-inline"><?php echo htmlspecialchars($nombre_usuario); ?></span>
                            <span class="badge bg-light text-dark ms-1"><?php echo $rol_texto; ?></span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>/perfil.php">
                                <i class="bi bi-person"></i> Mi Perfil
                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>/logout.php">
                                <i class="bi bi-box-arrow-right"></i> Cerrar Sesión
                            </a></li>
                        </ul>
                    </li>
                </ul>
                <!-- Menú principal -->
                <ul class="navbar-nav me-auto">
                    <?php if ($rol_usuario === 'administrador'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/admin/index.php">
                                <i class="bi bi-speedometer2"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/admin/colaboradores.php">
                                <i class="bi bi-people"></i> Colaboradores
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/colaborador/duenos.php">
                                <i class="bi bi-person-hearts"></i> Dueños
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/admin/mascotas.php">
                                <i class="bi bi-heart"></i> Mascotas
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/admin/tratamientos.php">
                                <i class="bi bi-clipboard-pulse"></i> Tratamientos
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/admin/medicamentos.php">
                                <i class="bi bi-capsule"></i> Medicamentos
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/admin/promociones.php">
                                <i class="bi bi-tag"></i> Promociones
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/admin/reportes.php">
                                <i class="bi bi-file-earmark-bar-graph"></i> Reportes
                            </a>
                        </li>
                    <?php elseif ($rol_usuario === 'colaborador'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/colaborador/index.php">
                                <i class="bi bi-house"></i> Inicio
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/colaborador/duenos.php">
                                <i class="bi bi-people"></i> Dueños
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/colaborador/mascotas.php">
                                <i class="bi bi-heart"></i> Mascotas
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/colaborador/nueva_visita.php">
                                <i class="bi bi-plus-circle"></i> Nueva Visita
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/colaborador/buscar.php">
                                <i class="bi bi-search"></i> Buscar
                            </a>
                        </li>
                    <?php elseif ($rol_usuario === 'paciente'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/paciente/index.php">
                                <i class="bi bi-house"></i> Mis Mascotas
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo BASE_URL; ?>/paciente/vacunas.php">
                                <i class="bi bi-calendar-check"></i> Vacunas
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
                <!-- Búsqueda global -->
                <?php if ($rol_usuario === 'colaborador' || $rol_usuario === 'administrador'): ?>
                <form class="d-flex position-relative" style="width: 200px; margin: 0;">
                    <input class="form-control form-control-sm" type="search" id="buscarGlobal" placeholder="Buscar..." autocomplete="off">
                </form>
                <?php endif; ?>
            </div>
        </div>
    </nav>
    
    <!-- Modal de Cumpleaños -->
    <?php if ($rol_usuario === 'colaborador' || $rol_usuario === 'administrador'): ?>
        <?php include __DIR__ . '/modal_cumpleanos.php'; ?>
    <?php endif; ?>
    
    <!-- Contenido principal -->
    <main class="main-content">
        <div class="container-fluid py-4">
            <?php mostrar_mensaje(); ?>
