<?php
/**
 * Registrar Nuevo Dueño
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    header('Location: ' . BASE_URL . '/index.php');
    exit();
}

$titulo_pagina = 'Registrar Nuevo Dueño';

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $db = Database::getInstance()->getConnection();
        
        $dueno_nombre = limpiar_entrada($_POST['dueno_nombre']);
        $dueno_cedula = limpiar_entrada($_POST['dueno_cedula']);
        $dueno_direccion = limpiar_entrada($_POST['dueno_direccion']);
        $dueno_telefono = limpiar_entrada($_POST['dueno_telefono']);
        $tiene_whatsapp = isset($_POST['tiene_whatsapp']) ? 1 : 0;
        $tiene_telegram = isset($_POST['tiene_telegram']) ? 1 : 0;
        $dueno_email = limpiar_entrada($_POST['dueno_email']);
        
        // Verificar si el dueño ya existe
        $stmt = $db->prepare("SELECT id FROM duenos WHERE telefono = :telefono OR cedula = :cedula LIMIT 1");
        $stmt->execute(['telefono' => $dueno_telefono, 'cedula' => $dueno_cedula]);
        $dueno_existente = $stmt->fetch();
        
        if ($dueno_existente) {
            $_SESSION['error'] = 'Ya existe un dueño con ese teléfono o cédula';
        } else {
            // Crear nuevo dueño
            $usuario_paciente = strtolower(str_replace(' ', '', $dueno_nombre)) . rand(100, 999);
            $contrasena_hash = password_hash('mascota' . rand(1000, 9999), PASSWORD_DEFAULT);
            
            $stmt = $db->prepare("INSERT INTO duenos (nombre_completo, cedula, direccion, telefono, 
                                  tiene_whatsapp, tiene_telegram, email, usuario_paciente, contrasena_paciente) 
                                  VALUES (:nombre, :cedula, :direccion, :telefono, :whatsapp, :telegram, :email, :usuario, :contrasena)");
            $stmt->execute([
                'nombre' => $dueno_nombre,
                'cedula' => $dueno_cedula,
                'direccion' => $dueno_direccion,
                'telefono' => $dueno_telefono,
                'whatsapp' => $tiene_whatsapp,
                'telegram' => $tiene_telegram,
                'email' => $dueno_email,
                'usuario' => $usuario_paciente,
                'contrasena' => $contrasena_hash
            ]);
            $dueno_id = $db->lastInsertId();
            
            $_SESSION['exito'] = 'Dueño registrado exitosamente';
            
            // Redirigir a agregar mascota
            header('Location: agregar_mascota.php?dueno_id=' . $dueno_id);
            exit();
        }
        
    } catch (PDOException $e) {
        $error = 'Error al registrar el dueño: ' . $e->getMessage();
    }
}

include '../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-md-12">
        <h1><i class="bi bi-person-plus"></i> Registrar Nuevo Dueño</h1>
        <p class="text-muted">Complete los datos del dueño. Después podrá agregar sus mascotas.</p>
    </div>
</div>

<?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="bi bi-exclamation-triangle"></i> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (isset($error)): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="bi bi-exclamation-triangle"></i> <?php echo $error; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<form method="POST" action="">
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-person"></i> Datos del Dueño</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Nombre Completo *</label>
                        <input type="text" class="form-control" name="dueno_nombre" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Cédula de Identidad</label>
                        <input type="text" class="form-control" name="dueno_cedula" placeholder="1234567">
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Teléfono *</label>
                        <input type="text" class="form-control" name="dueno_telefono" 
                               placeholder="+595..." required>
                        <small class="text-muted">Formato: +595 + número</small>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" class="form-control" name="dueno_email">
                    </div>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">Dirección</label>
                <textarea class="form-control" name="dueno_direccion" rows="2"></textarea>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="tiene_whatsapp" id="tiene_whatsapp">
                        <label class="form-check-label" for="tiene_whatsapp">
                            <i class="bi bi-whatsapp text-success"></i> Tiene WhatsApp
                        </label>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="tiene_telegram" id="tiene_telegram">
                        <label class="form-check-label" for="tiene_telegram">
                            <i class="bi bi-telegram text-info"></i> Tiene Telegram
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card mt-3">
        <div class="card-body text-center">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="bi bi-save"></i> Registrar Dueño y Continuar
            </button>
            <a href="duenos.php" class="btn btn-secondary btn-lg">
                <i class="bi bi-x-circle"></i> Cancelar
            </a>
        </div>
    </div>
</form>

<?php include '../includes/footer.php'; ?>
