<?php
/**
 * Eliminar Dueño (Soft Delete)
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    header('Location: ' . BASE_URL . '/index.php');
    exit();
}

// Verificar que se recibió un ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: ' . BASE_URL . '/colaborador/duenos.php');
    exit();
}

$dueno_id = (int)$_GET['id'];

try {
    $db = Database::getInstance()->getConnection();
    
    // Verificar que el dueño existe
    $stmt = $db->prepare("SELECT id, nombre_completo FROM duenos WHERE id = :id");
    $stmt->execute(['id' => $dueno_id]);
    $dueno = $stmt->fetch();
    
    if (!$dueno) {
        $_SESSION['error'] = 'El dueño no existe';
        header('Location: ' . BASE_URL . '/colaborador/duenos.php');
        exit();
    }
    
    // Verificar que no tiene mascotas activas
    $stmt = $db->prepare("SELECT COUNT(*) as total FROM mascotas WHERE dueno_id = :id AND activo = 1");
    $stmt->execute(['id' => $dueno_id]);
    $resultado = $stmt->fetch();
    
    if ($resultado['total'] > 0) {
        $_SESSION['error'] = 'No se puede eliminar el dueño porque tiene ' . $resultado['total'] . ' mascota(s) activa(s)';
        header('Location: ' . BASE_URL . '/colaborador/duenos.php');
        exit();
    }
    
    // Eliminar dueño (solo si no tiene mascotas activas)
    $stmt = $db->prepare("DELETE FROM duenos WHERE id = :id");
    $stmt->execute(['id' => $dueno_id]);
    
    $_SESSION['exito'] = 'Dueño "' . htmlspecialchars($dueno['nombre_completo']) . '" eliminado exitosamente';
    
} catch (PDOException $e) {
    $_SESSION['error'] = 'Error al eliminar el dueño: ' . $e->getMessage();
}

header('Location: ' . BASE_URL . '/colaborador/duenos.php');
exit();
