<?php
/**
 * API de Búsqueda de Dueños
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

header('Content-Type: application/json');

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    echo json_encode(['error' => 'Acceso denegado']);
    exit();
}

$termino = $_GET['q'] ?? '';

if (strlen($termino) < 2) {
    echo json_encode([]);
    exit();
}

try {
    $db = Database::getInstance()->getConnection();
    
    // Buscar dueños por nombre, cédula o teléfono
    $stmt = $db->prepare("SELECT d.*, COUNT(m.id) as total_mascotas
                          FROM duenos d
                          LEFT JOIN mascotas m ON d.id = m.dueno_id AND m.activo = 1
                          WHERE (d.nombre_completo LIKE :termino 
                               OR d.cedula LIKE :termino 
                               OR d.telefono LIKE :termino)
                          GROUP BY d.id
                          ORDER BY d.nombre_completo ASC
                          LIMIT 10");
    
    $termino_busqueda = '%' . $termino . '%';
    $stmt->execute(['termino' => $termino_busqueda]);
    $duenos = $stmt->fetchAll();
    
    $resultados = [];
    foreach ($duenos as $dueno) {
        $resultados[] = [
            'id' => $dueno['id'],
            'nombre_completo' => $dueno['nombre_completo'],
            'cedula' => $dueno['cedula'],
            'telefono' => $dueno['telefono'],
            'email' => $dueno['email'],
            'direccion' => $dueno['direccion'],
            'tiene_whatsapp' => (bool)$dueno['tiene_whatsapp'],
            'tiene_telegram' => (bool)$dueno['tiene_telegram'],
            'total_mascotas' => (int)$dueno['total_mascotas'],
            'label' => $dueno['nombre_completo'] . ' - ' . $dueno['cedula'] . ' (' . $dueno['total_mascotas'] . ' mascota' . ($dueno['total_mascotas'] != 1 ? 's' : '') . ')'
        ];
    }
    
    echo json_encode($resultados);
    
} catch (PDOException $e) {
    echo json_encode(['error' => 'Error en la búsqueda: ' . $e->getMessage()]);
}
