<?php
/**
 * API de Búsqueda AJAX
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    http_response_code(403);
    echo json_encode(['error' => 'Acceso denegado']);
    exit();
}

header('Content-Type: application/json');

$termino = isset($_GET['q']) ? limpiar_entrada($_GET['q']) : '';

if (empty($termino) || strlen($termino) < 2) {
    echo json_encode([]);
    exit();
}

try {
    $db = Database::getInstance()->getConnection();
    
    // Buscar mascotas
    $stmt = $db->prepare("SELECT m.id, m.nombre, m.tipo_mascota, m.raza, m.codigo_barras, m.foto,
                                 d.nombre_completo as dueno_nombre, d.telefono, d.cedula
                          FROM mascotas m
                          INNER JOIN duenos d ON m.dueno_id = d.id
                          WHERE (m.nombre LIKE :termino 
                             OR d.nombre_completo LIKE :termino
                             OR d.telefono LIKE :termino
                             OR d.cedula LIKE :termino
                             OR m.codigo_barras LIKE :termino)
                             AND m.activo = 1
                          ORDER BY m.nombre
                          LIMIT 10");
    $stmt->execute(['termino' => '%' . $termino . '%']);
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Formatear resultados
    $mascotas = [];
    foreach ($resultados as $mascota) {
        $mascotas[] = [
            'id' => $mascota['id'],
            'nombre' => $mascota['nombre'],
            'tipo' => ucfirst($mascota['tipo_mascota']),
            'raza' => $mascota['raza'] ?? '',
            'codigo' => $mascota['codigo_barras'],
            'dueno' => $mascota['dueno_nombre'],
            'telefono' => $mascota['telefono'],
            'cedula' => $mascota['cedula'] ?? '',
            'foto' => $mascota['foto'] ? BASE_URL . '/uploads/mascotas/' . $mascota['foto'] : null
        ];
    }
    
    echo json_encode($mascotas);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Error en la búsqueda']);
}
