<?php
/**
 * Dashboard del Administrador
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_rol('administrador');

$titulo_pagina = 'Dashboard - Administrador';

try {
    $db = Database::getInstance()->getConnection();
    
    // Obtener estadísticas
    $stmt = $db->query("SELECT COUNT(*) as total FROM mascotas WHERE activo = 1");
    $total_mascotas = $stmt->fetch()['total'];
    
    $stmt = $db->query("SELECT COUNT(*) as total FROM usuarios WHERE rol = 'colaborador' AND activo = 1");
    $total_colaboradores = $stmt->fetch()['total'];
    
    $stmt = $db->query("SELECT COUNT(*) as total FROM visitas WHERE DATE(fecha_visita) = CURDATE()");
    $visitas_hoy = $stmt->fetch()['total'];
    
    $stmt = $db->query("SELECT COALESCE(SUM(total), 0) as total FROM facturas WHERE estado = 'pagada' AND DATE(fecha_factura) = CURDATE()");
    $ingresos_hoy = $stmt->fetch()['total'];
    
    // Ingresos por período
    $stmt = $db->query("SELECT COALESCE(SUM(total), 0) as total FROM facturas WHERE estado = 'pagada' AND WEEK(fecha_factura) = WEEK(CURDATE())");
    $ingresos_semana = $stmt->fetch()['total'];
    
    $stmt = $db->query("SELECT COALESCE(SUM(total), 0) as total FROM facturas WHERE estado = 'pagada' AND MONTH(fecha_factura) = MONTH(CURDATE())");
    $ingresos_mes = $stmt->fetch()['total'];
    
    $stmt = $db->query("SELECT COALESCE(SUM(total), 0) as total FROM facturas WHERE estado = 'pagada' AND YEAR(fecha_factura) = YEAR(CURDATE())");
    $ingresos_ano = $stmt->fetch()['total'];
    
    // Próximas citas
    $stmt = $db->query("SELECT v.*, m.nombre as mascota_nombre, d.nombre_completo as dueno_nombre, u.nombre_completo as profesional_nombre
                        FROM visitas v
                        INNER JOIN mascotas m ON v.mascota_id = m.id
                        INNER JOIN duenos d ON m.dueno_id = d.id
                        INNER JOIN usuarios u ON v.profesional_id = u.id
                        WHERE v.proxima_cita >= CURDATE()
                        ORDER BY v.proxima_cita ASC
                        LIMIT 5");
    $proximas_citas = $stmt->fetchAll();
    
    // Vacunas próximas a vencer
    $stmt = $db->query("SELECT v.*, m.nombre as mascota_nombre, d.nombre_completo as dueno_nombre, d.telefono
                        FROM vacunas v
                        INNER JOIN mascotas m ON v.mascota_id = m.id
                        INNER JOIN duenos d ON m.dueno_id = d.id
                        WHERE v.proxima_dosis BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 30 DAY)
                        ORDER BY v.proxima_dosis ASC
                        LIMIT 5");
    $vacunas_proximas = $stmt->fetchAll();
    
} catch (PDOException $e) {
    die("Error en la base de datos: " . $e->getMessage());
}

include '../includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <h1 class="mb-4"><i class="bi bi-speedometer2"></i> Dashboard del Administrador</h1>
    </div>
</div>

<!-- Tarjetas de estadísticas -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-subtitle mb-2">Mascotas Registradas</h6>
                        <h2 class="card-title mb-0"><?php echo formatear_numero($total_mascotas); ?></h2>
                    </div>
                    <div class="fs-1">
                        <i class="bi bi-heart-fill"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-subtitle mb-2">Colaboradores Activos</h6>
                        <h2 class="card-title mb-0"><?php echo formatear_numero($total_colaboradores); ?></h2>
                    </div>
                    <div class="fs-1">
                        <i class="bi bi-people-fill"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-subtitle mb-2">Visitas Hoy</h6>
                        <h2 class="card-title mb-0"><?php echo formatear_numero($visitas_hoy); ?></h2>
                    </div>
                    <div class="fs-1">
                        <i class="bi bi-calendar-check-fill"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-subtitle mb-2">Ingresos Hoy</h6>
                        <h2 class="card-title mb-0"><?php echo formatear_moneda($ingresos_hoy); ?></h2>
                    </div>
                    <div class="fs-1">
                        <i class="bi bi-cash-coin"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Ingresos por período -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-dark text-white">
                <h5 class="mb-0"><i class="bi bi-graph-up"></i> Estado de Cuenta</h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-md-3">
                        <h6 class="text-muted">Hoy</h6>
                        <h4 class="text-primary"><?php echo formatear_moneda($ingresos_hoy); ?></h4>
                    </div>
                    <div class="col-md-3">
                        <h6 class="text-muted">Esta Semana</h6>
                        <h4 class="text-success"><?php echo formatear_moneda($ingresos_semana); ?></h4>
                    </div>
                    <div class="col-md-3">
                        <h6 class="text-muted">Este Mes</h6>
                        <h4 class="text-info"><?php echo formatear_moneda($ingresos_mes); ?></h4>
                    </div>
                    <div class="col-md-3">
                        <h6 class="text-muted">Este Año</h6>
                        <h4 class="text-warning"><?php echo formatear_moneda($ingresos_ano); ?></h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Próximas citas -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-calendar-event"></i> Próximas Citas</h5>
            </div>
            <div class="card-body">
                <?php if (count($proximas_citas) > 0): ?>
                    <div class="list-group list-group-flush">
                        <?php foreach ($proximas_citas as $cita): ?>
                            <div class="list-group-item">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1"><?php echo htmlspecialchars($cita['mascota_nombre']); ?></h6>
                                    <small class="text-muted"><?php echo formatear_fecha($cita['proxima_cita']); ?></small>
                                </div>
                                <p class="mb-1"><small>Dueño: <?php echo htmlspecialchars($cita['dueno_nombre']); ?></small></p>
                                <small class="text-muted">Profesional: <?php echo htmlspecialchars($cita['profesional_nombre']); ?></small>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center mb-0">No hay citas programadas</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Vacunas próximas -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-shield-check"></i> Vacunas Próximas (30 días)</h5>
            </div>
            <div class="card-body">
                <?php if (count($vacunas_proximas) > 0): ?>
                    <div class="list-group list-group-flush">
                        <?php foreach ($vacunas_proximas as $vacuna): ?>
                            <div class="list-group-item">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1"><?php echo htmlspecialchars($vacuna['mascota_nombre']); ?></h6>
                                    <small class="text-muted"><?php echo formatear_fecha($vacuna['proxima_dosis']); ?></small>
                                </div>
                                <p class="mb-1"><small>Vacuna: <?php echo htmlspecialchars($vacuna['nombre_vacuna']); ?></small></p>
                                <small class="text-muted">Dueño: <?php echo htmlspecialchars($vacuna['dueno_nombre']); ?> - <?php echo htmlspecialchars($vacuna['telefono']); ?></small>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center mb-0">No hay vacunas próximas</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
