# Sistema de Administración de Veterinaria

Sistema completo de gestión para veterinarias desarrollado en PHP con MySQL.

## Estructura del Proyecto

```
veterinaria/
├── assets/                 # Recursos estáticos
│   ├── css/               # Hojas de estilo
│   ├── js/                # Scripts JavaScript
│   └── images/            # Imágenes del sistema
├── config/                # Archivos de configuración
│   ├── config.php         # Configuración general
│   └── database.php       # Configuración de base de datos
├── database/              # Scripts de base de datos
│   └── schema.sql         # Esquema de la base de datos
├── includes/              # Archivos PHP incluidos
│   ├── header.php         # Encabezado común
│   ├── footer.php         # Pie de página común
│   └── funciones.php      # Funciones auxiliares
├── uploads/               # Archivos subidos
│   ├── mascotas/          # Fotos de mascotas
│   ├── credenciales/      # Credenciales generadas
│   └── reportes/          # Reportes PDF
├── admin/                 # Módulo de administrador
├── colaborador/           # Módulo de colaborador
├── paciente/              # Módulo de paciente
├── login.php              # Página de inicio de sesión
├── logout.php             # Cerrar sesión
└── index.php              # Página principal
```

## Características Principales

### Módulo Administrador
- Gestión completa de colaboradores
- Administración de tarifas y tratamientos
- Gestión de medicamentos y precios
- Reportes y estadísticas por período
- Creación de promociones
- Exportación de reportes

### Módulo Colaborador
- Registro y gestión de mascotas
- Búsqueda avanzada (teléfono, cédula, nombre)
- Calendario de vacunación
- Facturación por visita
- Generación de reportes PDF
- Integración con WhatsApp y Telegram
- Generación de credenciales con código de barras

### Módulo Paciente
- Consulta de datos de mascotas
- Historial de vacunación
- Alertas de próximas vacunas
- Visualización de credencial

## Requisitos del Sistema

- PHP 7.4 o superior
- MySQL 5.7 o superior
- Apache con mod_rewrite habilitado
- Extensiones PHP: PDO, GD, mbstring

## Instalación

1. Importar el archivo `database/schema.sql` en MySQL
2. Configurar las credenciales en `config/database.php`
3. Asegurar permisos de escritura en carpeta `uploads/`
4. Acceder al sistema con las credenciales por defecto

## Credenciales de Acceso

### Base de Datos
- Base de datos: `veterinaria`
- Usuario: `mascotas`
- Contraseña: `@nim@les2025`

### Administrador
- Usuario: `Veterinaria`
- Contraseña: `m@scot@`

## Configuración Regional

- Moneda: Guaraníes (Gs.)
- Formato de números: Con puntos de miles
- Zona horaria: America/Asuncion
- Formato de fecha: DD/MM/YYYY

## Soporte

Para soporte técnico o consultas, contactar al administrador del sistema.

## Versión

1.0.0 - Noviembre 2025
