<?php
/**
 * Script de prueba de conexión y productos
 * Acceder desde: http://tu-dominio.com/test_conexion.php
 */

echo "<h1>Test de Conexión - Sistema Tiendas V3.0</h1>";

// Test 1: Conexión a base de datos
echo "<h2>1. Test de Conexión a Base de Datos</h2>";
try {
    require_once 'config/database.php';
    $db = getDB();
    echo "✅ <strong>Conexión exitosa</strong><br>";
    echo "Driver: " . $db->getAttribute(PDO::ATTR_DRIVER_NAME) . "<br>";
} catch (Exception $e) {
    echo "❌ <strong>Error de conexión:</strong> " . $e->getMessage() . "<br>";
    die();
}

// Test 2: Verificar tablas
echo "<h2>2. Verificar Tablas</h2>";
try {
    $stmt = $db->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "✅ <strong>Tablas encontradas:</strong> " . count($tables) . "<br>";
    echo "<ul>";
    foreach ($tables as $table) {
        echo "<li>$table</li>";
    }
    echo "</ul>";
} catch (Exception $e) {
    echo "❌ <strong>Error:</strong> " . $e->getMessage() . "<br>";
}

// Test 3: Contar productos
echo "<h2>3. Productos en la Base de Datos</h2>";
try {
    $stmt = $db->query("SELECT COUNT(*) as total FROM productos");
    $result = $stmt->fetch();
    $total = $result['total'];
    
    echo "✅ <strong>Total de productos:</strong> $total<br><br>";
    
    if ($total > 0) {
        echo "<h3>Primeros 5 productos:</h3>";
        $stmt = $db->query("SELECT codigo_barras, nombre, precio, stock, activo FROM productos LIMIT 5");
        $productos = $stmt->fetchAll();
        
        echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
        echo "<tr><th>Código de Barras</th><th>Nombre</th><th>Precio</th><th>Stock</th><th>Activo</th></tr>";
        foreach ($productos as $p) {
            $activo = $p['activo'] ? '✅' : '❌';
            echo "<tr>";
            echo "<td>{$p['codigo_barras']}</td>";
            echo "<td>{$p['nombre']}</td>";
            echo "<td>₲ " . number_format($p['precio'], 0, ',', '.') . "</td>";
            echo "<td>{$p['stock']}</td>";
            echo "<td>$activo</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "⚠️ <strong>No hay productos en la base de datos</strong><br>";
        echo "<p>Ejecuta el archivo <code>database_setup.sql</code> para insertar productos de ejemplo.</p>";
    }
} catch (Exception $e) {
    echo "❌ <strong>Error:</strong> " . $e->getMessage() . "<br>";
}

// Test 4: Verificar clientes
echo "<h2>4. Clientes Registrados</h2>";
try {
    $stmt = $db->query("SELECT COUNT(*) as total FROM clientes");
    $result = $stmt->fetch();
    echo "✅ <strong>Total de clientes:</strong> " . $result['total'] . "<br>";
} catch (Exception $e) {
    echo "❌ <strong>Error:</strong> " . $e->getMessage() . "<br>";
}

// Test 5: Verificar usuarios admin
echo "<h2>5. Usuarios Administrativos</h2>";
try {
    $stmt = $db->query("SELECT username, rol, activo FROM usuarios_admin");
    $usuarios = $stmt->fetchAll();
    
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
    echo "<tr><th>Usuario</th><th>Rol</th><th>Activo</th></tr>";
    foreach ($usuarios as $u) {
        $activo = $u['activo'] ? '✅' : '❌';
        echo "<tr><td>{$u['username']}</td><td>{$u['rol']}</td><td>$activo</td></tr>";
    }
    echo "</table>";
} catch (Exception $e) {
    echo "❌ <strong>Error:</strong> " . $e->getMessage() . "<br>";
}

// Test 6: Configuración PHP
echo "<h2>6. Configuración PHP</h2>";
echo "✅ <strong>Versión de PHP:</strong> " . phpversion() . "<br>";
echo "✅ <strong>PDO MySQL:</strong> " . (extension_loaded('pdo_mysql') ? 'Instalado' : '❌ No instalado') . "<br>";
echo "✅ <strong>Session:</strong> " . (extension_loaded('session') ? 'Disponible' : '❌ No disponible') . "<br>";
echo "✅ <strong>JSON:</strong> " . (extension_loaded('json') ? 'Disponible' : '❌ No disponible') . "<br>";

echo "<hr>";
echo "<p><strong>✅ Test completado</strong></p>";
echo "<p><a href='index.php'>← Volver al sistema</a></p>";
?>
