<?php
/**
 * Página de bienvenida para nuevos clientes
 * Sistema de Supermercados y Tiendas V3.0
 */

require_once '../config/database.php';
require_once '../config/functions.php';

iniciarSesion();

// Verificar autenticación
if (!estaAutenticadoCliente()) {
    redirigir('../index.php');
}

$cliente = obtenerClienteActual();
$esNuevoRegistro = isset($_SESSION['nuevo_registro']) && $_SESSION['nuevo_registro'];

// Si no es nuevo registro, redirigir al dashboard
if (!$esNuevoRegistro) {
    redirigir('dashboard.php');
}

// Obtener promociones activas
$db = getDB();
$stmt = $db->prepare("
    SELECT titulo, descripcion 
    FROM promociones 
    WHERE activo = 1 
    AND (fecha_fin IS NULL OR fecha_fin > NOW())
    ORDER BY fecha_creacion DESC 
    LIMIT 3
");
$stmt->execute();
$promociones = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bienvenido - Sistema de Tiendas V3.0</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <meta http-equiv="refresh" content="7;url=dashboard.php">
</head>
<body class="bienvenida-page">
    <div class="bienvenida-container">
        <div class="bienvenida-card">
            <div class="bienvenida-header">
                <img src="../assets/images/logo.png" alt="Logo Tienda" class="logo" onerror="this.style.display='none'">
                <h1>¡Bienvenido!</h1>
                <h2><?php echo htmlspecialchars($cliente['nombre'] . ' ' . $cliente['apellido']); ?></h2>
            </div>
            
            <div class="bienvenida-content">
                <div class="mensaje-bienvenida">
                    <p class="mensaje-principal">
                        Gracias por registrarse en nuestro sistema de autoservicio.
                    </p>
                    <p class="mensaje-secundario">
                        A continuación le mostramos algunas recomendaciones para su compra:
                    </p>
                </div>
                
                <?php if (!empty($promociones)): ?>
                    <div class="recomendaciones">
                        <h3>Promociones Activas</h3>
                        <ul class="lista-promociones">
                            <?php foreach ($promociones as $promo): ?>
                                <li>
                                    <strong><?php echo htmlspecialchars($promo['titulo']); ?></strong>
                                    <?php if ($promo['descripcion']): ?>
                                        <p><?php echo htmlspecialchars($promo['descripcion']); ?></p>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php else: ?>
                    <div class="recomendaciones">
                        <h3>Consejos para su compra</h3>
                        <ul class="lista-recomendaciones">
                            <li>Use el lector de código de barras para agregar productos</li>
                            <li>Puede ajustar las cantidades desde el carrito</li>
                            <li>Revise su compra antes de finalizar</li>
                            <li>Guarde su ticket para cualquier consulta</li>
                        </ul>
                    </div>
                <?php endif; ?>
                
                <div class="contador-redireccion">
                    <p>Será redirigido al dashboard en <span id="contador">7</span> segundos...</p>
                    <a href="dashboard.php" class="btn btn-primary">Ir al Dashboard Ahora</a>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // Contador regresivo
        let segundos = 7;
        const contadorElement = document.getElementById('contador');
        
        const intervalo = setInterval(() => {
            segundos--;
            contadorElement.textContent = segundos;
            
            if (segundos <= 0) {
                clearInterval(intervalo);
            }
        }, 1000);
        
        // Limpiar flag de nuevo registro
        <?php unset($_SESSION['nuevo_registro']); ?>
    </script>
    <script src="../assets/js/main.js"></script>
</body>
</html>
