<?php
/**
 * API: Obtener contenido del carrito
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoCliente()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

$compraId = $_GET['compra_id'] ?? 0;

if (empty($compraId)) {
    responderJSON(['success' => false, 'message' => 'ID de compra requerido'], 400);
}

try {
    $db = getDB();
    
    // Verificar que la compra pertenece al cliente
    $cliente = obtenerClienteActual();
    $stmt = $db->prepare("SELECT total FROM compras WHERE id = ? AND cliente_id = ?");
    $stmt->execute([$compraId, $cliente['id']]);
    $compra = $stmt->fetch();
    
    if (!$compra) {
        responderJSON(['success' => false, 'message' => 'Compra no encontrada'], 404);
    }
    
    // Obtener items del carrito (ordenados del más reciente al más antiguo)
    $stmt = $db->prepare("
        SELECT 
            dc.id,
            dc.producto_id,
            dc.cantidad,
            dc.precio_unitario,
            dc.subtotal,
            p.nombre,
            p.descripcion,
            p.imagen
        FROM detalle_compras dc
        INNER JOIN productos p ON dc.producto_id = p.id
        WHERE dc.compra_id = ?
        ORDER BY dc.id DESC
    ");
    $stmt->execute([$compraId]);
    $items = $stmt->fetchAll();
    
    responderJSON([
        'success' => true,
        'items' => $items,
        'total' => $compra['total']
    ]);
    
} catch (PDOException $e) {
    responderJSON([
        'success' => false,
        'message' => 'Error al obtener carrito'
    ], 500);
}
?>
