# Sistema de Supermercados y Tiendas V3.0 - Análisis de Requisitos

## Resumen Ejecutivo

El sistema de supermercados y tiendas V3.0 es una aplicación web dinámica desarrollada en PHP con base de datos MySQL, diseñada para facilitar la experiencia de compra de los clientes mediante un sistema de autoservicio con lector de código de barras, y proporcionar herramientas completas de gestión para el personal administrativo.

## Arquitectura del Sistema

### Tecnologías Principales
- **Backend**: PHP 7.4+
- **Base de Datos**: MySQL 8.0+
- **Frontend**: HTML5, CSS3, JavaScript (Vanilla JS)
- **Responsive Design**: CSS Grid y Flexbox
- **API de Código de Barras**: QuaggaJS o HTML5-QRCode

### Estructura de Módulos

#### 1. Módulo de Cliente
- Autenticación por cédula/RUC
- Registro de nuevos clientes
- Dashboard de productos
- Lector de código de barras
- Carrito de compras dinámico
- Historial de compras

#### 2. Módulo de Administración
- Sistema de autenticación con roles
- Gestión de usuarios administrativos
- Gestión de clientes
- Gestión de productos y precios
- Sistema de promociones
- Mensajes emergentes

## Estructura de Base de Datos

### Tablas Principales

#### clientes
- id (INT, PRIMARY KEY, AUTO_INCREMENT)
- cedula_ruc (VARCHAR(20), UNIQUE)
- nombre (VARCHAR(100))
- apellido (VARCHAR(100))
- telefono (VARCHAR(20))
- email (VARCHAR(100))
- direccion (TEXT)
- fecha_registro (DATETIME)

#### usuarios_admin
- id (INT, PRIMARY KEY, AUTO_INCREMENT)
- username (VARCHAR(50), UNIQUE)
- password (VARCHAR(255))
- rol (ENUM: 'administrador', 'comercial', 'colaborador')
- nombre (VARCHAR(100))
- fecha_creacion (DATETIME)
- activo (BOOLEAN)

#### productos
- id (INT, PRIMARY KEY, AUTO_INCREMENT)
- codigo_barras (VARCHAR(50), UNIQUE)
- nombre (VARCHAR(200))
- descripcion (TEXT)
- precio (DECIMAL(10,2))
- stock (INT)
- imagen (VARCHAR(255))
- categoria (VARCHAR(50))
- fecha_creacion (DATETIME)
- creado_por (INT, FOREIGN KEY)

#### compras
- id (INT, PRIMARY KEY, AUTO_INCREMENT)
- cliente_id (INT, FOREIGN KEY)
- fecha_compra (DATETIME)
- total (DECIMAL(10,2))
- estado (ENUM: 'activa', 'finalizada')

#### detalle_compras
- id (INT, PRIMARY KEY, AUTO_INCREMENT)
- compra_id (INT, FOREIGN KEY)
- producto_id (INT, FOREIGN KEY)
- cantidad (INT)
- precio_unitario (DECIMAL(10,2))
- subtotal (DECIMAL(10,2))

#### promociones
- id (INT, PRIMARY KEY, AUTO_INCREMENT)
- titulo (VARCHAR(200))
- descripcion (TEXT)
- imagen (VARCHAR(255))
- fecha_inicio (DATETIME)
- fecha_fin (DATETIME)
- activo (BOOLEAN)
- creado_por (INT, FOREIGN KEY)

#### mensajes_emergentes
- id (INT, PRIMARY KEY, AUTO_INCREMENT)
- mensaje (TEXT)
- tipo (ENUM: 'oferta', 'promocion', 'anuncio')
- fecha_creacion (DATETIME)
- activo (BOOLEAN)
- creado_por (INT, FOREIGN KEY)

## Funcionalidades Detalladas

### Módulo Cliente

#### Autenticación
1. Pantalla de ingreso con campo para cédula/RUC (formato: 5625424 o 525424-5)
2. Validación en base de datos
3. Si existe: Bienvenida personalizada + mostrar última compra
4. Si no existe: Formulario de registro
5. Después del registro: Bienvenida con recomendaciones (7 segundos) → Dashboard

#### Dashboard del Cliente
**Diseño de dos columnas:**
- **Izquierda (Pantalla Principal)**:
  - Lector de código de barras con botón "APRIETE EL BOTON PARA LEER EL CODIGO"
  - Visualización de productos escaneados
  - Precio del producto
  - Botones de acción: "No quiero", "Si quiero", "Este quiero mas"
  - Botón "Última Compra" (parte inferior)
  - Promociones/Ofertas (actualización cada 10 segundos)

- **Derecha (Canasta de Compras)**:
  - Lista de productos agregados (últimos arriba)
  - Controles +/- para cantidad
  - Opción de eliminar producto
  - Total acumulado (parte inferior)
  - Formato de moneda: Guaraníes con separadores de miles

#### Funcionalidades Especiales
- Sonido al agregar productos
- Actualización automática cada 10 segundos para mostrar promociones
- Historial de compra anterior al reingresar
- Vista final de compra para verificación

### Módulo Administración

#### Sistema de Roles y Permisos

**Administrador:**
- Crear, modificar y eliminar cualquier contenido
- Gestión completa de usuarios administrativos
- Gestión completa de clientes
- Acceso total al sistema

**Comercial:**
- Crear, modificar y eliminar productos
- Modificar/eliminar productos de colaboradores
- Crear, modificar y eliminar promociones
- Enviar mensajes emergentes
- Sin acceso a gestión de usuarios

**Colaborador:**
- Solo cargar productos y precios
- No puede modificar ni eliminar
- Acceso limitado

#### Funcionalidades Administrativas
- Dashboard con estadísticas
- CRUD de productos (con código de barras o manual)
- CRUD de clientes
- Gestión de promociones con imágenes
- Sistema de mensajes emergentes con tiempo limitado
- Reportes de ventas

## Diseño Visual

### Paleta de Colores
- Colores suaves y profesionales
- Letras bien marcadas para legibilidad
- Alto contraste para facilitar lectura en tablets

### Elementos Visuales
- Logotipo de la tienda en header
- Iconos intuitivos para acciones
- Feedback visual para interacciones
- Animaciones suaves

### Responsive Design
- Optimizado para tablets (principal)
- Compatible con teléfonos móviles
- Layout adaptativo según tamaño de pantalla
- Touch-friendly (botones grandes)

## Seguridad

### Autenticación
- Contraseñas hasheadas (password_hash de PHP)
- Sesiones seguras con tokens
- Validación de roles en cada acción

### Validación de Datos
- Sanitización de inputs
- Prepared statements para prevenir SQL injection
- Validación de permisos por rol

### Protección de Archivos
- Acceso restringido a archivos PHP
- Validación de tipos de archivo en uploads
- Protección contra XSS

## Configuración Inicial

### Credenciales de Acceso
**Usuario Administrador:**
- Usuario: Tiendas
- Contraseña: 2025

**Base de Datos:**
- Nombre: tiendabd
- Usuario: tiendas2025
- Contraseña: product@s.py

## Flujo de Trabajo

### Cliente
1. Ingreso de cédula/RUC
2. Autenticación/Registro
3. Bienvenida personalizada
4. Escaneo de productos
5. Gestión de carrito
6. Finalización de compra
7. Visualización de resumen

### Administrador
1. Login con credenciales
2. Acceso según rol
3. Gestión de contenido permitido
4. Logout seguro

## Consideraciones Técnicas

### Performance
- Caché de productos frecuentes
- Optimización de consultas SQL
- Compresión de imágenes
- Lazy loading de promociones

### Mantenimiento
- Logs de actividad
- Backup automático de base de datos
- Versionado de código
- Documentación completa

## Próximos Pasos

1. Configurar entorno de desarrollo
2. Crear estructura de base de datos
3. Implementar módulo de autenticación
4. Desarrollar dashboard de cliente
5. Implementar panel de administración
6. Integrar funcionalidades adicionales
7. Optimizar para dispositivos móviles
8. Realizar pruebas exhaustivas
9. Desplegar y documentar
