<?php
/**
 * API: Obtener detalle de compra
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoAdmin()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

$id = $_GET['id'] ?? 0;

if (empty($id)) {
    responderJSON(['success' => false, 'message' => 'ID requerido'], 400);
}

try {
    $db = getDB();
    
    // Obtener datos de la compra
    $stmt = $db->prepare("
        SELECT c.*, cl.nombre, cl.apellido, cl.cedula_ruc
        FROM compras c
        JOIN clientes cl ON c.cliente_id = cl.id
        WHERE c.id = ?
    ");
    $stmt->execute([$id]);
    $compra = $stmt->fetch();
    
    if (!$compra) {
        responderJSON(['success' => false, 'message' => 'Compra no encontrada'], 404);
    }
    
    // Obtener items de la compra
    $stmt = $db->prepare("
        SELECT dc.*, p.nombre, p.codigo_barras
        FROM detalle_compras dc
        JOIN productos p ON dc.producto_id = p.id
        WHERE dc.compra_id = ?
    ");
    $stmt->execute([$id]);
    $items = $stmt->fetchAll();
    
    responderJSON([
        'success' => true,
        'compra' => $compra,
        'items' => $items
    ]);
    
} catch (PDOException $e) {
    responderJSON(['success' => false, 'message' => 'Error al obtener detalle'], 500);
}
?>
