<?php
/**
 * API: Guardar mensaje emergente
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoAdmin()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

if (!tienePermiso('enviar_mensajes')) {
    responderJSON(['success' => false, 'message' => 'No tiene permisos'], 403);
}

$admin = obtenerAdminActual();
$mensaje = sanitizar($_POST['mensaje'] ?? '');
$tipo = sanitizar($_POST['tipo'] ?? 'anuncio');
$fecha_expiracion = $_POST['fecha_expiracion'] ?? null;
$activo = $_POST['activo'] ?? 1;

if (empty($mensaje)) {
    responderJSON(['success' => false, 'message' => 'Mensaje requerido'], 400);
}

try {
    $db = getDB();
    
    $stmt = $db->prepare("
        INSERT INTO mensajes_emergentes (mensaje, tipo, fecha_expiracion, activo, creado_por)
        VALUES (?, ?, ?, ?, ?)
    ");
    
    $stmt->execute([$mensaje, $tipo, $fecha_expiracion, $activo, $admin['id']]);
    
    responderJSON(['success' => true, 'message' => 'Mensaje guardado']);
    
} catch (PDOException $e) {
    responderJSON(['success' => false, 'message' => 'Error al guardar'], 500);
}
?>
