# 📢 Guía de Mensajes Emergentes y Popups

## ✅ Funcionalidad Implementada

El sistema ahora muestra **mensajes emergentes (popups)** automáticamente cuando los clientes ingresan al dashboard.

---

## 🎯 Tipos de Mensajes

El sistema soporta **4 tipos** de mensajes emergentes:

### 1. 🎁 OFERTA
- **Color**: Rojo/Rosa
- **Uso**: Ofertas especiales, descuentos, promociones flash
- **Ejemplo**: "¡Ofertas del día! Descuentos especiales en productos seleccionados"

### 2. 🏷️ PROMOCIÓN
- **Color**: Verde
- **Uso**: Promociones 2x1, 3x2, combos especiales
- **Ejemplo**: "¡SUPER PROMOCIÓN! 2x1 en productos seleccionados"

### 3. 📢 ANUNCIO
- **Color**: Azul
- **Uso**: Información general, horarios, novedades
- **Ejemplo**: "Nuevo horario de atención: Lunes a Sábado de 8:00 a 20:00 hrs"

### 4. ⚠️ ALERTA
- **Color**: Naranja/Amarillo
- **Uso**: Avisos importantes, recordatorios, advertencias
- **Ejemplo**: "Recordatorio: Revisa la fecha de vencimiento de los productos"

---

## 🎨 Características de los Popups

### Diseño Visual
- ✅ **Animación de entrada** suave (slide-in)
- ✅ **Icono grande** según el tipo de mensaje
- ✅ **Colores diferenciados** por tipo
- ✅ **Fondo con overlay** oscuro
- ✅ **Botón de cerrar** (X) en la esquina superior derecha
- ✅ **Botón "Entendido"** para cerrar

### Comportamiento
- ✅ **Auto-aparición**: Se muestran automáticamente al cargar el dashboard
- ✅ **Secuencia**: Si hay múltiples mensajes, aparecen uno tras otro (5 segundos entre cada uno)
- ✅ **Auto-cierre**: Se cierran automáticamente después de 10 segundos
- ✅ **Cierre manual**: El usuario puede cerrar haciendo clic en X o en "Entendido"
- ✅ **Responsive**: Se adaptan a móviles y tablets

---

## 📝 Cómo Crear Mensajes Emergentes

### Desde el Panel de Administración

1. **Acceder al módulo**
   - Panel Admin → **"Mensajes Emergentes"**

2. **Crear nuevo mensaje**
   - Clic en **"Nuevo Mensaje"**
   - Llenar el formulario:
     - **Mensaje**: Texto que verá el cliente
     - **Tipo**: Seleccionar entre Oferta, Promoción, Anuncio o Alerta
     - **Fecha de expiración**: (Opcional) Fecha hasta cuando se mostrará
     - **Activo**: Marcar para que se muestre

3. **Guardar**
   - El mensaje se mostrará inmediatamente a los clientes que ingresen

### Desde SQL (Manual)

```sql
INSERT INTO mensajes_emergentes (mensaje, tipo, activo, creado_por) VALUES
('Tu mensaje aquí', 'oferta', 1, 1);
```

**Tipos válidos**: `'oferta'`, `'promocion'`, `'anuncio'`, `'alerta'`

---

## 🔧 Configuración Técnica

### Tiempos
- **Delay inicial**: 1 segundo después de cargar la página
- **Entre mensajes**: 5 segundos
- **Auto-cierre**: 10 segundos
- **Límite**: Máximo 5 mensajes por sesión

### Modificar Tiempos

Editar en `cliente/dashboard.php`:

```javascript
// Cambiar delay inicial (línea ~579)
let delay = 1000; // 1 segundo (1000 ms)

// Cambiar tiempo entre mensajes (línea ~584)
}, delay + (index * 5000)); // 5 segundos (5000 ms)

// Cambiar auto-cierre (línea ~618)
}, 10000); // 10 segundos (10000 ms)
```

---

## 📊 Ejemplos de Uso

### Ejemplo 1: Oferta del Día
```sql
INSERT INTO mensajes_emergentes (mensaje, tipo, activo, creado_por) VALUES
('¡OFERTA DEL DÍA! 30% de descuento en lácteos', 'oferta', 1, 1);
```

### Ejemplo 2: Promoción 2x1
```sql
INSERT INTO mensajes_emergentes (mensaje, tipo, activo, creado_por) VALUES
('¡Promoción 2x1 en productos de limpieza! Válido hasta agotar stock', 'promocion', 1, 1);
```

### Ejemplo 3: Cambio de Horario
```sql
INSERT INTO mensajes_emergentes (mensaje, tipo, activo, creado_por) VALUES
('Aviso: El 25 de diciembre estaremos cerrados por feriado', 'anuncio', 1, 1);
```

### Ejemplo 4: Recordatorio
```sql
INSERT INTO mensajes_emergentes (mensaje, tipo, activo, creado_por) VALUES
('Recordatorio: Traer bolsas reutilizables para cuidar el medio ambiente', 'alerta', 1, 1);
```

---

## 🎯 Mejores Prácticas

### Contenido
- ✅ **Mensajes cortos**: Máximo 2-3 líneas
- ✅ **Lenguaje claro**: Fácil de entender
- ✅ **Call to action**: Indica qué debe hacer el cliente
- ✅ **Urgencia**: Usa palabras como "Hoy", "Ahora", "Últimos días"

### Cantidad
- ✅ **Máximo 3 mensajes activos** a la vez
- ✅ **Rotar mensajes** cada semana
- ✅ **Desactivar mensajes vencidos**

### Tipo Correcto
- 🎁 **Oferta**: Descuentos, rebajas, liquidaciones
- 🏷️ **Promoción**: 2x1, 3x2, combos
- 📢 **Anuncio**: Información general, horarios
- ⚠️ **Alerta**: Avisos importantes, recordatorios

---

## 🔍 Verificar que Funciona

### Prueba Rápida

1. **Crear un mensaje de prueba**:
   ```sql
   INSERT INTO mensajes_emergentes (mensaje, tipo, activo, creado_por) VALUES
   ('¡Mensaje de prueba! El sistema funciona correctamente', 'anuncio', 1, 1);
   ```

2. **Acceder al dashboard del cliente**:
   - Ir a: http://tu-sitio.com/
   - Ingresar con cédula/RUC
   - **Esperar 1 segundo**
   - Debería aparecer el popup

3. **Verificar**:
   - ✅ El popup aparece centrado
   - ✅ Tiene fondo oscuro
   - ✅ Muestra el icono correcto
   - ✅ Se puede cerrar con X o botón
   - ✅ Se cierra solo después de 10 segundos

---

## 🐛 Solución de Problemas

### El popup no aparece

**Verificar:**

1. **Mensaje activo en BD**:
   ```sql
   SELECT * FROM mensajes_emergentes WHERE activo = 1;
   ```

2. **Consola del navegador** (F12):
   - Ver si hay errores JavaScript
   - Verificar que se cargan los mensajes

3. **Cache del navegador**:
   - Presionar Ctrl+F5 para recargar sin cache

### El popup aparece pero no se ve bien

**Verificar:**

1. **Archivo CSS actualizado**:
   - Verificar que `style.css` tiene los estilos de `.mensaje-popup`

2. **Cache del servidor**:
   - Limpiar cache de Apache/Nginx

---

## 📦 Archivos Modificados

Para que funcionen los popups, se modificaron:

1. ✅ `cliente/dashboard.php` - Lógica de popups
2. ✅ `assets/css/style.css` - Estilos de popups
3. ✅ `database_setup.sql` - Tipo 'alerta' agregado

---

## 🌐 Ejemplo en Vivo

**URL de prueba**: https://80-i85tgjzrx0fnpmn1gfeyj-1adeaea7.manusvm.computer

**Mensajes activos actualmente**:
1. 🎁 Oferta del día
2. 🏷️ Super promoción 2x1
3. 📢 Nuevo horario de atención
4. ⚠️ Recordatorio sobre vencimientos

---

¡Los mensajes emergentes están completamente funcionales! 🎉
