# 🚀 Guía de Despliegue Permanente - Sistema de Tiendas V3.0

## 📋 Opciones de Despliegue

Tienes varias opciones para desplegar el sistema de forma permanente:

---

## ✅ OPCIÓN 1: Tu Servidor Actual (distec.com.py) - RECOMENDADO

Ya tienes el dominio **distec.com.py** configurado con Plesk. Esta es la mejor opción.

### Pasos para Despliegue:

#### 1. Subir Archivos al Servidor

**Opción A: Usando FTP/SFTP**

1. **Conectar por FTP** usando FileZilla o WinSCP:
   - **Host**: distec.com.py o IP del servidor
   - **Usuario**: Tu usuario FTP de Plesk
   - **Puerto**: 21 (FTP) o 22 (SFTP)

2. **Subir archivos**:
   - Descomprimir `tiendas_v3_sistema_completo.zip`
   - Subir todo el contenido de la carpeta `tiendas_v3/` a:
     - `/var/www/vhosts/distec.com.py/httpdocs/`

**Opción B: Usando SSH**

```bash
# Conectar por SSH
ssh usuario@distec.com.py

# Subir archivo comprimido
scp tiendas_v3_sistema_completo.tar.gz usuario@distec.com.py:/tmp/

# En el servidor, descomprimir
cd /var/www/vhosts/distec.com.py/httpdocs/
tar -xzf /tmp/tiendas_v3_sistema_completo.tar.gz --strip-components=1
```

#### 2. Configurar Base de Datos

**Opción A: Desde Plesk**

1. **Panel de Plesk** → **Bases de datos**
2. **Agregar base de datos**:
   - Nombre: `tiendabd`
   - Usuario: `tiendas2025`
   - Contraseña: `product@s.py` (o la que prefieras)
3. **Importar SQL**:
   - Seleccionar la base de datos
   - Click en "Importar volcado"
   - Subir `database_setup.sql`
   - Ejecutar

**Opción B: Desde phpMyAdmin**

1. Acceder a phpMyAdmin desde Plesk
2. Crear base de datos `tiendabd`
3. Importar archivo `database_setup.sql`

**Opción C: Desde SSH/Terminal**

```bash
# Importar base de datos
mysql -u root -p < database_setup.sql

# O si ya existe la base de datos
mysql -u root -p tiendabd < database_setup.sql
```

#### 3. Configurar Archivo de Conexión

Editar `/var/www/vhosts/distec.com.py/httpdocs/config/database.php`:

```php
<?php
$host = 'localhost';
$dbname = 'tiendabd';
$username = 'tiendas2025';
$password = 'product@s.py'; // Tu contraseña real
```

#### 4. Configurar Permisos

```bash
# Permisos de archivos
cd /var/www/vhosts/distec.com.py/httpdocs/
find . -type d -exec chmod 755 {} \;
find . -type f -exec chmod 644 {} \;

# Permisos especiales para uploads y logs
chmod -R 775 uploads/
chmod -R 775 logs/

# Cambiar propietario (usuario de Plesk)
chown -R usuario_ftp:psacln .
```

#### 5. Configurar Apache (Plesk)

En **Plesk** → **Configuración de Apache y nginx** → **Directivas adicionales**:

```apache
<Directory /var/www/vhosts/distec.com.py/httpdocs>
    Require all granted
    AllowOverride All
    Options -Indexes +FollowSymLinks
</Directory>
```

#### 6. Verificar Instalación

1. Acceder a: **https://distec.com.py**
2. Debería mostrar la página de login
3. Probar login de cliente con cédula
4. Probar panel admin: **https://distec.com.py/admin/**
   - Usuario: `Tiendas`
   - Contraseña: `2025`

---

## ✅ OPCIÓN 2: Servidor VPS Nuevo

Si prefieres un servidor dedicado para el sistema.

### Proveedores Recomendados:

#### A. DigitalOcean (Recomendado)
- **Precio**: Desde $6/mes
- **Plan**: Droplet básico (1GB RAM)
- **Web**: https://www.digitalocean.com

#### B. Vultr
- **Precio**: Desde $6/mes
- **Plan**: Cloud Compute
- **Web**: https://www.vultr.com

#### C. Linode (Akamai)
- **Precio**: Desde $5/mes
- **Plan**: Nanode 1GB
- **Web**: https://www.linode.com

### Pasos de Instalación en VPS:

```bash
# 1. Actualizar sistema
sudo apt update && sudo apt upgrade -y

# 2. Instalar Apache, PHP y MySQL
sudo apt install apache2 php php-mysql mysql-server -y

# 3. Instalar extensiones PHP necesarias
sudo apt install php-mbstring php-xml php-curl php-gd -y

# 4. Configurar MySQL
sudo mysql_secure_installation

# 5. Crear base de datos
sudo mysql < database_setup.sql

# 6. Copiar archivos del sistema
sudo cp -r tiendas_v3/* /var/www/html/

# 7. Configurar permisos
sudo chown -R www-data:www-data /var/www/html/
sudo chmod -R 755 /var/www/html/

# 8. Reiniciar Apache
sudo systemctl restart apache2

# 9. Configurar firewall
sudo ufw allow 80/tcp
sudo ufw allow 443/tcp
sudo ufw enable
```

---

## ✅ OPCIÓN 3: Hosting Compartido

Proveedores de hosting compartido con PHP y MySQL.

### Proveedores Recomendados:

#### A. Hostinger
- **Precio**: Desde $2.99/mes
- **Incluye**: PHP 8.x, MySQL, SSL gratis
- **Panel**: hPanel (similar a Plesk)
- **Web**: https://www.hostinger.com

#### B. SiteGround
- **Precio**: Desde $3.99/mes
- **Incluye**: PHP 8.x, MySQL, SSL gratis, cPanel
- **Web**: https://www.siteground.com

#### C. Bluehost
- **Precio**: Desde $2.95/mes
- **Incluye**: PHP, MySQL, SSL, cPanel
- **Web**: https://www.bluehost.com

### Pasos de Instalación:

1. **Contratar hosting**
2. **Subir archivos** por FTP o File Manager
3. **Crear base de datos** desde cPanel/hPanel
4. **Importar SQL** desde phpMyAdmin
5. **Configurar** archivo `config/database.php`
6. **Acceder** a tu dominio

---

## ✅ OPCIÓN 4: Hosting Gratuito (Para Pruebas)

**⚠️ ADVERTENCIA**: No recomendado para producción.

### Proveedores Gratuitos:

#### A. InfinityFree
- **Precio**: Gratis
- **Límites**: 5GB espacio, PHP 8.x, MySQL
- **Web**: https://www.infinityfree.net

#### B. 000webhost
- **Precio**: Gratis
- **Límites**: 300MB espacio, PHP, MySQL
- **Web**: https://www.000webhost.com

**Limitaciones**:
- ❌ Publicidad forzada
- ❌ Recursos limitados
- ❌ Puede caerse frecuentemente
- ❌ No apto para producción

---

## 🌐 Configuración de Dominio

### Si tienes un dominio propio:

#### Opción A: Apuntar a tu servidor Plesk
1. Ir a tu proveedor de dominio (GoDaddy, Namecheap, etc.)
2. Configurar DNS:
   - **Tipo A**: `@` → IP de tu servidor
   - **Tipo A**: `www` → IP de tu servidor
3. Esperar propagación (24-48 horas)

#### Opción B: Usar dominio gratuito
- **Freenom**: https://www.freenom.com (dominios .tk, .ml, .ga gratis)
- **No-IP**: https://www.noip.com (subdominio gratis)

---

## 🔒 Configurar SSL (HTTPS)

### Opción A: Let's Encrypt (Gratis) - Recomendado

**En Plesk:**
1. Panel de Plesk → **SSL/TLS Certificates**
2. Click en **Install a free basic certificate provided by Let's Encrypt**
3. Marcar opciones y click en **Get it free**

**En VPS (Certbot):**
```bash
# Instalar Certbot
sudo apt install certbot python3-certbot-apache -y

# Obtener certificado
sudo certbot --apache -d distec.com.py -d www.distec.com.py

# Renovación automática
sudo certbot renew --dry-run
```

### Opción B: Cloudflare (Gratis)
1. Crear cuenta en https://www.cloudflare.com
2. Agregar tu dominio
3. Cambiar nameservers en tu proveedor de dominio
4. Activar SSL en Cloudflare (Flexible o Full)

---

## 📊 Checklist de Despliegue

### Antes de Desplegar:

- [ ] Servidor/Hosting contratado
- [ ] Dominio configurado (o usar IP)
- [ ] Archivos del sistema descargados
- [ ] Credenciales de acceso listas

### Durante el Despliegue:

- [ ] Archivos subidos al servidor
- [ ] Base de datos creada
- [ ] SQL importado correctamente
- [ ] Archivo `database.php` configurado
- [ ] Permisos de archivos configurados
- [ ] Apache/Nginx configurado
- [ ] `.htaccess` en su lugar

### Después del Despliegue:

- [ ] Sitio accesible desde el navegador
- [ ] Login de clientes funciona
- [ ] Panel admin accesible
- [ ] Scanner de código de barras funciona
- [ ] Carrito de compras funciona
- [ ] Mensajes emergentes aparecen
- [ ] SSL configurado (HTTPS)
- [ ] Backup configurado

---

## 🔧 Configuración Recomendada de PHP

En `php.ini` o configuración de PHP en Plesk:

```ini
upload_max_filesize = 10M
post_max_size = 10M
max_execution_time = 300
max_input_time = 300
memory_limit = 256M
```

---

## 💾 Configurar Backups Automáticos

### Opción A: Plesk Backup
1. Panel de Plesk → **Backup Manager**
2. Configurar backup automático diario
3. Guardar en ubicación remota (FTP, S3, etc.)

### Opción B: Script de Backup Manual

```bash
#!/bin/bash
# backup.sh

# Variables
FECHA=$(date +%Y%m%d_%H%M%S)
BACKUP_DIR="/backups"
DB_NAME="tiendabd"
DB_USER="tiendas2025"
DB_PASS="product@s.py"

# Crear directorio de backup
mkdir -p $BACKUP_DIR

# Backup de base de datos
mysqldump -u $DB_USER -p$DB_PASS $DB_NAME > $BACKUP_DIR/db_$FECHA.sql

# Backup de archivos
tar -czf $BACKUP_DIR/files_$FECHA.tar.gz /var/www/vhosts/distec.com.py/httpdocs/

# Eliminar backups antiguos (más de 7 días)
find $BACKUP_DIR -type f -mtime +7 -delete

echo "Backup completado: $FECHA"
```

**Configurar cron para ejecutar diariamente:**
```bash
# Editar crontab
crontab -e

# Agregar línea (ejecutar a las 2 AM diariamente)
0 2 * * * /ruta/al/backup.sh
```

---

## 🎯 Recomendación Final

**Para tu caso específico**, recomiendo:

### ✅ USAR TU SERVIDOR ACTUAL (distec.com.py)

**Ventajas:**
- ✅ Ya tienes el dominio
- ✅ Ya tienes Plesk configurado
- ✅ No necesitas pagar hosting adicional
- ✅ Configuración más rápida
- ✅ Ya conoces el entorno

**Pasos Resumidos:**
1. Subir archivos por FTP a `/var/www/vhosts/distec.com.py/httpdocs/`
2. Crear base de datos en Plesk
3. Importar `database_setup.sql`
4. Configurar directivas de Apache en Plesk
5. Configurar SSL con Let's Encrypt
6. ¡Listo!

---

## 📞 Soporte Post-Despliegue

### Problemas Comunes:

**1. Error 500 - Internal Server Error**
- Verificar permisos de archivos
- Revisar error_log de Apache
- Verificar configuración de PHP

**2. No se conecta a la base de datos**
- Verificar credenciales en `database.php`
- Verificar que MySQL esté corriendo
- Verificar permisos del usuario de BD

**3. Páginas en blanco**
- Activar display_errors en PHP
- Revisar error_log
- Verificar sintaxis de archivos PHP

**4. SSL no funciona**
- Verificar certificado instalado
- Forzar HTTPS en `.htaccess`
- Limpiar cache del navegador

---

## 📦 Archivos Necesarios para Despliegue

Todos incluidos en:
- ✅ `tiendas_v3_sistema_completo.tar.gz`
- ✅ `tiendas_v3_sistema_completo.zip`

Contienen:
- ✅ Todo el código del sistema
- ✅ `database_setup.sql` para la base de datos
- ✅ `.htaccess` configurado
- ✅ Documentación completa
- ✅ Guías de instalación

---

¿Necesitas ayuda con algún paso específico del despliegue? ¡Estoy aquí para ayudarte! 🚀
