<?php
require_once '../includes/config.php';
require_once '../includes/fpdf/fpdf.php';

// Verificar que se proporcione ID de reserva
if (!isset($_GET['id'])) {
    redirect('registro.php');
}

$reserva_id = (int)$_GET['id'];
$db = getDBConnection();

// Obtener datos de la reserva
$stmt = $db->prepare("
    SELECT r.*, u.nombre_completo, u.cedula_pasaporte, u.telefono, u.email, t.nombre as tarifa_nombre
    FROM reservas r
    JOIN usuarios u ON r.usuario_id = u.id
    JOIN tarifas t ON r.tarifa_id = t.id
    WHERE r.id = ?
");
$stmt->execute([$reserva_id]);
$reserva = $stmt->fetch();

if (!$reserva) {
    die('Reserva no encontrada');
}

// Si se solicita descargar PDF
if (isset($_GET['download'])) {
    class PDF extends FPDF {
        function Header() {
            $this->SetFont('Arial', 'B', 20);
            $this->SetTextColor(45, 80, 22);
            $this->Cell(0, 10, 'Sistema de Reservas - Posada', 0, 1, 'C');
            $this->SetFont('Arial', '', 12);
            $this->SetTextColor(100, 100, 100);
            $this->Cell(0, 6, 'Comprobante de Reserva', 0, 1, 'C');
            $this->Ln(10);
        }
        
        function Footer() {
            $this->SetY(-15);
            $this->SetFont('Arial', 'I', 8);
            $this->SetTextColor(128, 128, 128);
            $this->Cell(0, 10, 'Pagina ' . $this->PageNo(), 0, 0, 'C');
        }
    }
    
    $pdf = new PDF();
    $pdf->AddPage();
    $pdf->SetFont('Arial', '', 12);
    
    // Información de la reserva
    $pdf->SetFont('Arial', 'B', 14);
    $pdf->SetTextColor(45, 80, 22);
    $pdf->Cell(0, 10, 'COMPROBANTE DE RESERVA #' . str_pad($reserva['id'], 6, '0', STR_PAD_LEFT), 0, 1);
    $pdf->Ln(5);
    
    // Datos del huésped
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->Cell(0, 8, 'Datos del Huesped:', 0, 1);
    $pdf->SetFont('Arial', '', 11);
    $pdf->Cell(50, 6, 'Nombre:', 0, 0);
    $pdf->Cell(0, 6, utf8_decode($reserva['nombre_completo']), 0, 1);
    $pdf->Cell(50, 6, 'Cedula/Pasaporte:', 0, 0);
    $pdf->Cell(0, 6, $reserva['cedula_pasaporte'], 0, 1);
    $pdf->Cell(50, 6, 'Telefono:', 0, 0);
    $pdf->Cell(0, 6, $reserva['telefono'], 0, 1);
    if ($reserva['email']) {
        $pdf->Cell(50, 6, 'Email:', 0, 0);
        $pdf->Cell(0, 6, $reserva['email'], 0, 1);
    }
    $pdf->Ln(5);
    
    // Datos de la reserva
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(0, 8, 'Detalles de la Reserva:', 0, 1);
    $pdf->SetFont('Arial', '', 11);
    $pdf->Cell(50, 6, 'Fecha de Entrada:', 0, 0);
    $pdf->Cell(0, 6, date('d/m/Y', strtotime($reserva['fecha_entrada'])), 0, 1);
    $pdf->Cell(50, 6, 'Fecha de Salida:', 0, 0);
    $pdf->Cell(0, 6, date('d/m/Y', strtotime($reserva['fecha_salida'])), 0, 1);
    $pdf->Cell(50, 6, 'Cantidad de Dias:', 0, 0);
    $pdf->Cell(0, 6, $reserva['cantidad_dias'] . ' ' . ($reserva['cantidad_dias'] == 1 ? 'dia' : 'dias'), 0, 1);
    $pdf->Cell(50, 6, 'Cantidad de Personas:', 0, 0);
    $pdf->Cell(0, 6, $reserva['cantidad_personas'], 0, 1);
    $pdf->Cell(50, 6, 'Tarifa:', 0, 0);
    $pdf->Cell(0, 6, utf8_decode($reserva['tarifa_nombre']), 0, 1);
    $pdf->Ln(5);
    
    // Costo
    $pdf->SetFont('Arial', 'B', 14);
    $pdf->SetFillColor(45, 80, 22);
    $pdf->SetTextColor(255, 255, 255);
    $pdf->Cell(0, 10, 'Costo Total: Gs. ' . number_format($reserva['costo_hospedaje'], 0, ',', '.'), 1, 1, 'C', true);
    $pdf->Ln(5);
    
    // Estado
    $pdf->SetFont('Arial', 'B', 11);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->Cell(50, 6, 'Estado de la Reserva:', 0, 0);
    $pdf->SetFont('Arial', '', 11);
    $estadoTexto = strtoupper($reserva['estado']);
    $pdf->Cell(0, 6, utf8_decode($estadoTexto), 0, 1);
    
    // Comentarios
    if ($reserva['comentarios']) {
        $pdf->Ln(5);
        $pdf->SetFont('Arial', 'B', 11);
        $pdf->Cell(0, 6, 'Comentarios:', 0, 1);
        $pdf->SetFont('Arial', '', 10);
        $pdf->MultiCell(0, 5, utf8_decode($reserva['comentarios']));
    }
    
    $pdf->Ln(10);
    $pdf->SetFont('Arial', 'I', 10);
    $pdf->SetTextColor(128, 128, 128);
    $pdf->MultiCell(0, 5, utf8_decode('Nota: Esta reserva quedará en estado "Pendiente" hasta que el administrador la confirme. Recibirá una notificación cuando su reserva sea confirmada.'));
    
    $pdf->Ln(5);
    $pdf->SetFont('Arial', '', 9);
    $pdf->Cell(0, 5, 'Fecha de emision: ' . date('d/m/Y H:i:s'), 0, 1, 'C');
    
    $pdf->Output('D', 'Comprobante_Reserva_' . $reserva['id'] . '.pdf');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comprobante de Reserva - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-content">
            <div class="logo-container">
                <img src="../assets/images/logo.png" alt="Logo Posada" class="logo">
                <h1 class="site-title">Comprobante de Reserva</h1>
            </div>
        </div>
    </header>

    <div class="container mt-3">
        <div class="card" style="max-width: 800px; margin: 0 auto;">
            <div class="card-header" style="background: linear-gradient(135deg, var(--color-primary), var(--color-primary-light)); color: white;">
                <h2 style="color: white; margin: 0;">✓ Reserva Creada Exitosamente</h2>
            </div>
            <div class="card-body">
                <div class="alert alert-success">
                    <strong>¡Felicitaciones!</strong> Su reserva ha sido registrada correctamente. 
                    A continuación encontrará los detalles de su reserva.
                </div>
                
                <div style="background: var(--color-bg); padding: 20px; border-radius: var(--radius); margin: 20px 0;">
                    <h3 style="color: var(--color-primary); margin-bottom: 15px;">
                        Comprobante #<?php echo str_pad($reserva['id'], 6, '0', STR_PAD_LEFT); ?>
                    </h3>
                    
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px;">
                        <div>
                            <strong>Huésped:</strong><br>
                            <?php echo htmlspecialchars($reserva['nombre_completo']); ?><br>
                            <small>CI/Pasaporte: <?php echo htmlspecialchars($reserva['cedula_pasaporte']); ?></small>
                        </div>
                        <div>
                            <strong>Contacto:</strong><br>
                            <?php echo htmlspecialchars($reserva['telefono']); ?><br>
                            <?php if ($reserva['email']): ?>
                                <small><?php echo htmlspecialchars($reserva['email']); ?></small>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div style="border-top: 2px solid var(--color-border); padding-top: 15px; margin-top: 15px;">
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px;">
                            <div>
                                <strong>Fecha de Entrada:</strong><br>
                                <?php echo formatDate($reserva['fecha_entrada']); ?>
                            </div>
                            <div>
                                <strong>Fecha de Salida:</strong><br>
                                <?php echo formatDate($reserva['fecha_salida']); ?>
                            </div>
                            <div>
                                <strong>Cantidad de Días:</strong><br>
                                <?php echo $reserva['cantidad_dias']; ?> <?php echo $reserva['cantidad_dias'] == 1 ? 'día' : 'días'; ?>
                            </div>
                            <div>
                                <strong>Personas:</strong><br>
                                <?php echo $reserva['cantidad_personas']; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div style="background: linear-gradient(135deg, var(--color-primary), var(--color-primary-light)); color: white; padding: 20px; border-radius: var(--radius); margin-top: 20px; text-align: center;">
                        <div style="font-size: 0.9rem; opacity: 0.9;">Costo Total</div>
                        <div style="font-size: 2.5rem; font-weight: bold;">
                            <?php echo formatMoney($reserva['costo_hospedaje']); ?>
                        </div>
                    </div>
                    
                    <div style="margin-top: 20px;">
                        <strong>Estado:</strong> 
                        <span class="badge badge-warning"><?php echo strtoupper($reserva['estado']); ?></span>
                    </div>
                    
                    <?php if ($reserva['comentarios']): ?>
                        <div style="margin-top: 15px;">
                            <strong>Comentarios:</strong><br>
                            <p style="color: var(--color-text-light); margin-top: 5px;">
                                <?php echo nl2br(htmlspecialchars($reserva['comentarios'])); ?>
                            </p>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="alert alert-info">
                    <strong>Importante:</strong> Su reserva quedará en estado "Pendiente" hasta que el administrador 
                    la revise y confirme. Recibirá una notificación cuando su reserva sea confirmada.
                </div>
                
                <div class="d-flex gap-2" style="justify-content: space-between; margin-top: 20px;">
                    <a href="?id=<?php echo $reserva['id']; ?>&download=1" class="btn btn-primary btn-lg">
                        📄 Descargar PDF
                    </a>
                    <a href="../index.php" class="btn btn-secondary">
                        Volver al Inicio
                    </a>
                </div>
            </div>
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Sistema de Reservas para Posadas. Todos los derechos reservados.</p>
        </div>
    </footer>

    <script src="../assets/js/main.js"></script>
    <script>
        // Mostrar mensaje de éxito
        showAlert('Reserva creada exitosamente. Puede descargar su comprobante en PDF.', 'success');
    </script>
</body>
</html>
