<?php
require_once '../includes/config.php';
if (!isLoggedIn() || !isAdmin()) redirect('login.php');
$db = getDBConnection();
$mensaje = '';
if (isset($_POST['guardar'])) {
    $titulo = sanitize($_POST['titulo']);
    $descripcion = sanitize($_POST['descripcion']);
    $descuento_porcentaje = (float)$_POST['descuento_porcentaje'];
    $descuento_monto = (float)$_POST['descuento_monto'];
    $fecha_inicio = $_POST['fecha_inicio'];
    $fecha_fin = $_POST['fecha_fin'];
    $activa = isset($_POST['activa']) ? 1 : 0;
    $stmt = $db->prepare("INSERT INTO promociones (titulo, descripcion, descuento_porcentaje, descuento_monto, fecha_inicio, fecha_fin, activa) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$titulo, $descripcion, $descuento_porcentaje, $descuento_monto, $fecha_inicio, $fecha_fin, $activa]);
    $mensaje = 'Promoción creada';
}
if (isset($_GET['eliminar'])) {
    $stmt = $db->prepare("DELETE FROM promociones WHERE id = ?");
    $stmt->execute([(int)$_GET['eliminar']]);
    $mensaje = 'Promoción eliminada';
}
$stmt = $db->query("SELECT * FROM promociones ORDER BY fecha_inicio DESC");
$promociones = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Promociones - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-container">
                <img src="../assets/images/logo.png" alt="Logo" class="logo">
                <h1 class="site-title">Gestión de Promociones</h1>
            </div>
            <nav>
                <ul class="nav-menu">
                    <li><a href="dashboard.php">← Dashboard</a></li>
                    <li><a href="logout.php">Cerrar Sesión</a></li>
                </ul>
            </nav>
        </div>
    </header>
    <div class="container mt-3">
        <?php if ($mensaje): ?><div class="alert alert-success"><?php echo $mensaje; ?></div><?php endif; ?>
        <div class="grid grid-2">
            <div class="card">
                <div class="card-header"><h3 class="card-title">Nueva Promoción</h3></div>
                <div class="card-body">
                    <form method="POST">
                        <div class="form-group">
                            <label class="form-label">Título</label>
                            <input type="text" name="titulo" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Descripción</label>
                            <textarea name="descripcion" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Descuento (%)</label>
                            <input type="number" name="descuento_porcentaje" class="form-control" min="0" max="100" step="0.01" value="0">
                        </div>
                        <div class="form-group">
                            <label class="form-label">Descuento (Monto Fijo Gs.)</label>
                            <input type="number" name="descuento_monto" class="form-control" min="0" step="1000" value="0">
                        </div>
                        <div class="form-group">
                            <label class="form-label">Fecha Inicio</label>
                            <input type="date" name="fecha_inicio" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Fecha Fin</label>
                            <input type="date" name="fecha_fin" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label><input type="checkbox" name="activa" checked> Activa</label>
                        </div>
                        <button type="submit" name="guardar" class="btn btn-primary btn-block">Guardar</button>
                    </form>
                </div>
            </div>
            <div class="card">
                <div class="card-header"><h3 class="card-title">Lista de Promociones</h3></div>
                <div class="card-body">
                    <table class="table">
                        <thead><tr><th>Título</th><th>Descuento</th><th>Vigencia</th><th>Estado</th><th>Acciones</th></tr></thead>
                        <tbody>
                            <?php foreach ($promociones as $p): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($p['titulo']); ?></td>
                                    <td>
                                        <?php if ($p['descuento_porcentaje'] > 0): ?>
                                            <?php echo $p['descuento_porcentaje']; ?>%
                                        <?php else: ?>
                                            <?php echo formatMoney($p['descuento_monto']); ?>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo formatDate($p['fecha_inicio']); ?> - <?php echo formatDate($p['fecha_fin']); ?></td>
                                    <td><?php echo $p['activa'] ? '✓' : '✗'; ?></td>
                                    <td><a href="?eliminar=<?php echo $p['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar?')">🗑️</a></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <footer class="footer"><div class="container"><p>&copy; <?php echo date('Y'); ?> Sistema de Reservas para Posadas.</p></div></footer>
    <script src="../assets/js/main.js"></script>
</body>
</html>
