<?php
require_once '../includes/config.php';
if (!isLoggedIn() || !isAdmin()) redirect('login.php');

$db = getDBConnection();
$mensaje = '';

// Agregar/Editar producto
if (isset($_POST['guardar_producto'])) {
    $id = (int)($_POST['id'] ?? 0);
    $categoria_id = (int)$_POST['categoria_id'];
    $nombre = sanitize($_POST['nombre']);
    $descripcion = sanitize($_POST['descripcion']);
    $precio = (float)$_POST['precio'];
    $disponible = isset($_POST['disponible']) ? 1 : 0;
    
    if ($id > 0) {
        $stmt = $db->prepare("UPDATE productos SET categoria_id=?, nombre=?, descripcion=?, precio=?, disponible=? WHERE id=?");
        $stmt->execute([$categoria_id, $nombre, $descripcion, $precio, $disponible, $id]);
        $mensaje = 'Producto actualizado';
    } else {
        $stmt = $db->prepare("INSERT INTO productos (categoria_id, nombre, descripcion, precio, disponible) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$categoria_id, $nombre, $descripcion, $precio, $disponible]);
        $mensaje = 'Producto creado';
    }
}

// Eliminar
if (isset($_GET['eliminar'])) {
    $stmt = $db->prepare("DELETE FROM productos WHERE id = ?");
    $stmt->execute([(int)$_GET['eliminar']]);
    $mensaje = 'Producto eliminado';
}

$stmt = $db->query("SELECT p.*, c.nombre as categoria FROM productos p JOIN categorias_productos c ON p.categoria_id=c.id ORDER BY c.nombre, p.nombre");
$productos = $stmt->fetchAll();

$stmt = $db->query("SELECT * FROM categorias_productos WHERE activa=1 ORDER BY nombre");
$categorias = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Productos - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-container">
                <img src="../assets/images/logo.png" alt="Logo" class="logo">
                <h1 class="site-title">Gestión de Productos</h1>
            </div>
            <nav>
                <ul class="nav-menu">
                    <li><a href="dashboard.php">← Dashboard</a></li>
                    <li><a href="logout.php">Cerrar Sesión</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <div class="container mt-3">
        <?php if ($mensaje): ?>
            <div class="alert alert-success"><?php echo $mensaje; ?></div>
        <?php endif; ?>

        <div class="grid grid-2" style="align-items: start;">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Agregar/Editar Producto</h3>
                </div>
                <div class="card-body">
                    <form method="POST">
                        <input type="hidden" name="id" id="producto_id">
                        <div class="form-group">
                            <label class="form-label">Categoría</label>
                            <select name="categoria_id" id="categoria_id" class="form-control" required>
                                <?php foreach ($categorias as $cat): ?>
                                    <option value="<?php echo $cat['id']; ?>"><?php echo htmlspecialchars($cat['nombre']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Nombre</label>
                            <input type="text" name="nombre" id="nombre" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Descripción</label>
                            <textarea name="descripcion" id="descripcion" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Precio (Gs.)</label>
                            <input type="number" name="precio" id="precio" class="form-control" min="0" step="1" required>
                        </div>
                        <div class="form-group">
                            <label><input type="checkbox" name="disponible" id="disponible" checked> Disponible</label>
                        </div>
                        <button type="submit" name="guardar_producto" class="btn btn-primary btn-block">Guardar</button>
                    </form>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Lista de Productos</h3>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>Categoría</th>
                                <th>Precio</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($productos as $p): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($p['nombre']); ?></td>
                                    <td><?php echo htmlspecialchars($p['categoria']); ?></td>
                                    <td><?php echo formatMoney($p['precio']); ?></td>
                                    <td><?php echo $p['disponible'] ? '✓' : '✗'; ?></td>
                                    <td>
                                        <a href="?eliminar=<?php echo $p['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar?')">🗑️</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Sistema de Reservas para Posadas.</p>
        </div>
    </footer>
    <script src="../assets/js/main.js"></script>
</body>
</html>
