<?php
require_once 'config.php';

if (!isLoggedIn() || (!hasRole('Administrador') && !hasRole('Supervisor'))) {
    redirect('dashboard.php');
}

$db = getDB();

// Procesar mensajes de sesión
$mensaje = $_SESSION['mensaje'] ?? '';
$error = $_SESSION['error'] ?? '';
unset($_SESSION['mensaje'], $_SESSION['error']);

// Obtener información del usuario actual
$stmt = $db->prepare("SELECT u.*, r.nombre as rol_nombre FROM usuarios u 
                      INNER JOIN roles r ON u.rol_id = r.id 
                      WHERE u.id = ?");
$stmt->execute([$_SESSION['user_id']]);
$usuario = $stmt->fetch();

// Obtener movimientos según el rol
if ($usuario['rol_nombre'] === 'Administrador') {
    $stmt = $db->query("SELECT m.*, u.nombre_completo, c.nombre as categoria, r.nombre as rol 
                        FROM movimientos m 
                        INNER JOIN usuarios u ON m.usuario_id = u.id 
                        INNER JOIN categorias c ON m.categoria_id = c.id 
                        INNER JOIN roles r ON u.rol_id = r.id
                        ORDER BY m.created_at DESC 
                        LIMIT 100");
} else {
    $stmt = $db->prepare("SELECT m.*, u.nombre_completo, c.nombre as categoria, r.nombre as rol 
                          FROM movimientos m 
                          INNER JOIN usuarios u ON m.usuario_id = u.id 
                          INNER JOIN categorias c ON m.categoria_id = c.id 
                          INNER JOIN roles r ON u.rol_id = r.id
                          WHERE u.supervisor_id = ? OR m.usuario_id = ?
                          ORDER BY m.created_at DESC 
                          LIMIT 100");
    $stmt->execute([$_SESSION['user_id'], $_SESSION['user_id']]);
}

$movimientos = $stmt->fetchAll();

$page_title = 'Todos los Movimientos';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">
                        <i class="bi bi-arrow-left-right"></i> Todos los Movimientos
                    </h1>
                    <a href="reportes.php" class="btn btn-primary">
                        <i class="bi bi-file-earmark-bar-graph"></i> Ver Reportes
                    </a>
                </div>
                
                <?php if ($mensaje): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle"></i> <?php echo $mensaje; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-triangle"></i> <?php echo $error; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-list"></i> Últimos 100 Movimientos</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-sm">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Fecha</th>
                                        <th>Usuario</th>
                                        <th>Rol</th>
                                        <th>Categoría</th>
                                        <th>Tipo</th>
                                        <th>Monto</th>
                                        <th>Saldo Ant.</th>
                                        <th>Saldo Post.</th>
                                        <th>Descripción</th>
                                        <th>Comprobante</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($movimientos)): ?>
                                        <?php foreach ($movimientos as $mov): ?>
                                            <tr>
                                                <td><?php echo $mov['id']; ?></td>
                                                <td><?php echo date('d/m/Y', strtotime($mov['fecha_movimiento'])); ?></td>
                                                <td><?php echo htmlspecialchars($mov['nombre_completo']); ?></td>
                                                <td>
                                                    <span class="badge bg-secondary"><?php echo htmlspecialchars($mov['rol']); ?></span>
                                                </td>
                                                <td><?php echo htmlspecialchars($mov['categoria']); ?></td>
                                                <td>
                                                    <?php if ($mov['tipo'] === 'Ingreso'): ?>
                                                        <span class="badge bg-success">Ingreso</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-danger">Egreso</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="<?php echo $mov['tipo'] === 'Ingreso' ? 'text-success' : 'text-danger'; ?>">
                                                    <?php echo formatCurrency($mov['monto']); ?>
                                                </td>
                                                <td><?php echo formatCurrency($mov['saldo_anterior']); ?></td>
                                                <td><?php echo formatCurrency($mov['saldo_posterior']); ?></td>
                                                <td><?php echo htmlspecialchars(substr($mov['descripcion'], 0, 40)); ?></td>
                                                <td>
                                                    <?php if ($mov['comprobante']): ?>
                                                        <a href="uploads/<?php echo htmlspecialchars($mov['comprobante']); ?>" 
                                                           target="_blank" class="btn btn-sm btn-info">
                                                            <i class="bi bi-image"></i>
                                                        </a>
                                                    <?php else: ?>
                                                        -
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <a href="editar_movimiento.php?id=<?php echo $mov['id']; ?>" 
                                                       class="btn btn-sm btn-primary" title="Editar">
                                                        <i class="bi bi-pencil"></i>
                                                    </a>
                                                    <a href="eliminar_movimiento.php?id=<?php echo $mov['id']; ?>" 
                                                       class="btn btn-sm btn-danger" title="Eliminar"
                                                       onclick="return confirm('¿Está seguro de eliminar este movimiento? Esta acción no se puede deshacer.')">
                                                        <i class="bi bi-trash"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="12" class="text-center text-muted">No hay movimientos registrados</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

