<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('index.php');
}

$db = getDB();

// Obtener ID del movimiento
$movimiento_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$movimiento_id) {
    redirect('dashboard.php');
}

// Obtener información del usuario actual
$stmt = $db->prepare("SELECT u.*, r.nombre as rol_nombre FROM usuarios u 
                      INNER JOIN roles r ON u.rol_id = r.id 
                      WHERE u.id = ?");
$stmt->execute([$_SESSION['user_id']]);
$usuario = $stmt->fetch();

// Obtener el movimiento
$stmt = $db->prepare("SELECT m.*, u.nombre_completo as usuario_nombre, u.supervisor_id
                      FROM movimientos m 
                      INNER JOIN usuarios u ON m.usuario_id = u.id
                      WHERE m.id = ?");
$stmt->execute([$movimiento_id]);
$movimiento = $stmt->fetch();

if (!$movimiento) {
    $_SESSION['error'] = 'Movimiento no encontrado';
    redirect('dashboard.php');
}

// Verificar permisos
$puede_eliminar = false;
if ($usuario['rol_nombre'] === 'Administrador') {
    $puede_eliminar = true;
} elseif ($usuario['rol_nombre'] === 'Supervisor' && $movimiento['supervisor_id'] == $usuario['id']) {
    // Supervisor puede eliminar movimientos de sus operativos
    $puede_eliminar = true;
} elseif ($usuario['rol_nombre'] === 'Operativo' && $movimiento['usuario_id'] == $usuario['id']) {
    // Operativo puede eliminar solo sus propios movimientos
    $puede_eliminar = true;
}

if (!$puede_eliminar) {
    $_SESSION['error'] = 'No tiene permisos para eliminar este movimiento';
    redirect('dashboard.php');
}

try {
    $db->beginTransaction();
    
    // Si es egreso, devolver el monto al saldo del usuario
    if ($movimiento['tipo'] === 'Egreso') {
        $stmt = $db->prepare("UPDATE usuarios SET 
                              saldo_disponible = saldo_disponible + ?
                              WHERE id = ?");
        $stmt->execute([$movimiento['monto'], $movimiento['usuario_id']]);
    }
    
    // Eliminar comprobante si existe
    if ($movimiento['comprobante'] && file_exists(__DIR__ . '/uploads/' . $movimiento['comprobante'])) {
        unlink(__DIR__ . '/uploads/' . $movimiento['comprobante']);
    }
    
    // Eliminar movimiento
    $stmt = $db->prepare("DELETE FROM movimientos WHERE id = ?");
    $stmt->execute([$movimiento_id]);
    
    // Log
    $stmt = $db->prepare("INSERT INTO logs (usuario_id, accion, detalles, ip_address) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_SESSION['user_id'], 'Eliminar movimiento', 
                   "ID: $movimiento_id, Usuario: {$movimiento['usuario_nombre']}, Monto: {$movimiento['monto']}", 
                   $_SERVER['REMOTE_ADDR']]);
    
    $db->commit();
    
    $_SESSION['mensaje'] = 'Movimiento eliminado exitosamente';
    
} catch (Exception $e) {
    $db->rollBack();
    $_SESSION['error'] = 'Error al eliminar el movimiento: ' . $e->getMessage();
}

// Redirigir según el rol
if ($usuario['rol_nombre'] === 'Operativo') {
    redirect('mis_movimientos.php');
} else {
    redirect('movimientos.php');
}
?>

