<?php
require_once 'config.php';

if (!isLoggedIn() || !hasRole('Administrador')) {
    redirect('dashboard.php');
}

$db = getDB();
$mensaje = '';
$error = '';

// Obtener fondo total actual
$stmt = $db->query("SELECT valor FROM configuracion WHERE clave = 'fondo_total_proyecto'");
$fondo_actual = $stmt->fetchColumn();
$fondo_actual = $fondo_actual ? (float)$fondo_actual : 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $accion = $_POST['accion'] ?? '';
    
    if ($accion === 'establecer_fondo') {
        $nuevo_fondo = (float)str_replace(['.', ','], ['', '.'], $_POST['fondo_total']);
        
        if ($nuevo_fondo < 0) {
            $error = 'El fondo no puede ser negativo';
        } else {
            // Actualizar fondo total del proyecto
            $stmt = $db->prepare("UPDATE configuracion SET valor = ? WHERE clave = 'fondo_total_proyecto'");
            if ($stmt->execute([$nuevo_fondo])) {
                // Actualizar saldo disponible del Administrador
                $stmt = $db->query("SELECT SUM(fondo_asignado) as total_asignado FROM usuarios WHERE rol_id = 2 AND activo = 1");
                $total_asignado = $stmt->fetchColumn() ?? 0;
                $nuevo_saldo = $nuevo_fondo - $total_asignado;
                
                $stmt = $db->prepare("UPDATE usuarios SET saldo_disponible = ? WHERE id = ?");
                $stmt->execute([$nuevo_saldo, $_SESSION['user_id']]);
                
                $mensaje = 'Fondo total del proyecto actualizado exitosamente';
                $fondo_actual = $nuevo_fondo;
                
                // Log
                $stmt = $db->prepare("INSERT INTO logs (usuario_id, accion, detalles, ip_address) VALUES (?, ?, ?, ?)");
                $stmt->execute([$_SESSION['user_id'], 'Actualizar fondo total proyecto', "Nuevo fondo: $nuevo_fondo", $_SERVER['REMOTE_ADDR']]);
            } else {
                $error = 'Error al actualizar el fondo total';
            }
        }
    } elseif ($accion === 'agregar_fondos') {
        $monto_adicional = (float)str_replace(['.', ','], ['', '.'], $_POST['monto_adicional']);
        
        if ($monto_adicional <= 0) {
            $error = 'El monto adicional debe ser mayor a cero';
        } else {
            $nuevo_fondo = $fondo_actual + $monto_adicional;
            
            $stmt = $db->prepare("UPDATE configuracion SET valor = ? WHERE clave = 'fondo_total_proyecto'");
            if ($stmt->execute([$nuevo_fondo])) {
                // Actualizar saldo disponible del Administrador (sumar el monto adicional)
                $stmt = $db->prepare("UPDATE usuarios SET saldo_disponible = saldo_disponible + ? WHERE id = ?");
                $stmt->execute([$monto_adicional, $_SESSION['user_id']]);
                
                $mensaje = 'Fondos adicionales agregados exitosamente';
                $fondo_actual = $nuevo_fondo;
                
                // Log
                $stmt = $db->prepare("INSERT INTO logs (usuario_id, accion, detalles, ip_address) VALUES (?, ?, ?, ?)");
                $stmt->execute([$_SESSION['user_id'], 'Agregar fondos al proyecto', "Monto adicional: $monto_adicional, Nuevo total: $nuevo_fondo", $_SERVER['REMOTE_ADDR']]);
            } else {
                $error = 'Error al agregar fondos adicionales';
            }
        }
    }
}

// Calcular estadísticas
$stmt = $db->query("SELECT SUM(fondo_asignado) as total_asignado 
                    FROM usuarios WHERE rol_id = 2 AND activo = 1");
$total_asignado = $stmt->fetchColumn() ?? 0;

$saldo_disponible = $fondo_actual - $total_asignado;

// Obtener información del usuario actual
$stmt = $db->prepare("SELECT u.*, r.nombre as rol_nombre FROM usuarios u 
                      INNER JOIN roles r ON u.rol_id = r.id 
                      WHERE u.id = ?");
$stmt->execute([$_SESSION['user_id']]);
$usuario = $stmt->fetch();

$page_title = 'Configuración del Proyecto';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">
                        <i class="bi bi-gear"></i> Configuración del Proyecto
                    </h1>
                </div>
                
                <?php if ($mensaje): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle"></i> <?php echo $mensaje; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-triangle"></i> <?php echo $error; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <!-- Estado actual -->
                <div class="row mb-4">
                    <div class="col-md-4 mb-3">
                        <div class="card stat-card stat-primary">
                            <div class="card-body">
                                <h6 class="text-muted mb-2">Fondo Total del Proyecto</h6>
                                <h2 class="mb-0"><?php echo formatCurrency($fondo_actual); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="card stat-card stat-warning">
                            <div class="card-body">
                                <h6 class="text-muted mb-2">Asignado a Supervisores</h6>
                                <h2 class="mb-0"><?php echo formatCurrency($total_asignado); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="card stat-card stat-success">
                            <div class="card-body">
                                <h6 class="text-muted mb-2">Saldo Disponible</h6>
                                <h2 class="mb-0"><?php echo formatCurrency($saldo_disponible); ?></h2>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="card">
                            <div class="card-header bg-primary text-white">
                                <h5 class="mb-0"><i class="bi bi-pencil"></i> Establecer Fondo Total</h5>
                            </div>
                            <div class="card-body">
                                <form method="POST">
                                    <input type="hidden" name="accion" value="establecer_fondo">
                                    
                                    <div class="alert alert-info">
                                        <i class="bi bi-info-circle"></i> 
                                        Use esta opción para establecer el fondo total inicial del proyecto o modificarlo completamente.
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Fondo Total del Proyecto (Gs.) *</label>
                                        <input type="text" class="form-control form-control-lg" 
                                               name="fondo_total" id="fondo_total" 
                                               value="<?php echo number_format($fondo_actual, 0, ',', '.'); ?>" 
                                               required>
                                    </div>
                                    
                                    <div class="d-grid">
                                        <button type="submit" class="btn btn-primary btn-lg"
                                                onclick="return confirm('¿Está seguro de establecer este monto como fondo total del proyecto?');">
                                            <i class="bi bi-save"></i> Establecer Fondo Total
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <div class="card">
                            <div class="card-header bg-success text-white">
                                <h5 class="mb-0"><i class="bi bi-plus-circle"></i> Agregar Fondos Adicionales</h5>
                            </div>
                            <div class="card-body">
                                <form method="POST">
                                    <input type="hidden" name="accion" value="agregar_fondos">
                                    
                                    <div class="alert alert-success">
                                        <i class="bi bi-info-circle"></i> 
                                        Use esta opción para agregar fondos adicionales al proyecto sin modificar el total actual.
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Monto Adicional (Gs.) *</label>
                                        <input type="text" class="form-control form-control-lg" 
                                               name="monto_adicional" id="monto_adicional" 
                                               placeholder="0" required>
                                        <small class="text-muted">
                                            Fondo actual: <?php echo formatCurrency($fondo_actual); ?>
                                        </small>
                                    </div>
                                    
                                    <div class="d-grid">
                                        <button type="submit" class="btn btn-success btn-lg"
                                                onclick="return confirm('¿Está seguro de agregar estos fondos adicionales al proyecto?');">
                                            <i class="bi bi-plus-circle"></i> Agregar Fondos
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-info-circle"></i> Información Importante</h5>
                    </div>
                    <div class="card-body">
                        <ul>
                            <li><strong>Fondo Total del Proyecto:</strong> Es el monto total disponible para el proyecto. Este valor es fijo y solo debe modificarse cuando se reciban fondos adicionales o se ajuste el presupuesto.</li>
                            <li><strong>Saldo Disponible:</strong> Se calcula automáticamente restando del Fondo Total lo que ya se ha asignado a los Supervisores.</li>
                            <li><strong>Asignaciones:</strong> Cuando asigna fondos a Supervisores, el Saldo Disponible disminuye, pero el Fondo Total permanece igual.</li>
                            <li><strong>Total Gastado:</strong> Refleja únicamente los egresos registrados por los Operativos, no las asignaciones.</li>
                        </ul>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Formatear montos con separadores de miles
        document.getElementById('fondo_total').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            e.target.value = value.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
        });
        
        document.getElementById('monto_adicional').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            e.target.value = value.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
        });
    </script>
</body>
</html>

