<?php
// Configuración de la base de datos
define('DB_HOST', 'localhost');
define('DB_USER', 'aplicaci_ong2026');
define('DB_PASS', 'dem@2@26');
define('DB_NAME', 'aplicaci_demoong');

// Configuración de la aplicación
define('SITE_NAME', 'Rendición de Cuentas ONG');
define('CURRENCY', 'Gs.');
define('TIMEZONE', 'America/Asuncion');

// Configuración de reCAPTCHA v2 Invisible
define('RECAPTCHA_SITE_KEY', 'TU_SITE_KEY_AQUI');
define('RECAPTCHA_SECRET_KEY', 'TU_SECRET_KEY_AQUI');

// Configuración de sesión
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0); // Cambiar a 1 si usas HTTPS

session_start();

// Zona horaria
date_default_timezone_set(TIMEZONE);

// Conexión a la base de datos
function getDB() {
    static $pdo = null;
    
    if ($pdo === null) {
        try {
            $pdo = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
        } catch (PDOException $e) {
            die("Error de conexión: " . $e->getMessage());
        }
    }
    
    return $pdo;
}

// Función para verificar si el usuario está autenticado
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Función para verificar el rol del usuario
function hasRole($role) {
    return isset($_SESSION['role']) && $_SESSION['role'] === $role;
}

// Función para redirigir
function redirect($url) {
    header("Location: $url");
    exit();
}

// Función para formatear moneda en guaraníes
function formatCurrency($amount) {
    return CURRENCY . ' ' . number_format($amount, 0, ',', '.');
}

// Función para limpiar input
function cleanInput($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}
?>

