# Sistema de Rendición de Cuentas para ONG's

Sistema web PHP dinámico con base de datos MySQL para la gestión transparente de fondos en organizaciones civiles (ONG's).

## Características Principales

### Sistema de Roles Jerárquico
- **Administrador**: Nivel superior con acceso total al sistema
- **Supervisor**: Gestiona operativos y fondos asignados
- **Operativo**: Registra movimientos y gastos con comprobantes

### Funcionalidades

#### Administrador
- Crear, modificar y eliminar usuarios con diferentes roles
- Asignar fondos a Supervisores y Operativos
- Gestionar categorías de ingresos y egresos
- Ver todos los movimientos del sistema
- Exportar reportes a Excel y PDF
- Dashboard con vista completa del proyecto

#### Supervisor
- Crear usuarios con rol de Operativo
- Asignar fondos a sus operativos
- Ver movimientos de sus operativos
- Generar reportes de su equipo
- Dashboard con fondos asignados y disponibles

#### Operativo
- Registrar egresos con comprobantes fotográficos
- Ver historial de movimientos propios
- Consultar saldo disponible
- No puede modificar gastos registrados

### Características Técnicas
- Diseño responsive (móvil y desktop)
- Interfaz en tonalidad verde para ONG's
- Moneda en Guaraníes (Gs.) con separadores de miles
- Upload de comprobantes fotográficos
- Sistema de logs de actividad
- Seguridad con password hash
- Preparado para reCAPTCHA v2 Invisible

## Requisitos del Sistema

- PHP 7.4 o superior
- MySQL 5.7 o superior
- Apache/Nginx con mod_rewrite
- Extensiones PHP:
  - PDO
  - PDO_MySQL
  - GD (para manejo de imágenes)
  - mbstring

## Instalación

### 1. Configurar Base de Datos

```bash
# Acceder a MySQL
mysql -u root -p

# Crear usuario y base de datos
CREATE USER 'rendicionong'@'localhost' IDENTIFIED BY 'ongpgy_2026';
CREATE DATABASE rendicionpy CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
GRANT ALL PRIVILEGES ON rendicionpy.* TO 'rendicionong'@'localhost';
FLUSH PRIVILEGES;
EXIT;

# Importar estructura
mysql -u rendicionong -p rendicionpy < database.sql
```

### 2. Configurar Aplicación

```bash
# Copiar archivos al directorio web
cp -r * /var/www/html/rendicion_ong/

# Configurar permisos
chmod 755 /var/www/html/rendicion_ong
chmod 777 /var/www/html/rendicion_ong/uploads
chown -R www-data:www-data /var/www/html/rendicion_ong
```

### 3. Configurar reCAPTCHA (Opcional)

1. Obtener claves en: https://www.google.com/recaptcha/admin
2. Editar `config.php` y reemplazar:
   - `RECAPTCHA_SITE_KEY`
   - `RECAPTCHA_SECRET_KEY`

### 4. Configurar Apache

```apache
<VirtualHost *:80>
    ServerName rendicion.tudominio.com
    DocumentRoot /var/www/html/rendicion_ong
    
    <Directory /var/www/html/rendicion_ong>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
    
    ErrorLog ${APACHE_LOG_DIR}/rendicion_error.log
    CustomLog ${APACHE_LOG_DIR}/rendicion_access.log combined
</VirtualHost>
```

## Credenciales por Defecto

### Acceso Administrativo
- **Usuario**: Rendicion
- **Contraseña**: cuentas2025

### Base de Datos
- **Usuario**: rendicionong
- **Contraseña**: ongpgy_2026
- **Base de datos**: rendicionpy

**IMPORTANTE**: Cambiar estas credenciales en producción.

## Estructura de Archivos

```
rendicion_ong/
├── assets/
│   ├── css/
│   │   └── style.css
│   └── js/
├── includes/
│   ├── navbar.php
│   └── sidebar.php
├── uploads/              # Comprobantes fotográficos
├── config.php           # Configuración general
├── database.sql         # Estructura de base de datos
├── index.php           # Login
├── dashboard.php       # Dashboard principal
├── usuarios.php        # Gestión de usuarios (Admin)
├── asignaciones.php    # Asignar fondos (Admin)
├── nuevo_movimiento.php # Registrar gasto (Operativo)
├── mis_movimientos.php  # Historial (Operativo)
├── reportes.php        # Reportes y filtros
├── exportar.php        # Exportación Excel/PDF
└── logout.php          # Cerrar sesión
```

## Base de Datos

### Tablas Principales

- **usuarios**: Información de usuarios y saldos
- **roles**: Roles del sistema (Administrador, Supervisor, Operativo)
- **categorias**: Categorías de ingresos y egresos
- **movimientos**: Registro de transacciones
- **asignaciones**: Historial de asignación de fondos
- **logs**: Registro de actividad del sistema

## Seguridad

- Contraseñas hasheadas con `password_hash()`
- Prepared statements para prevenir SQL injection
- Validación de sesiones en cada página
- Control de permisos por rol
- Logs de actividad
- Sanitización de inputs

## Personalización

### Cambiar Colores
Editar variables en `assets/css/style.css`:
```css
:root {
    --primary-color: #2E7D32;
    --secondary-color: #66BB6A;
    --accent-color: #1B5E20;
}
```

### Agregar Logos
1. Reemplazar placeholders en `index.php`
2. Agregar imágenes en `assets/img/`

## Soporte

Para reportar problemas o solicitar funcionalidades, contactar al equipo de desarrollo.

## Licencia

Sistema desarrollado para uso exclusivo de organizaciones civiles sin fines de lucro.

---

**Versión**: 1.0  
**Fecha**: 2025  
**Desarrollado para**: Rendición de Cuentas ONG's Paraguay

