
# Manual de Usuario: Sistema de Rendición de Cuentas para ONG

---

## 1. Introducción

Bienvenido al **Sistema de Rendición de Cuentas para ONG**. Esta plataforma ha sido diseñada para proporcionar una gestión transparente, eficiente y segura de los fondos de proyectos, asegurando la trazabilidad completa de cada guaraní desde su asignación hasta su gasto final.

El sistema opera con una estructura jerárquica de tres roles principales: **Administrador**, **Supervisor** y **Operativo**, cada uno con permisos y funcionalidades específicas para garantizar un control adecuado y una delegación efectiva de responsabilidades.

Este manual le guiará a través de todas las características y funcionalidades disponibles para cada rol, permitiéndole aprovechar al máximo la plataforma.

---

## 2. Primeros Pasos: Acceso al Sistema

Para comenzar a utilizar el sistema, siga estos sencillos pasos:

1.  **Abra el navegador web** en su computadora, tablet o teléfono móvil.
2.  **Ingrese la URL** del sistema proporcionada por su organización (ej: `https://rendicion.su-ong.org`).
3.  **Ingrese sus credenciales**:
    *   **Usuario:** Su nombre de usuario asignado.
    *   **Contraseña:** Su contraseña personal.

![Login](https://i.imgur.com/login-placeholder.png)  *<-- Se reemplazará con una captura de pantalla real*

4.  Haga clic en el botón **"Ingresar"**.

Una vez autenticado, será redirigido a su **Dashboard** personalizado según su rol.

> **Nota de Seguridad:** Se recomienda cambiar su contraseña la primera vez que ingrese al sistema y no compartir sus credenciales con nadie.


---

## 3. Módulo Administrador

El rol de **Administrador** tiene control total sobre el sistema. Sus responsabilidades incluyen la configuración inicial del proyecto, la gestión de usuarios y la supervisión general de todos los fondos.

### 3.1. Dashboard del Administrador

El dashboard proporciona una vista panorámica del estado financiero del proyecto:

*   **Total del Proyecto:** Monto total asignado al proyecto. Este valor es fijo y solo cambia si usted lo modifica en "Configuración Proyecto".
*   **Saldo Disponible:** Es el "Total del Proyecto" menos los fondos que ha asignado a los Supervisores. Disminuye con cada asignación que realiza.
*   **Total Gastado:** Suma de todos los egresos registrados por todos los Operativos. Refleja el gasto real en campo.

### 3.2. Configuración del Proyecto

Esta sección es crucial para la configuración inicial y el mantenimiento de los fondos del proyecto.

*   **Establecer Fondo Total:** Defina aquí el presupuesto total del proyecto. Este será el punto de partida para todas las asignaciones.
*   **Agregar Fondos Adicionales:** Si el proyecto recibe fondos adicionales, use esta opción para sumarlos al total existente sin reemplazarlo.

### 3.3. Gestión de Usuarios

Aquí puede gestionar a todas las personas que utilizan el sistema.

*   **Crear Usuario:** Cree nuevos Administradores, Supervisores u Operativos. Asigne contraseñas y roles.
*   **Editar Usuario:** Modifique datos, cambie roles o reinicie contraseñas.
*   **Suspender/Reactivar Usuario:** Desactive temporalmente el acceso de un usuario sin eliminar sus datos. Puede reactivarlo en cualquier momento.
*   **Eliminar Usuario:** Elimine permanentemente a un usuario. **¡Esta acción no se puede deshacer!**

### 3.4. Asignar Fondos

Desde aquí, el Administrador distribuye los fondos a los Supervisores.

*   **Seleccione un Supervisor** de la lista.
*   **Ingrese el monto** a asignar.
*   **Adjunte un comprobante fotográfico** (opcional pero recomendado) de la transferencia o entrega.
*   El sistema deduce automáticamente el monto del "Saldo Disponible" del Administrador y lo suma al "Fondo Asignado" del Supervisor.

### 3.5. Gestión de Categorías

Las categorías ayudan a clasificar cada ingreso y egreso, facilitando la generación de reportes.

*   **Crear Categoría:** Defina nuevas categorías de Ingreso o Egreso (ej: "Transporte", "Alimentación", "Donación").
*   **Editar/Eliminar Categoría:** Modifique nombres o elimine categorías que no estén en uso.

### 3.6. Gestión de Movimientos

El Administrador tiene la capacidad de supervisar y gestionar todos los movimientos registrados en el sistema.

*   **Ver Todos los Movimientos:** Acceda a una lista completa de todos los ingresos y egresos de todos los usuarios.
*   **Editar Movimiento:** Corrija cualquier error en un movimiento registrado, ya sea el monto, la categoría o el comprobante.
*   **Eliminar Movimiento:** Elimine movimientos duplicados o incorrectos. El sistema ajustará automáticamente los saldos correspondientes.

### 3.7. Reportes

Genere informes detallados para análisis y auditoría.

*   **Filtros Avanzados:** Filtre por rango de fechas, tipo de movimiento, usuario o categoría.
*   **Exportar a PDF/Excel:** Exporte los datos filtrados a formatos estándar para su uso externo.


---

## 4. Módulo Supervisor

El rol de **Supervisor** actúa como un gerente de nivel medio. Recibe fondos del Administrador y los distribuye entre su equipo de Operativos, supervisando sus gastos.

### 4.1. Dashboard del Supervisor

El dashboard del Supervisor se enfoca en su propia gestión y la de su equipo.

*   **Fondo Asignado:** Monto total que el Administrador le ha asignado. Es un valor fijo.
*   **Saldo Disponible:** Es su "Fondo Asignado" menos lo que ha distribuido a sus Operativos. Disminuye con cada asignación que realiza.
*   **Total Gastado:** Suma de todos los egresos registrados por los Operativos que están bajo su supervisión.

### 4.2. Gestión de Operativos (Mis Operativos)

Esta sección le permite gestionar a su equipo directo.

*   **Crear Operativo:** Registre nuevos usuarios con el rol de Operativo, quienes quedarán automáticamente bajo su supervisión.
*   **Ver Equipo:** Consulte la lista de sus Operativos, sus fondos asignados y sus saldos disponibles.

### 4.3. Asignar Fondos a Operativos

Desde aquí, el Supervisor distribuye su presupuesto entre su equipo.

*   **Seleccione un Operativo** de su equipo.
*   **Ingrese el monto** a asignar desde su "Saldo Disponible".
*   El sistema deduce el monto de su saldo y lo suma al del Operativo.

### 4.4. Supervisión de Movimientos

El Supervisor puede ver todos los movimientos realizados por su equipo.

*   **Ver Movimientos del Equipo:** Acceda a la lista de gastos de sus Operativos.
*   **Editar/Eliminar Movimientos:** Corrija errores en los registros de su equipo si es necesario.

### 4.5. Reportes

Genere reportes enfocados en la actividad de su equipo para un control más detallado.


---

## 5. Módulo Operativo

El rol de **Operativo** es el encargado de ejecutar los gastos en campo y registrarlos en el sistema. Su función es fundamental para la trazabilidad de los fondos.

### 5.1. Dashboard del Operativo

El dashboard del Operativo es simple y se centra en su propia gestión de fondos.

*   **Fondo Asignado:** Monto total que su Supervisor le ha asignado.
*   **Saldo Disponible:** Su fondo disponible para gastar. Disminuye con cada egreso que registra.
*   **Total Gastado:** Suma de todos los egresos que ha registrado.

### 5.2. Registrar un Nuevo Movimiento (Gasto)

Esta es la función principal del Operativo.

1.  Haga clic en **"Nuevo Movimiento"**.
2.  **Seleccione la categoría** del gasto (ej: "Combustible", "Viáticos").
3.  **Ingrese el monto** del gasto.
4.  **Tome o adjunte una foto del comprobante** (factura, recibo). Esto es obligatorio.
5.  Añada una **descripción** breve.
6.  Haga clic en **"Guardar"**.

El sistema registrará el gasto y descontará automáticamente el monto de su "Saldo Disponible".

### 5.3. Mis Movimientos

Consulte el historial de todos los movimientos que ha registrado.

*   **Ver Historial:** Revise sus gastos pasados.
*   **Editar/Eliminar Movimientos:** Si cometió un error, puede editar o eliminar sus propios registros. Al eliminar un gasto, el monto se devolverá a su saldo.

---

## 6. Funcionalidades Adicionales

### 6.1. Menú Móvil

El sistema es **totalmente responsive** y funciona en cualquier dispositivo. En móviles, encontrará un **menú de hamburguesa (☰)** en la esquina superior izquierda que despliega todas las opciones de navegación.

### 6.2. Seguridad

*   **Contraseñas Seguras:** Todas las contraseñas están encriptadas.
*   **Logs de Actividad:** Cada acción importante (crear usuario, asignar fondos, eliminar movimiento) queda registrada para auditoría.
*   **Permisos Estrictos:** Un usuario no puede acceder a funcionalidades que no le corresponden a su rol.

---

**Fin del Manual**
