<?php
/**
 * Sistema Médico - Dashboard Principal
 */
require_once 'includes/config.php';
require_once 'includes/database.php';
require_once 'includes/auth.php';

$page_title = 'Dashboard';

// Obtener estadísticas
$database = new Database();
$db = $database->getConnection();

// Total de pacientes
$query = "SELECT COUNT(*) as total FROM pacientes";
$stmt = $db->query($query);
$total_pacientes = $stmt->fetch()['total'];

// Citas de hoy
$query = "SELECT COUNT(*) as total FROM citas WHERE DATE(fecha_cita) = CURDATE() AND estado != 'cancelada'";
$stmt = $db->query($query);
$citas_hoy = $stmt->fetch()['total'];

// Citas pendientes
$query = "SELECT COUNT(*) as total FROM citas WHERE estado = 'pendiente' AND fecha_cita >= NOW()";
$stmt = $db->query($query);
$citas_pendientes = $stmt->fetch()['total'];

// Pacientes con alertas
$query = "SELECT COUNT(DISTINCT paciente_id) as total FROM alertas_medicas WHERE activo = 1";
$stmt = $db->query($query);
$pacientes_alertas = $stmt->fetch()['total'];

// Próximas citas
$query = "SELECT c.*, p.nombre, p.apellido, p.cedula, u.nombre_completo as medico
          FROM citas c
          INNER JOIN pacientes p ON c.paciente_id = p.id
          INNER JOIN usuarios u ON c.medico_id = u.id
          WHERE c.fecha_cita >= NOW() AND c.estado != 'cancelada'
          ORDER BY c.fecha_cita ASC
          LIMIT 10";
$stmt = $db->query($query);
$proximas_citas = $stmt->fetchAll();

include 'includes/header.php';
?>

<div class="card">
    <div class="card-header">
        <h2>Bienvenido al Sistema Médico</h2>
    </div>
    <div class="card-body">
        <p>Gestión integral de pacientes, consultas y citas médicas.</p>
    </div>
</div>

<!-- Estadísticas -->
<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-bottom: 30px;">
    <div class="card" style="background: linear-gradient(135deg, #2c5aa0 0%, #4a7fc1 100%); color: white;">
        <h3 style="margin-bottom: 10px;">Total Pacientes</h3>
        <p style="font-size: 36px; font-weight: bold;"><?php echo $total_pacientes; ?></p>
    </div>

    <div class="card" style="background: linear-gradient(135deg, #4caf50 0%, #66bb6a 100%); color: white;">
        <h3 style="margin-bottom: 10px;">Citas Hoy</h3>
        <p style="font-size: 36px; font-weight: bold;"><?php echo $citas_hoy; ?></p>
    </div>

    <div class="card" style="background: linear-gradient(135deg, #ff9800 0%, #ffa726 100%); color: white;">
        <h3 style="margin-bottom: 10px;">Citas Pendientes</h3>
        <p style="font-size: 36px; font-weight: bold;"><?php echo $citas_pendientes; ?></p>
    </div>

    <div class="card" style="background: linear-gradient(135deg, #f44336 0%, #ef5350 100%); color: white;">
        <h3 style="margin-bottom: 10px;">Pacientes con Alertas</h3>
        <p style="font-size: 36px; font-weight: bold;"><?php echo $pacientes_alertas; ?></p>
    </div>
</div>

<!-- Próximas citas -->
<div class="card">
    <div class="card-header">
        <h2>Próximas Citas</h2>
    </div>
    <div class="card-body">
        <?php if (count($proximas_citas) > 0): ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Fecha y Hora</th>
                            <th>Paciente</th>
                            <th>Cédula</th>
                            <th>Médico</th>
                            <th>Tipo</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($proximas_citas as $cita): ?>
                            <tr>
                                <td><?php echo date('d/m/Y H:i', strtotime($cita['fecha_cita'])); ?></td>
                                <td><?php echo htmlspecialchars($cita['nombre'] . ' ' . $cita['apellido']); ?></td>
                                <td><?php echo htmlspecialchars($cita['cedula']); ?></td>
                                <td><?php echo htmlspecialchars($cita['medico']); ?></td>
                                <td>
                                    <?php
                                    $tipo_class = $cita['tipo'] == 'urgencia' ? 'alert-emergency' : '';
                                    echo '<span class="' . $tipo_class . '" style="padding: 5px 10px; border-radius: 5px;">' . ucfirst($cita['tipo']) . '</span>';
                                    ?>
                                </td>
                                <td><?php echo ucfirst($cita['estado']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p>No hay citas programadas.</p>
        <?php endif; ?>
    </div>
</div>

<!-- Accesos rápidos -->
<div class="card">
    <div class="card-header">
        <h2>Accesos Rápidos</h2>
    </div>
    <div class="card-body">
        <div style="display: flex; gap: 15px; flex-wrap: wrap;">
            <a href="pages/buscar_paciente.php" class="btn btn-primary">🔍 Buscar Paciente</a>
            <a href="pages/nuevo_paciente.php" class="btn btn-success">➕ Nuevo Paciente</a>
            <a href="pages/citas.php" class="btn btn-primary">📅 Gestionar Citas</a>
            <a href="pages/citas_urgencia.php" class="btn btn-danger">🚨 Cita de Urgencia</a>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>

