/**
 * Sistema Médico - JavaScript Principal
 */

// Confirmar acciones de eliminación
function confirmarEliminacion(mensaje) {
    return confirm(mensaje || '¿Está seguro de que desea eliminar este registro?');
}

// Validar formularios
function validarFormulario(formId) {
    const form = document.getElementById(formId);
    if (!form) return false;

    const inputs = form.querySelectorAll('[required]');
    let valido = true;

    inputs.forEach(input => {
        if (!input.value.trim()) {
            input.style.borderColor = 'red';
            valido = false;
        } else {
            input.style.borderColor = '';
        }
    });

    return valido;
}

// Buscar en tabla
function buscarEnTabla(inputId, tablaId) {
    const input = document.getElementById(inputId);
    const tabla = document.getElementById(tablaId);
    
    if (!input || !tabla) return;

    const filtro = input.value.toUpperCase();
    const filas = tabla.getElementsByTagName('tr');

    for (let i = 1; i < filas.length; i++) {
        const fila = filas[i];
        const celdas = fila.getElementsByTagName('td');
        let encontrado = false;

        for (let j = 0; j < celdas.length; j++) {
            const celda = celdas[j];
            if (celda) {
                const textocelda = celda.textContent || celda.innerText;
                if (textocelda.toUpperCase().indexOf(filtro) > -1) {
                    encontrado = true;
                    break;
                }
            }
        }

        fila.style.display = encontrado ? '' : 'none';
    }
}

// Formatear fecha
function formatearFecha(fecha) {
    const d = new Date(fecha);
    const dia = String(d.getDate()).padStart(2, '0');
    const mes = String(d.getMonth() + 1).padStart(2, '0');
    const anio = d.getFullYear();
    return `${dia}/${mes}/${anio}`;
}

// Calcular edad desde fecha de nacimiento
function calcularEdad(fechaNacimiento) {
    const hoy = new Date();
    const nacimiento = new Date(fechaNacimiento);
    let edad = hoy.getFullYear() - nacimiento.getFullYear();
    const mes = hoy.getMonth() - nacimiento.getMonth();
    
    if (mes < 0 || (mes === 0 && hoy.getDate() < nacimiento.getDate())) {
        edad--;
    }
    
    return edad;
}

// Mostrar/ocultar secciones
function toggleSeccion(seccionId) {
    const seccion = document.getElementById(seccionId);
    if (seccion) {
        seccion.style.display = seccion.style.display === 'none' ? 'block' : 'none';
    }
}

// Auto-guardar formulario en localStorage
function autoGuardarFormulario(formId) {
    const form = document.getElementById(formId);
    if (!form) return;

    const inputs = form.querySelectorAll('input, textarea, select');
    inputs.forEach(input => {
        input.addEventListener('change', () => {
            localStorage.setItem(`${formId}_${input.name}`, input.value);
        });
    });
}

// Restaurar formulario desde localStorage
function restaurarFormulario(formId) {
    const form = document.getElementById(formId);
    if (!form) return;

    const inputs = form.querySelectorAll('input, textarea, select');
    inputs.forEach(input => {
        const valor = localStorage.getItem(`${formId}_${input.name}`);
        if (valor) {
            input.value = valor;
        }
    });
}

// Limpiar localStorage del formulario
function limpiarFormularioGuardado(formId) {
    const form = document.getElementById(formId);
    if (!form) return;

    const inputs = form.querySelectorAll('input, textarea, select');
    inputs.forEach(input => {
        localStorage.removeItem(`${formId}_${input.name}`);
    });
}

// Imprimir sección
function imprimirSeccion(seccionId) {
    const seccion = document.getElementById(seccionId);
    if (!seccion) return;

    const ventanaImpresion = window.open('', '', 'height=600,width=800');
    ventanaImpresion.document.write('<html><head><title>Imprimir</title>');
    ventanaImpresion.document.write('<link rel="stylesheet" href="../assets/css/style.css">');
    ventanaImpresion.document.write('</head><body>');
    ventanaImpresion.document.write(seccion.innerHTML);
    ventanaImpresion.document.write('</body></html>');
    ventanaImpresion.document.close();
    ventanaImpresion.print();
}

// Mostrar notificación
function mostrarNotificacion(mensaje, tipo = 'info') {
    const notificacion = document.createElement('div');
    notificacion.className = `alert alert-${tipo}`;
    notificacion.textContent = mensaje;
    notificacion.style.position = 'fixed';
    notificacion.style.top = '20px';
    notificacion.style.right = '20px';
    notificacion.style.zIndex = '9999';
    notificacion.style.minWidth = '300px';

    document.body.appendChild(notificacion);

    setTimeout(() => {
        notificacion.remove();
    }, 5000);
}

// Toggle del menú en móviles
function toggleMenu() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    
    if (sidebar && overlay) {
        sidebar.classList.toggle('active');
        overlay.classList.toggle('active');
        
        // Prevenir scroll del body cuando el menú está abierto
        if (sidebar.classList.contains('active')) {
            document.body.style.overflow = 'hidden';
        } else {
            document.body.style.overflow = '';
        }
    }
}

// Cerrar menú al hacer clic en un enlace (en móviles)
function closeMenuOnClick() {
    if (window.innerWidth <= 768) {
        const menuLinks = document.querySelectorAll('.sidebar-menu a');
        menuLinks.forEach(link => {
            link.addEventListener('click', function() {
                toggleMenu();
            });
        });
    }
}

// Cerrar menú al cambiar el tamaño de ventana
window.addEventListener('resize', function() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    
    if (window.innerWidth > 768) {
        if (sidebar) sidebar.classList.remove('active');
        if (overlay) overlay.classList.remove('active');
        document.body.style.overflow = '';
    }
});

// Inicialización cuando el DOM esté listo
document.addEventListener('DOMContentLoaded', function() {
    // Agregar clase active a enlaces del menú según la página actual
    const currentPage = window.location.pathname.split('/').pop();
    const menuLinks = document.querySelectorAll('.sidebar-menu a');
    
    menuLinks.forEach(link => {
        if (link.getAttribute('href') === currentPage || 
            link.getAttribute('href').includes(currentPage)) {
            link.classList.add('active');
        }
    });
    
    // Configurar cierre de menú en móviles
    closeMenuOnClick();
});

