# Sistema Médico - Resumen del Proyecto

## Descripción General

Sistema web completo para la gestión integral de un centro médico, desarrollado en PHP con base de datos MySQL. El sistema permite gestionar pacientes, consultas médicas, historial clínico, alertas médicas y agenda de citas.

## Características Implementadas

### ✅ Aspecto Visual
- **Tema de salud:** Colores azul médico (#2c5aa0) y verde salud (#4caf50)
- **Logotipo del sanatorio:** Incluido en todas las páginas
- **Información del centro:** Dirección y RUC visibles en header y login
- **Diseño profesional:** Interfaz moderna, limpia y responsive

### ✅ Gestión de Pacientes

#### Datos Permanentes del Paciente
- Nombre y apellido completo
- Cédula (único)
- Fecha de nacimiento (con cálculo automático de edad)
- Teléfono
- Domicilio
- Alergias a medicamentos
- Resistencias a medicamentos
- Medicamentos que consume de por vida
- Otras dolencias o condiciones crónicas

#### Sistema de Alertas
- **Alertas parpadeantes:** Cuando el paciente tiene alergias, resistencias o condiciones especiales, aparece un panel en **color naranja parpadeante** (efecto sirena)
- **Clasificación por severidad:** Baja, media, alta, crítica
- **Tipos de alertas:**
  - Alergias
  - Resistencias a medicamentos
  - Medicamentos permanentes
  - Otras dolencias
- **Gestión de alertas:** Activar/desactivar según sea necesario

### ✅ Funcionalidades de Búsqueda

#### Búsqueda de Pacientes
- **Búsqueda por múltiples criterios:** Nombre, apellido o cédula
- **Resultados completos:** Muestra todos los datos relevantes
- **Indicador de alertas:** Resalta pacientes con alertas médicas
- **Acceso directo:** Botón para ver ficha completa del paciente

#### Ficha del Paciente
- **Historial completo:** Todas las consultas anteriores
- **Datos de última visita:** Panel destacado con:
  - Peso (kg)
  - Presión arterial
  - Masa muscular (%)
- **Alertas visibles:** Panel parpadeante en naranja si tiene alertas
- **Navegación rápida:** Accesos directos a nueva consulta y agendar cita

### ✅ Registro de Consultas

#### Datos de la Consulta
- Motivo de la visita
- Peso del paciente
- Presión arterial
- Masa muscular
- Diagnóstico médico
- Observaciones

#### Tratamiento Médico
- **Múltiples tratamientos:** Se pueden agregar varios tratamientos
- Descripción del tratamiento
- Duración
- Indicaciones especiales

#### Medicamentos Recetados
- **Múltiples medicamentos:** Se pueden recetar varios medicamentos
- Nombre del medicamento
- Dosis
- Frecuencia de administración
- Duración del tratamiento
- Indicaciones especiales

### ✅ Gestión de Citas

#### Tipos de Citas
- **Normal:** Citas regulares
- **Seguimiento:** Controles posteriores
- **Urgencia:** Atención inmediata

#### Funcionalidades
- **Agendar citas:** Programar citas futuras con fecha y hora
- **Citas de urgencia:** Registro inmediato con fecha/hora actual
- **Estados de citas:**
  - Pendiente
  - Confirmada
  - Completada
  - Cancelada
- **Filtros:** Ver citas por estado y fecha
- **Actualización:** Cambiar estado de las citas

### ✅ Dashboard y Estadísticas
- Total de pacientes registrados
- Citas programadas para hoy
- Citas pendientes
- Pacientes con alertas médicas
- Lista de próximas citas
- Accesos rápidos a funciones principales

## Estructura Técnica

### Base de Datos: `centrobd`
- **Usuario:** consutorio
- **Contraseña:** Consult@s

#### Tablas Implementadas
1. **usuarios** - Médicos y administradores del sistema
2. **pacientes** - Datos permanentes de pacientes
3. **alertas_medicas** - Alergias, resistencias y condiciones especiales
4. **consultas** - Registro de todas las consultas médicas
5. **tratamientos** - Tratamientos prescritos en cada consulta
6. **medicamentos_recetados** - Medicamentos recetados con detalles
7. **citas** - Agenda de citas médicas

### Tecnologías Utilizadas
- **Backend:** PHP 7.4+ con PDO
- **Base de datos:** MySQL 5.7+
- **Frontend:** HTML5, CSS3, JavaScript
- **Seguridad:** 
  - Contraseñas hasheadas con bcrypt
  - Prepared statements para prevenir SQL injection
  - Validación de sesiones
  - Sanitización de datos

### Archivos del Sistema

#### Archivos Principales
- `index.php` - Dashboard principal
- `login.php` - Página de inicio de sesión
- `logout.php` - Cerrar sesión

#### Módulo de Pacientes
- `pages/buscar_paciente.php` - Búsqueda de pacientes
- `pages/nuevo_paciente.php` - Registro de nuevos pacientes
- `pages/ficha_paciente.php` - Ficha completa del paciente
- `pages/editar_paciente.php` - Edición de datos y alertas

#### Módulo de Consultas
- `pages/nueva_consulta.php` - Registro de consultas médicas

#### Módulo de Citas
- `pages/citas.php` - Gestión de citas
- `pages/agendar_cita.php` - Agendar nueva cita
- `pages/citas_urgencia.php` - Registro de urgencias
- `pages/actualizar_cita.php` - Actualizar estado de citas

#### Archivos de Configuración
- `includes/config.php` - Configuración general
- `includes/database.php` - Clase de conexión a BD
- `includes/auth.php` - Sistema de autenticación
- `includes/header.php` - Header común
- `includes/footer.php` - Footer común

#### Recursos
- `assets/css/style.css` - Estilos con tema médico
- `assets/js/main.js` - JavaScript principal
- `assets/images/logo.jpg` - Logotipo del centro

#### Base de Datos
- `database/schema.sql` - Esquema completo de la BD

#### Documentación
- `README.md` - Documentación técnica completa
- `INSTALACION.txt` - Guía de instalación rápida
- `MANUAL_USUARIO.md` - Manual de usuario detallado
- `RESUMEN_PROYECTO.md` - Este archivo

## Credenciales de Acceso

### Usuario por Defecto
- **Usuario:** centro
- **Contraseña:** medico

**Importante:** Cambiar la contraseña después de la primera instalación.

## Características de Seguridad

1. **Autenticación segura:** Contraseñas hasheadas con bcrypt
2. **Protección SQL Injection:** Uso de prepared statements
3. **Validación de sesiones:** Verificación en todas las páginas
4. **Sanitización de datos:** Limpieza de entradas de usuario
5. **Headers de seguridad:** Configurados en .htaccess

## Personalización

### Información del Centro
Editar en `includes/config.php`:
- Nombre del centro médico
- Dirección
- RUC
- Teléfono

### Logotipo
Reemplazar `assets/images/logo.jpg` (recomendado: 200x200px)

### Colores
Modificar variables CSS en `assets/css/style.css`

## Instalación Rápida

1. **Crear base de datos:**
```sql
CREATE DATABASE centrobd;
CREATE USER 'consutorio'@'localhost' IDENTIFIED BY 'Consult@s';
GRANT ALL PRIVILEGES ON centrobd.* TO 'consutorio'@'localhost';
```

2. **Importar esquema:**
```bash
mysql -u consutorio -pConsult@s centrobd < database/schema.sql
```

3. **Copiar archivos al servidor web:**
```bash
cp -r sistema-medico /var/www/html/
```

4. **Acceder al sistema:**
```
http://localhost/sistema-medico/login.php
```

## Funcionalidades Destacadas

### 🚨 Sistema de Alertas Parpadeantes
Las alertas médicas importantes (alergias, resistencias) se muestran con un efecto visual parpadeante en color naranja, similar a una sirena de alerta, garantizando que el personal médico no pase por alto información crítica.

### 📊 Datos de Última Visita
En la ficha del paciente, se muestra un panel destacado con los signos vitales de la última consulta (peso, presión, masa muscular), permitiendo al médico tener contexto inmediato antes de una nueva consulta.

### 🔍 Búsqueda Inteligente
El sistema permite buscar pacientes por múltiples criterios y muestra inmediatamente si tienen alertas médicas activas.

### 📝 Historial Completo
Cada consulta se registra con todos sus detalles: motivo, signos vitales, diagnóstico, tratamientos y medicamentos, creando un historial médico completo y accesible.

### ⚡ Citas de Urgencia
Función especial para registrar atenciones de urgencia con fecha/hora automática y estado confirmado, agilizando el proceso en situaciones críticas.

## Requisitos del Sistema

- PHP 7.4 o superior
- MySQL 5.7 o superior
- Servidor web (Apache/Nginx)
- Extensiones PHP: PDO, PDO_MySQL

## Estado del Proyecto

✅ **Completado al 100%**

Todas las funcionalidades solicitadas han sido implementadas:
- ✅ Tema visual de salud
- ✅ Logotipo y datos del sanatorio
- ✅ Gestión completa de pacientes
- ✅ Sistema de alertas parpadeantes
- ✅ Búsqueda de pacientes con historial
- ✅ Datos de última visita destacados
- ✅ Registro de consultas completo
- ✅ Tratamientos médicos
- ✅ Prescripción de medicamentos
- ✅ Agenda de citas
- ✅ Citas de urgencia
- ✅ Base de datos completa
- ✅ Sistema de autenticación

## Soporte y Documentación

- **README.md:** Documentación técnica completa
- **INSTALACION.txt:** Guía de instalación paso a paso
- **MANUAL_USUARIO.md:** Manual detallado para usuarios finales
- **RESUMEN_PROYECTO.md:** Este documento

---

**Sistema Médico v1.0**  
**Desarrollo completado: 2025**  
**Tecnologías: PHP, MySQL, HTML5, CSS3, JavaScript**

