<?php
require_once 'config.php';
checkLogin();

$id = $_GET['id'] ?? null;
if (!$id) {
    header("Location: index.php");
    exit();
}

$stmt = $pdo->prepare("SELECT * FROM contactos WHERE id = ?");
$stmt->execute([$id]);
$c = $stmt->fetch();

if (!$c) {
    header("Location: index.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Detalle de Contacto - Directorio Corporativo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background: #f4f7f6; }
        .detail-card { background: white; border-radius: 15px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); overflow: hidden; }
        .detail-header { background: #003366; color: white; padding: 2rem; text-align: center; }
        .detail-body { padding: 2rem; }
        .info-label { font-weight: bold; color: #003366; width: 150px; display: inline-block; }
    </style>
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="detail-card">
                    <div class="detail-header">
                        <i class="fas fa-user-tie fa-4x mb-3"></i>
                        <h2><?php echo htmlspecialchars($c['nombre_apellido']); ?></h2>
                        <p class="mb-0"><?php echo htmlspecialchars($c['empresa']); ?></p>
                    </div>
                    <div class="detail-body">
                        <div class="mb-3">
                            <span class="info-label">País:</span> <?php echo htmlspecialchars($c['pais']); ?>
                        </div>
                        <div class="mb-3">
                            <span class="info-label">Ciudad:</span> <?php echo htmlspecialchars($c['ciudad']); ?>
                        </div>
                        <div class="mb-3">
                            <span class="info-label">Teléfono 1:</span> 
                            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $c['telefono1']); ?>" target="_blank" class="text-success">
                                <i class="fab fa-whatsapp"></i> <?php echo htmlspecialchars($c['telefono1']); ?>
                            </a>
                        </div>
                        <div class="mb-3">
                            <span class="info-label">Teléfono 2:</span> <?php echo htmlspecialchars($c['telefono2']); ?>
                        </div>
                        <div class="mb-3">
                            <span class="info-label">Correo:</span> 
                            <a href="mailto:<?php echo htmlspecialchars($c['correo']); ?>" class="text-primary">
                                <i class="fas fa-envelope"></i> <?php echo htmlspecialchars($c['correo']); ?>
                            </a>
                        </div>
                        <div class="mb-3">
                            <span class="info-label">Cumpleaños:</span> <?php echo $c['fecha_cumpleanos'] ? date('d/m/Y', strtotime($c['fecha_cumpleanos'])) : 'No registrado'; ?>
                        </div>
                        <div class="mb-3">
                            <span class="info-label">Descripción:</span>
                            <p class="mt-2 p-3 bg-light rounded"><?php echo nl2br(htmlspecialchars($c['descripcion'])); ?></p>
                        </div>
                        <div class="mb-3">
                            <span class="info-label">Geoposición:</span> <?php echo $c['latitud']; ?>, <?php echo $c['longitud']; ?>
                        </div>
                        <hr>
                        <div class="text-center">
                            <a href="index.php" class="btn btn-secondary">Volver</a>
                            <a href="editar.php?id=<?php echo $c['id']; ?>" class="btn btn-warning">Editar</a>
                            <a href="mapa.php?id=<?php echo $c['id']; ?>" class="btn btn-info text-white">Ver Mapa</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
