<?php
require_once 'config.php';
checkLogin();

// Búsqueda
$search = $_GET['search'] ?? '';
$query = "SELECT * FROM contactos";
if ($search) {
    $query .= " WHERE nombre_apellido LIKE :search OR empresa LIKE :search OR correo LIKE :search";
}
$stmt = $pdo->prepare($query);
if ($search) {
    $stmt->execute(['search' => "%$search%"]);
} else {
    $stmt->execute();
}
$contactos = $stmt->fetchAll();

// Verificar cumpleaños hoy
$hoy = date('m-d');
$cumpleanos_hoy = [];
foreach ($contactos as $contacto) {
    if ($contacto['fecha_cumpleanos']) {
        if (date('m-d', strtotime($contacto['fecha_cumpleanos'])) == $hoy) {
            $cumpleanos_hoy[] = $contacto['nombre_apellido'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Directorio Corporativo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background: #f4f7f6;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .navbar-corporate {
            background-color: #003366;
            color: white;
        }
        .hero-section {
            background: url('https://images.unsplash.com/photo-1497215728101-856f4ea42174?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80') no-repeat center center;
            background-size: cover;
            height: 200px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
            margin-bottom: 2rem;
        }
        .card-contact {
            border-left: 5px solid #003366;
            transition: transform 0.2s;
        }
        .card-contact:hover {
            transform: scale(1.02);
        }
        .btn-whatsapp { color: #25D366; }
        .btn-outlook { color: #0078D4; }
        .modal-header-corp {
            background-color: #003366;
            color: white;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-corporate mb-0">
        <div class="container">
            <a class="navbar-brand text-white" href="index.php"><i class="fas fa-building me-2"></i>Directorio Corporativo</a>
            <div class="ms-auto">
                <a href="logout.php" class="btn btn-outline-light btn-sm">Cerrar Sesión</a>
            </div>
        </div>
    </nav>

    <div class="hero-section">
        <h1>Gestión de Contactos Organizacionales</h1>
    </div>

    <div class="container">
        <div class="row mb-4">
            <div class="col-md-6">
                <form class="d-flex" method="GET">
                    <input class="form-control me-2" type="search" name="search" placeholder="Buscar contacto..." value="<?php echo htmlspecialchars($search); ?>">
                    <button class="btn btn-primary" type="submit">Buscar</button>
                </form>
            </div>
            <div class="col-md-6 text-end">
                <a href="agregar.php" class="btn btn-success"><i class="fas fa-plus me-2"></i>Nuevo Contacto</a>
                <a href="exportar.php" class="btn btn-info text-white"><i class="fas fa-file-excel me-2"></i>Exportar Excel</a>
            </div>
        </div>

        <div class="table-responsive bg-white p-3 rounded shadow-sm">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Nombre y Apellido</th>
                        <th>Empresa</th>
                        <th>Teléfono</th>
                        <th>Correo</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($contactos as $c): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($c['nombre_apellido']); ?></td>
                        <td><?php echo htmlspecialchars($c['empresa']); ?></td>
                        <td>
                            <?php if ($c['telefono1']): ?>
                                <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $c['telefono1']); ?>" target="_blank" class="btn-whatsapp">
                                    <i class="fab fa-whatsapp"></i> <?php echo htmlspecialchars($c['telefono1']); ?>
                                </a>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($c['correo']): ?>
                                <a href="mailto:<?php echo htmlspecialchars($c['correo']); ?>" class="btn-outlook">
                                    <i class="fas fa-envelope"></i> <?php echo htmlspecialchars($c['correo']); ?>
                                </a>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="ver.php?id=<?php echo $c['id']; ?>" class="btn btn-sm btn-outline-primary" title="Ver"><i class="fas fa-eye"></i></a>
                            <a href="mapa.php?id=<?php echo $c['id']; ?>" class="btn btn-sm btn-outline-secondary" title="Mapa"><i class="fas fa-map-marker-alt"></i></a>
                            <a href="editar.php?id=<?php echo $c['id']; ?>" class="btn btn-sm btn-outline-warning" title="Editar"><i class="fas fa-edit"></i></a>
                            <a href="eliminar.php?id=<?php echo $c['id']; ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('¿Eliminar contacto?')" title="Eliminar"><i class="fas fa-trash"></i></a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Popup de Cumpleaños -->
    <?php if (!empty($cumpleanos_hoy)): ?>
    <div class="modal fade" id="birthdayModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header modal-header-corp">
                    <h5 class="modal-title"><i class="fas fa-birthday-cake me-2"></i>¡Feliz Cumpleaños!</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <p>Hoy celebramos el cumpleaños de:</p>
                    <h4 class="text-primary"><?php echo implode(', ', $cumpleanos_hoy); ?></h4>
                    <p>¡Que tengan un excelente día en la organización!</p>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        var myModal = new bootstrap.Modal(document.getElementById('birthdayModal'));
        myModal.show();
    </script>
    <?php else: ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <?php endif; ?>
</body>
</html>
