<?php
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Tutorial Interactivo - Directorio Corporativo</title>
    <link rel="stylesheet" href="style.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .tutorial-card {
            background: #fff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            max-width: 800px;
            margin: 50px auto;
            text-align: center;
        }
        .step { display: none; }
        .step.active { display: block; animation: fadeIn 0.5s; }
        @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
        .step-img {
            width: 100%;
            max-width: 600px;
            height: 300px;
            background: #f0f2f5;
            margin: 20px auto;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #999;
            border: 2px dashed #ccc;
        }
        .progress-bar {
            height: 10px;
            background: #eee;
            border-radius: 5px;
            margin-bottom: 30px;
            overflow: hidden;
        }
        .progress-fill {
            height: 100%;
            background: #0056b3;
            width: 0%;
            transition: width 0.3s;
        }
        .nav-btns { margin-top: 30px; display: flex; justify-content: space-between; }
    </style>
</head>
<body>
    <div class="overlay">
        <div class="container">
            <div class="tutorial-card">
                <div class="progress-bar"><div class="progress-fill" id="progress"></div></div>
                
                <!-- Paso 1 -->
                <div class="step active" data-step="1">
                    <h2>👋 ¡Bienvenido al Directorio Corporativo!</h2>
                    <p>Esta guía te enseñará a utilizar todas las herramientas de tu nueva plataforma de gestión de contactos.</p>
                    <div class="step-img">💻 Interfaz Principal</div>
                    <p>El sistema está diseñado para ser intuitivo y eficiente, con un enfoque en la comunicación rápida.</p>
                </div>

                <!-- Paso 2 -->
                <div class="step" data-step="2">
                    <h2>➕ Agregar Contactos</h2>
                    <p>Haz clic en el botón <strong>"+ Nuevo Contacto"</strong> en la parte superior.</p>
                    <div class="step-img">📝 Formulario de Registro</div>
                    <p>Al elegir un país, el sistema pondrá automáticamente el código telefónico. ¡Recuerda que puedes agregar dos números!</p>
                </div>

                <!-- Paso 3 -->
                <div class="step" data-step="3">
                    <h2>📞 Comunicación Directa</h2>
                    <p>¿Necesitas contactar a alguien? Es muy simple:</p>
                    <ul style="text-align: left; display: inline-block;">
                        <li>Haz clic en el <strong>Teléfono</strong> para abrir WhatsApp.</li>
                        <li>Haz clic en el <strong>Correo</strong> para abrir Outlook.</li>
                    </ul>
                    <div class="step-img">📱 WhatsApp & Outlook Integration</div>
                </div>

                <!-- Paso 4 -->
                <div class="step" data-step="4">
                    <h2>🗺️ Mapa y Detalles</h2>
                    <p>Utiliza el botón <strong>"Ver"</strong> para ver toda la ficha del contacto o <strong>"Mapa"</strong> para ver su ubicación geográfica.</p>
                    <div class="step-img">📍 Geolocalización Interactiva</div>
                </div>

                <!-- Paso 5 -->
                <div class="step" data-step="5">
                    <h2>🎂 Alertas de Cumpleaños</h2>
                    <p>Cada vez que inicies sesión, el sistema te avisará con un popup si algún colega está de cumpleaños hoy.</p>
                    <div class="step-img">🎉 Popup de Felicitaciones</div>
                </div>

                <!-- Paso 6 -->
                <div class="step" data-step="6">
                    <h2>📊 Exportación a Excel</h2>
                    <p>¿Necesitas los datos fuera del sistema? Usa el botón <strong>"Exportar Excel"</strong> para descargar la lista completa en formato CSV compatible.</p>
                    <div class="step-img">📥 Descarga de Reportes</div>
                </div>

                <div class="nav-btns">
                    <button class="btn btn-danger" id="prevBtn" disabled>Anterior</button>
                    <button class="btn btn-primary" id="nextBtn">Siguiente</button>
                    <a href="index.php" class="btn btn-success" id="finishBtn" style="display:none;">Comenzar a usar</a>
                </div>
            </div>
        </div>
    </div>

    <script>
        let currentStep = 1;
        const totalSteps = 6;

        function updateTutorial() {
            $('.step').removeClass('active');
            $(`.step[data-step="${currentStep}"]`).addClass('active');
            
            const progress = (currentStep / totalSteps) * 100;
            $('#progress').css('width', progress + '%');

            $('#prevBtn').prop('disabled', currentStep === 1);
            
            if (currentStep === totalSteps) {
                $('#nextBtn').hide();
                $('#finishBtn').show();
            } else {
                $('#nextBtn').show();
                $('#finishBtn').hide();
            }
        }

        $('#nextBtn').click(function() {
            if (currentStep < totalSteps) {
                currentStep++;
                updateTutorial();
            }
        });

        $('#prevBtn').click(function() {
            if (currentStep > 1) {
                currentStep--;
                updateTutorial();
            }
        });

        updateTutorial();
    </script>
</body>
</html>
