<?php
session_start();
if (file_exists('db.php')) {
    require 'db.php';
} elseif (file_exists('../db.php')) {
    require '../db.php';
} else {
    die("Error: No se pudo encontrar el archivo de configuración de la base de datos (db.php).");
}

if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

// Obtener contactos
$stmt = $pdo->query("SELECT * FROM contactos ORDER BY nombre_apellido ASC");
$contactos = $stmt->fetchAll();

// Verificar cumpleaños hoy
$hoy = date('m-d');
$cumpleañeros = [];
foreach ($contactos as $c) {
    if (!empty($c['fecha_cumpleaños'])) {
        $fecha_c = date('m-d', strtotime($c['fecha_cumpleaños']));
        if ($fecha_c == $hoy) {
            $cumpleañeros[] = $c['nombre_apellido'];
        }
    }
}

// Procesar guardado de contacto
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'save') {
    $nombre = $_POST['nombre_apellido'] ?? '';
    $empresa = $_POST['empresa'] ?? '';
    $pais = $_POST['pais'] ?? '';
    $ciudad = $_POST['ciudad'] ?? '';
    $tel1 = $_POST['telefono1'] ?? '';
    $tel2 = $_POST['telefono2'] ?? '';
    $correo = $_POST['correo'] ?? '';
    $desc = $_POST['descripcion'] ?? '';
    $cumple = $_POST['fecha_cumpleaños'] ?: null;
    
    // Generar geoposición (coordenadas aleatorias para el ejemplo visual del mapa)
    // Si no se proporciona una, generamos una por defecto para que el mapa funcione
    $lat = rand(-25, -23) . "." . rand(100000, 999999);
    $lng = rand(-58, -56) . "." . rand(100000, 999999);
    $geo = "$lat,$lng"; 

    $sql = "INSERT INTO contactos (nombre_apellido, empresa, pais, ciudad, telefono1, telefono2, correo, geoposicion, descripcion, fecha_cumpleaños) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$nombre, $empresa, $pais, $ciudad, $tel1, $tel2, $correo, $geo, $desc, $cumple]);
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Directorio Corporativo</title>
    <link rel="stylesheet" href="style.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Leaflet CSS para el mapa -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"></script>
</head>
<body>
    <div class="overlay">
        <div class="container">
            <header>
                <h1>Directorio Corporativo</h1>
                <div class="nav-menu">
                    <a href="tutorial.php" class="btn btn-primary" style="background-color: #6f42c1;">📖 Tutorial</a>
                    <button class="btn btn-primary" onclick="$('#modal-contacto').fadeIn()">+ Nuevo Contacto</button>
                    <a href="export.php" class="btn btn-success">Exportar Excel</a>
                    <a href="logout.php" class="btn btn-danger">Cerrar Sesión</a>
                </div>
            </header>

            <table>
                <thead>
                    <tr>
                        <th>Nombre y Apellido</th>
                        <th>Empresa</th>
                        <th>Teléfono</th>
                        <th>Correo</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($contactos)): ?>
                        <tr><td colspan="5" style="text-align:center;">No hay contactos registrados.</td></tr>
                    <?php else: ?>
                        <?php foreach ($contactos as $c): ?>
                        <tr>
                            <td><strong><?php echo htmlspecialchars($c['nombre_apellido']); ?></strong></td>
                            <td><?php echo htmlspecialchars($c['empresa']); ?></td>
                            <td>
                                <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $c['telefono1']); ?>" target="_blank">
                                    <?php echo htmlspecialchars($c['telefono1']); ?>
                                </a>
                            </td>
                            <td>
                                <a href="mailto:<?php echo htmlspecialchars($c['correo']); ?>">
                                    <?php echo htmlspecialchars($c['correo']); ?>
                                </a>
                            </td>
                            <td>
                                <div style="display: flex; gap: 5px;">
                                    <button class="btn btn-primary" style="padding: 5px 10px; font-size: 12px; background-color: #17a2b8;" onclick='verDetalles(<?php echo json_encode($c); ?>)'>Ver</button>
                                    <a href="edit.php?id=<?php echo $c['id']; ?>" class="btn btn-primary" style="padding: 5px 10px; font-size: 12px;">Editar</a>
                                    <a href="delete.php?id=<?php echo $c['id']; ?>" class="btn btn-danger" style="padding: 5px 10px; font-size: 12px;" onclick="return confirm('¿Eliminar este contacto?')">Eliminar</a>
                                    <button class="btn btn-success" style="padding: 5px 10px; font-size: 12px;" onclick="verMapa('<?php echo $c['geoposicion']; ?>', '<?php echo htmlspecialchars($c['nombre_apellido']); ?>')">Mapa</button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal Detalles -->
    <div id="modal-detalles" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.7); z-index:150;">
        <div style="background:#fff; width:90%; max-width:500px; margin:50px auto; padding:30px; border-radius:8px; box-shadow: 0 5px 15px rgba(0,0,0,0.3);">
            <h3 style="color:#0056b3; border-bottom:2px solid #eee; padding-bottom:10px; margin-top:0;">Detalles del Contacto</h3>
            <div id="detalles-content" style="line-height: 1.6;">
                <!-- Se llena con JS -->
            </div>
            <div style="text-align:right; margin-top:20px;">
                <button class="btn btn-danger" onclick="$('#modal-detalles').fadeOut()">Cerrar</button>
            </div>
        </div>
    </div>

    <!-- Modal Mapa -->
    <div id="modal-mapa" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.8); z-index:200;">
        <div style="background:#fff; width:80%; max-width:800px; margin:50px auto; padding:20px; border-radius:8px; position:relative;">
            <h3 id="map-title">Ubicación del Contacto</h3>
            <div id="mapid" style="height: 400px; width: 100%; border-radius: 5px;"></div>
            <div style="text-align:right; margin-top:15px;">
                <button class="btn btn-danger" onclick="$('#modal-mapa').fadeOut()">Cerrar Mapa</button>
            </div>
        </div>
    </div>

    <!-- Modal Nuevo Contacto (Mismo de antes con mejoras) -->
    <div id="modal-contacto" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.6); z-index:100; overflow-y: auto;">
        <div style="background:#fff; width:90%; max-width:600px; margin:30px auto; padding:30px; border-radius:8px;">
            <h3 style="margin-top:0; color:#0056b3;">Agregar Nuevo Contacto</h3>
            <form method="POST">
                <input type="hidden" name="action" value="save">
                <div style="display:grid; grid-template-columns: 1fr 1fr; gap:15px;">
                    <div class="form-group">
                        <label>Nombre y Apellido *</label>
                        <input type="text" name="nombre_apellido" required>
                    </div>
                    <div class="form-group">
                        <label>Empresa</label>
                        <input type="text" name="empresa">
                    </div>
                </div>
                <div class="form-group">
                    <label>País</label>
                    <div class="country-selector" id="country-list"></div>
                    <input type="hidden" name="pais" id="selected-country">
                </div>
                <div style="display:grid; grid-template-columns: 1fr 1fr; gap:15px;">
                    <div class="form-group">
                        <label>Ciudad</label>
                        <input type="text" name="ciudad">
                    </div>
                    <div class="form-group">
                        <label>Fecha de Cumpleaños</label>
                        <input type="date" name="fecha_cumpleaños">
                    </div>
                </div>
                <div style="display:grid; grid-template-columns: 1fr 1fr; gap:15px;">
                    <div class="form-group">
                        <label>Teléfono 1</label>
                        <input type="text" name="telefono1" id="tel1">
                    </div>
                    <div class="form-group">
                        <label>Teléfono 2</label>
                        <input type="text" name="telefono2" id="tel2">
                    </div>
                </div>
                <div class="form-group">
                    <label>Correo Electrónico</label>
                    <input type="email" name="correo">
                </div>
                <div class="form-group">
                    <label>Descripción</label>
                    <textarea name="descripcion" rows="2"></textarea>
                </div>
                <div style="text-align:right; margin-top:20px;">
                    <button type="button" class="btn btn-danger" onclick="$('#modal-contacto').fadeOut()">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Popup Cumpleaños -->
    <div class="popup-overlay" id="pop-overlay"></div>
    <div id="birthday-popup">
        <div style="font-size: 50px;">🎂</div>
        <h2 style="color:#0056b3;">¡Felicitaciones!</h2>
        <p id="bday-names" style="font-weight:bold; font-size:20px; color:#28a745;"></p>
        <button class="btn btn-primary" onclick="closeBday()">Continuar</button>
    </div>

    <script>
        let mymap;
        const countries = [
            {name: "Argentina", code: "+54"}, {name: "Bolivia", code: "+591"},
            {name: "Brasil", code: "+55"}, {name: "Chile", code: "+56"},
            {name: "Colombia", code: "+57"}, {name: "Costa Rica", code: "+506"},
            {name: "Cuba", code: "+53"}, {name: "Ecuador", code: "+593"},
            {name: "El Salvador", code: "+503"}, {name: "España", code: "+34"},
            {name: "Guatemala", code: "+502"}, {name: "Honduras", code: "+504"},
            {name: "México", code: "+52"}, {name: "Nicaragua", code: "+505"},
            {name: "Panamá", code: "+507"}, {name: "Paraguay", code: "+595"},
            {name: "Perú", code: "+51"}, {name: "Puerto Rico", code: "+1"},
            {name: "República Dominicana", code: "+1"}, {name: "Uruguay", code: "+598"},
            {name: "Venezuela", code: "+58"}, {name: "Estados Unidos", code: "+1"}
        ];

        $(document).ready(function() {
            const list = $('#country-list');
            countries.forEach(c => {
                list.append(`<div class="country-option" data-code="${c.code}">${c.name} (${c.code})</div>`);
            });

            $(document).on('click', '.country-option', function() {
                $('.country-option').removeClass('selected');
                $(this).addClass('selected');
                const code = $(this).data('code');
                $('#selected-country').val($(this).text().split(' (')[0]);
                $('#tel1').val(code);
                $('#tel2').val(code);
            });

            const bdays = <?php echo json_encode($cumpleañeros); ?>;
            if (bdays.length > 0) {
                $('#bday-names').text(bdays.join(", "));
                $('#pop-overlay').fadeIn();
                $('#birthday-popup').fadeIn();
            }
        });

        function verDetalles(c) {
            let html = `
                <p><strong>Nombre:</strong> ${c.nombre_apellido}</p>
                <p><strong>Empresa:</strong> ${c.empresa || 'N/A'}</p>
                <p><strong>País:</strong> ${c.pais || 'N/A'}</p>
                <p><strong>Ciudad:</strong> ${c.ciudad || 'N/A'}</p>
                <p><strong>Teléfono 1:</strong> ${c.telefono1 || 'N/A'}</p>
                <p><strong>Teléfono 2:</strong> ${c.telefono2 || 'N/A'}</p>
                <p><strong>Correo:</strong> ${c.correo || 'N/A'}</p>
                <p><strong>Cumpleaños:</strong> ${c.fecha_cumpleaños || 'No registrado'}</p>
                <p><strong>Geoposición:</strong> ${c.geoposicion || 'N/A'}</p>
                <p><strong>Descripción:</strong><br>${c.descripcion || 'Sin descripción'}</p>
            `;
            $('#detalles-content').html(html);
            $('#modal-detalles').fadeIn();
        }

        function verMapa(geo, nombre) {
            if (!geo || geo.indexOf(',') === -1) {
                alert("Este contacto no tiene coordenadas de geoposición válidas.");
                return;
            }

            $('#modal-mapa').fadeIn();
            $('#map-title').text("Ubicación de: " + nombre);
            
            const coords = geo.split(',');
            const lat = parseFloat(coords[0]);
            const lng = parseFloat(coords[1]);

            // Pequeño retraso para asegurar que el contenedor sea visible antes de inicializar Leaflet
            setTimeout(() => {
                if (mymap) { mymap.remove(); }
                
                mymap = L.map('mapid').setView([lat, lng], 15);
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    maxZoom: 19,
                    attribution: '© OpenStreetMap'
                }).addTo(mymap);
                
                L.marker([lat, lng]).addTo(mymap)
                    .bindPopup("<b>" + nombre + "</b><br>Ubicación registrada.")
                    .openPopup();
                
                // Forzar el redibujado del mapa para evitar áreas grises
                mymap.invalidateSize();
            }, 400);
        }

        function closeBday() {
            $('#pop-overlay').fadeOut();
            $('#birthday-popup').fadeOut();
        }
    </script>
</body>
</html>
