<?php
session_start();
if (file_exists('db.php')) {
    require 'db.php';
} elseif (file_exists('../db.php')) {
    require '../db.php';
} else {
    die("Error: No se pudo encontrar el archivo de configuración de la base de datos (db.php).");
}

if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

$id = $_GET['id'] ?? null;
if (!$id) {
    header("Location: index.php");
    exit;
}

// Obtener datos del contacto
$stmt = $pdo->prepare("SELECT * FROM contactos WHERE id = ?");
$stmt->execute([$id]);
$contacto = $stmt->fetch();

if (!$contacto) {
    header("Location: index.php");
    exit;
}

// Procesar actualización
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nombre = $_POST['nombre_apellido'];
    $empresa = $_POST['empresa'];
    $pais = $_POST['pais'];
    $ciudad = $_POST['ciudad'];
    $tel1 = $_POST['telefono1'];
    $tel2 = $_POST['telefono2'];
    $correo = $_POST['correo'];
    $desc = $_POST['descripcion'];
    $cumple = $_POST['fecha_cumpleaños'] ?: null;

    $sql = "UPDATE contactos SET nombre_apellido=?, empresa=?, pais=?, ciudad=?, telefono1=?, telefono2=?, correo=?, descripcion=?, fecha_cumpleaños=? WHERE id=?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$nombre, $empresa, $pais, $ciudad, $tel1, $tel2, $correo, $desc, $cumple, $id]);
    
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Editar Contacto - Directorio Corporativo</title>
    <link rel="stylesheet" href="style.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <div class="overlay">
        <div class="container">
            <header>
                <h1>Editar Contacto</h1>
                <a href="index.php" class="btn btn-danger">Volver</a>
            </header>

            <form method="POST" style="max-width: 600px; margin: 0 auto; background: #f9f9f9; padding: 20px; border-radius: 8px;">
                <div style="display:grid; grid-template-columns: 1fr 1fr; gap:15px;">
                    <div class="form-group">
                        <label>Nombre y Apellido *</label>
                        <input type="text" name="nombre_apellido" value="<?php echo htmlspecialchars($contacto['nombre_apellido']); ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Empresa</label>
                        <input type="text" name="empresa" value="<?php echo htmlspecialchars($contacto['empresa']); ?>">
                    </div>
                </div>

                <div class="form-group">
                    <label>País</label>
                    <input type="text" name="pais" id="selected-country" value="<?php echo htmlspecialchars($contacto['pais']); ?>">
                </div>

                <div style="display:grid; grid-template-columns: 1fr 1fr; gap:15px;">
                    <div class="form-group">
                        <label>Ciudad</label>
                        <input type="text" name="ciudad" value="<?php echo htmlspecialchars($contacto['ciudad']); ?>">
                    </div>
                    <div class="form-group">
                        <label>Fecha de Cumpleaños</label>
                        <input type="date" name="fecha_cumpleaños" value="<?php echo $contacto['fecha_cumpleaños']; ?>">
                    </div>
                </div>

                <div style="display:grid; grid-template-columns: 1fr 1fr; gap:15px;">
                    <div class="form-group">
                        <label>Teléfono 1</label>
                        <input type="text" name="telefono1" value="<?php echo htmlspecialchars($contacto['telefono1']); ?>">
                    </div>
                    <div class="form-group">
                        <label>Teléfono 2</label>
                        <input type="text" name="telefono2" value="<?php echo htmlspecialchars($contacto['telefono2']); ?>">
                    </div>
                </div>

                <div class="form-group">
                    <label>Correo Electrónico</label>
                    <input type="email" name="correo" value="<?php echo htmlspecialchars($contacto['correo']); ?>">
                </div>

                <div class="form-group">
                    <label>Descripción Breve</label>
                    <textarea name="descripcion" rows="3"><?php echo htmlspecialchars($contacto['descripcion']); ?></textarea>
                </div>

                <div style="text-align:right; margin-top:20px;">
                    <button type="submit" class="btn btn-primary">Actualizar Cambios</button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
