<?php
require_once 'config.php';
require_once 'paises.php';
checkLogin();

$id = $_GET['id'] ?? null;
if (!$id) {
    header("Location: index.php");
    exit();
}

$stmt = $pdo->prepare("SELECT * FROM contactos WHERE id = ?");
$stmt->execute([$id]);
$contacto = $stmt->fetch();

if (!$contacto) {
    header("Location: index.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nombre = $_POST['nombre_apellido'];
    $empresa = $_POST['empresa'];
    $pais = $_POST['pais'];
    $ciudad = $_POST['ciudad'];
    $telefono1 = $_POST['telefono1'];
    $telefono2 = $_POST['telefono2'];
    $correo = $_POST['correo'];
    $descripcion = $_POST['descripcion'];
    $fecha_cumpleanos = $_POST['fecha_cumpleanos'] ?: null;
    $latitud = $_POST['latitud'] ?? $contacto['latitud'];
    $longitud = $_POST['longitud'] ?? $contacto['longitud'];

    $sql = "UPDATE contactos SET nombre_apellido=?, empresa=?, pais=?, ciudad=?, telefono1=?, telefono2=?, correo=?, descripcion=?, fecha_cumpleanos=?, latitud=?, longitud=? WHERE id=?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$nombre, $empresa, $pais, $ciudad, $telefono1, $telefono2, $correo, $descripcion, $fecha_cumpleanos, $latitud, $longitud, $id]);

    header("Location: index.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Editar Contacto - Directorio Corporativo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: #f4f7f6; }
        .form-container { background: white; padding: 2rem; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); margin-top: 2rem; }
        .header-corp { background: #003366; color: white; padding: 1rem; border-radius: 10px 10px 0 0; }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="form-container p-0">
                    <div class="header-corp">
                        <h4 class="mb-0">Editar Contacto</h4>
                    </div>
                    <form method="POST" class="p-4">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Nombre y Apellido *</label>
                                <input type="text" name="nombre_apellido" class="form-control" value="<?php echo htmlspecialchars($contacto['nombre_apellido']); ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Empresa</label>
                                <input type="text" name="empresa" class="form-control" value="<?php echo htmlspecialchars($contacto['empresa']); ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">País</label>
                                <select name="pais" id="pais" class="form-select" onchange="updatePhoneCode()">
                                    <option value="">Seleccione un país</option>
                                    <?php foreach ($paises as $p): ?>
                                        <option value="<?php echo $p['nombre']; ?>" data-code="<?php echo $p['codigo']; ?>" <?php echo ($contacto['pais'] == $p['nombre']) ? 'selected' : ''; ?>>
                                            <?php echo $p['nombre']; ?> (+<?php echo $p['codigo']; ?>)
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Ciudad</label>
                                <input type="text" name="ciudad" class="form-control" value="<?php echo htmlspecialchars($contacto['ciudad']); ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Teléfono 1</label>
                                <input type="text" name="telefono1" id="telefono1" class="form-control" value="<?php echo htmlspecialchars($contacto['telefono1']); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Teléfono 2</label>
                                <input type="text" name="telefono2" id="telefono2" class="form-control" value="<?php echo htmlspecialchars($contacto['telefono2']); ?>">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Correo Electrónico</label>
                            <input type="email" name="correo" class="form-control" value="<?php echo htmlspecialchars($contacto['correo']); ?>">
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Fecha de Cumpleaños</label>
                                <input type="date" name="fecha_cumpleanos" class="form-control" value="<?php echo $contacto['fecha_cumpleanos']; ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Descripción Breve</label>
                                <textarea name="descripcion" class="form-control" rows="1"><?php echo htmlspecialchars($contacto['descripcion']); ?></textarea>
                            </div>
                        </div>

                        <input type="hidden" name="latitud" id="latitud" value="<?php echo $contacto['latitud']; ?>">
                        <input type="hidden" name="longitud" id="longitud" value="<?php echo $contacto['longitud']; ?>">

                        <div class="text-end mt-3">
                            <small id="geo-status" class="text-muted d-block mb-2">Ubicación actual guardada.</small>
                            <button type="button" class="btn btn-sm btn-outline-info mb-2" onclick="refreshLocation()">Actualizar a mi ubicación actual</button>
                            <br>
                            <a href="index.php" class="btn btn-secondary">Cancelar</a>
                            <button type="submit" class="btn btn-primary">Actualizar Contacto</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function refreshLocation() {
            if ("geolocation" in navigator) {
                document.getElementById('geo-status').innerText = "Obteniendo ubicación precisa...";
                navigator.geolocation.getCurrentPosition(function(position) {
                    document.getElementById('latitud').value = position.coords.latitude;
                    document.getElementById('longitud').value = position.coords.longitude;
                    document.getElementById('geo-status').innerText = "Ubicación actualizada con éxito.";
                    document.getElementById('geo-status').classList.replace('text-muted', 'text-success');
                }, function(error) {
                    document.getElementById('geo-status').innerText = "Error al obtener ubicación.";
                    document.getElementById('geo-status').classList.replace('text-muted', 'text-danger');
                });
            }
        }

        function updatePhoneCode() {
            var select = document.getElementById('pais');
            var option = select.options[select.selectedIndex];
            var code = option.getAttribute('data-code');
            
            if (code) {
                var tel1 = document.getElementById('telefono1');
                var tel2 = document.getElementById('telefono2');
                
                // Solo actualizamos si el campo está vacío o solo tiene un código anterior
                if (!tel1.value || tel1.value.startsWith('+')) {
                    tel1.value = '+' + code + ' ';
                }
                if (!tel2.value || tel2.value.startsWith('+')) {
                    tel2.value = '+' + code + ' ';
                }
            }
        }
    </script>
</body>
</html>
