<?php
/**
 * Página Principal de Login
 * Sistema de Gestión de Agua Mineral
 */

require_once 'includes/init.php';

// Si ya está logueado, redirigir al dashboard correspondiente
if (isLoggedIn()) {
    if ($_SESSION['user_role'] === 'administrador') {
        redirect('modules/admin/dashboard.php');
    } else {
        redirect('modules/vendedor/dashboard.php');
    }
}

$error = '';
$success = '';

// Procesar formulario de login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = sanitize($_POST['usuario'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($usuario) || empty($password)) {
        $error = 'Por favor, complete todos los campos.';
    } else {
        $db = Database::getInstance();
        $query = "SELECT * FROM usuarios WHERE usuario = ? AND activo = 1";
        $result = $db->select($query, [$usuario]);
        
        if ($result && count($result) > 0) {
            $user = $result[0];
            
            if (verifyPassword($password, $user['password'])) {
                // Login exitoso
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_name'] = $user['nombre'];
                $_SESSION['user_role'] = $user['rol'];
                $_SESSION['user_zona'] = $user['zona_id'];
                $_SESSION['last_activity'] = time();
                
                // Log de actividad
                logActivity($user['id'], 'login', 'Inicio de sesión exitoso');
                
                // Redirigir según el rol
                if ($user['rol'] === 'administrador') {
                    redirect('modules/admin/dashboard.php');
                } else {
                    redirect('modules/vendedor/dashboard.php');
                }
            } else {
                $error = 'Contraseña incorrecta.';
            }
        } else {
            $error = 'Usuario no encontrado o inactivo.';
        }
    }
}

// Manejar mensajes de error de la URL
if (isset($_GET['error'])) {
    switch ($_GET['error']) {
        case 'session_expired':
            $error = 'Su sesión ha expirado. Por favor, inicie sesión nuevamente.';
            break;
        case 'no_permission':
            $error = 'No tiene permisos para acceder a esa sección.';
            break;
        case 'logout':
            $success = 'Ha cerrado sesión correctamente.';
            break;
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= APP_NAME ?> - Iniciar Sesión</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body class="bg-primary">
    <div class="container">
        <div class="row justify-content-center align-items-center min-vh-100">
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-lg">
                    <div class="card-body p-5">
                        <div class="text-center mb-4">
                            <img src="assets/images/logo.png" alt="Logo" class="mb-3" style="max-height: 80px;" onerror="this.style.display='none'">
                            <h3 class="card-title text-primary"><?= APP_NAME ?></h3>
                            <p class="text-muted">Iniciar Sesión</p>
                        </div>
                        
                        <?php if ($error): ?>
                            <?= showAlert($error, 'error') ?>
                        <?php endif; ?>
                        
                        <?php if ($success): ?>
                            <?= showAlert($success, 'success') ?>
                        <?php endif; ?>
                        
                        <form method="POST" action="">
                            <div class="mb-3">
                                <label for="usuario" class="form-label">
                                    <i class="fas fa-user me-2"></i>Usuario
                                </label>
                                <input type="text" 
                                       class="form-control" 
                                       id="usuario" 
                                       name="usuario" 
                                       value="<?= htmlspecialchars($usuario ?? '') ?>"
                                       required 
                                       autofocus>
                            </div>
                            
                            <div class="mb-4">
                                <label for="password" class="form-label">
                                    <i class="fas fa-lock me-2"></i>Contraseña
                                </label>
                                <input type="password" 
                                       class="form-control" 
                                       id="password" 
                                       name="password" 
                                       required>
                            </div>
                            
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="fas fa-sign-in-alt me-2"></i>Iniciar Sesión
                                </button>
                            </div>
                        </form>
                        
                        <div class="text-center mt-4">
                            <small class="text-muted">
                                <?= APP_NAME ?> v<?= APP_VERSION ?>
                            </small>
                        </div>
                    </div>
                </div>
                
                <!-- Información de acceso por defecto (solo para desarrollo) -->
                <?php if (DEBUG_MODE): ?>
                <div class="card mt-3">
                    <div class="card-body">
                        <h6 class="card-title">Accesos de Prueba:</h6>
                        <small class="text-muted">
                            <strong>Administrador:</strong> agua / miner@l<br>
                            <strong>Vendedor:</strong> vendedor1 / vendedor123
                        </small>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
