# Sistema de Gestión de Agua Mineral

Un sistema web completo desarrollado en PHP para la administración de ventas de agua mineral, con módulos diferenciados para vendedores y administradores.

## 🚀 Características Principales

### Módulo Administrador
- **Dashboard completo** con estadísticas y gráficos
- **Gestión de clientes** con información detallada y saldos
- **Gestión de vendedores** y asignación de zonas
- **Control de ventas** con historial completo
- **Reportes avanzados** con exportación a Excel y PDF
- **Configuración del sistema** (precios, usuarios, zonas)
- **Ubicación GPS** de clientes con Google Maps

### Módulo Vendedor
- **Dashboard personalizado** con resumen de actividad
- **Lista de clientes** asignados con información de saldos
- **Registro de ventas** con cálculo automático de totales
- **Mapa interactivo** con ubicación GPS de clientes
- **Historial de entregas** por cliente

### Funcionalidades Generales
- **Sistema de autenticación** seguro con roles
- **Interfaz responsive** compatible con dispositivos móviles
- **Integración con Google Maps** para ubicación de clientes
- **Exportación de reportes** en Excel y PDF
- **Logs de actividad** para auditoría
- **Diseño moderno** con Bootstrap 5

## 📋 Requisitos del Sistema

### Servidor Web
- **PHP 7.4 o superior**
- **MySQL 5.7 o superior** / MariaDB 10.2+
- **Apache** con mod_rewrite habilitado
- **Extensiones PHP requeridas:**
  - mysqli o pdo_mysql
  - json
  - session
  - gd
  - curl
  - openssl

### Hosting Compatible
- **cPanel** (configuración incluida)
- **Hosting compartido** estándar
- **VPS/Servidor dedicado**

## 🛠️ Instalación

### Instalación Automática

1. **Subir archivos** al servidor web
2. **Acceder a** `install.php` desde el navegador
3. **Seguir el asistente** de instalación
4. **Configurar la base de datos** con los siguientes datos:
   - Base de datos: `aguadb`
   - Usuario: `mineral`
   - Contraseña: `@gu@miner@l`

### Instalación Manual

#### 1. Configurar Base de Datos

```sql
-- Crear base de datos
CREATE DATABASE aguadb CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Crear usuario
CREATE USER 'mineral'@'localhost' IDENTIFIED BY '@gu@miner@l';
GRANT ALL PRIVILEGES ON aguadb.* TO 'mineral'@'localhost';
FLUSH PRIVILEGES;
```

#### 2. Importar Estructura

```bash
mysql -u mineral -p aguadb < sql/create_database.sql
```

#### 3. Configurar Archivos

Editar `config/database.php` con los datos de conexión:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'aguadb');
define('DB_USER', 'mineral');
define('DB_PASS', '@gu@miner@l');
```

#### 4. Configurar Google Maps (Opcional)

Obtener API Key de Google Maps y configurar en `config/database.php`:

```php
define('GOOGLE_MAPS_API_KEY', 'TU_API_KEY_AQUI');
```

#### 5. Configurar Permisos

```bash
chmod 755 assets/ uploads/ logs/
chmod 644 *.php
```

## 🔐 Credenciales por Defecto

### Administrador
- **Usuario:** `agua`
- **Contraseña:** `miner@l`

### Vendedor de Prueba
- **Usuario:** `vendedor1`
- **Contraseña:** `123456`

> ⚠️ **Importante:** Cambiar estas contraseñas después de la instalación

## 📁 Estructura del Proyecto

```
agua-mineral-system/
├── assets/                 # Archivos estáticos (CSS, JS, imágenes)
│   ├── css/
│   ├── js/
│   └── images/
├── config/                 # Archivos de configuración
├── includes/               # Clases y funciones PHP
├── modules/                # Módulos del sistema
│   ├── admin/             # Módulo administrador
│   └── vendedor/          # Módulo vendedor
├── sql/                   # Scripts de base de datos
├── uploads/               # Archivos subidos (crear si no existe)
├── logs/                  # Logs del sistema (crear si no existe)
├── .htaccess             # Configuración Apache
├── index.php             # Página de login
├── install.php           # Instalador automático
└── README.md             # Este archivo
```

## 🔧 Configuración para cPanel

### 1. Subir Archivos
- Descomprimir en `public_html/` o subdirectorio deseado
- Asegurar que `index.php` esté en la raíz del dominio/subdirectorio

### 2. Crear Base de Datos
- Ir a **MySQL Databases** en cPanel
- Crear base de datos: `aguadb`
- Crear usuario: `mineral` con contraseña `@gu@miner@l`
- Asignar usuario a la base de datos con todos los privilegios

### 3. Importar SQL
- Ir a **phpMyAdmin** en cPanel
- Seleccionar la base de datos `aguadb`
- Importar el archivo `sql/create_database.sql`

### 4. Configurar SSL (Recomendado)
- Activar **Let's Encrypt SSL** en cPanel
- Descomentar líneas HTTPS en `.htaccess` si es necesario

## 🧪 Verificación de la Instalación

Acceder a `test-system.php` para verificar que todos los componentes estén funcionando correctamente.

## 📊 Uso del Sistema

### Para Administradores

1. **Configuración inicial:**
   - Cambiar contraseña por defecto
   - Configurar precios de bidones
   - Crear zonas de trabajo
   - Registrar vendedores

2. **Gestión de clientes:**
   - Agregar nuevos clientes
   - Asignar vendedores
   - Configurar ubicación GPS
   - Gestionar saldos

3. **Reportes:**
   - Generar reportes de ventas
   - Exportar a Excel/PDF
   - Analizar rendimiento por vendedor

### Para Vendedores

1. **Gestión diaria:**
   - Revisar lista de clientes
   - Registrar nuevas ventas
   - Consultar saldos pendientes

2. **Navegación:**
   - Usar mapa para planificar rutas
   - Localizar clientes por GPS
   - Optimizar recorridos

## 🔒 Seguridad

### Medidas Implementadas
- **Autenticación segura** con hash de contraseñas
- **Validación de entrada** en todos los formularios
- **Protección CSRF** en formularios críticos
- **Sanitización de datos** antes de mostrar
- **Logs de actividad** para auditoría
- **Configuración segura** de sesiones PHP

### Recomendaciones Adicionales
- Usar **HTTPS** en producción
- **Backups regulares** de la base de datos
- **Actualizar contraseñas** periódicamente
- **Monitorear logs** de errores y actividad
- **Limitar acceso** a archivos de configuración

## 🚀 Optimización

### Rendimiento
- **Cache de consultas** habilitado
- **Compresión GZIP** configurada
- **Optimización de imágenes** automática
- **Minificación** de CSS/JS en producción

### Base de Datos
- **Índices optimizados** en tablas principales
- **Consultas preparadas** para prevenir SQL injection
- **Paginación** en listados grandes

## 🐛 Solución de Problemas

### Problemas Comunes

#### Error de Conexión a Base de Datos
```
Verificar:
- Credenciales en config/database.php
- Que la base de datos existe
- Permisos del usuario de BD
```

#### Error 500 - Internal Server Error
```
Verificar:
- Permisos de archivos (644 para PHP, 755 para directorios)
- Logs de error de Apache
- Configuración de .htaccess
```

#### Google Maps no funciona
```
Verificar:
- API Key configurada correctamente
- API habilitada en Google Cloud Console
- Dominios autorizados en la API Key
```

### Logs del Sistema
- **Errores PHP:** `logs/php_errors.log`
- **Actividad del sistema:** Tabla `actividad_log` en BD
- **Errores Apache:** Logs del servidor web

## 📞 Soporte

### Documentación Técnica
- Código comentado en español
- Estructura modular y escalable
- Estándares PSR-4 para autoloading

### Mantenimiento
- **Backups automáticos** recomendados
- **Actualizaciones de seguridad** regulares
- **Monitoreo de rendimiento** continuo

## 📄 Licencia

Este sistema ha sido desarrollado específicamente para la gestión de ventas de agua mineral. Todos los derechos reservados.

## 🔄 Historial de Versiones

### v1.0.0 (Actual)
- Sistema completo de gestión
- Módulos administrador y vendedor
- Integración con Google Maps
- Reportes y exportación
- Diseño responsive

---

**Desarrollado con ❤️ para la gestión eficiente de ventas de agua mineral**
