<?php
/**
 * Script de instalación del sistema
 * Crea la base de datos y las tablas necesarias
 */

echo "=== Instalación del Sistema de Reservas para Posadas ===\n\n";

// Configuración de la base de datos
$host = 'localhost';
$dbname = 'posadabd';
$username = 'posadaspgy';
$password = 'pos@da@2025';

try {
    // Conectar sin especificar base de datos para crearla
    $pdo = new PDO("mysql:unix_socket=/var/run/mysqld/mysqld.sock;charset=utf8mb4", 'root', '', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    
    echo "✓ Conexión a MySQL exitosa\n";
    
    // Crear usuario si no existe
    echo "→ Creando usuario de base de datos...\n";
    try {
        $pdo->exec("CREATE USER IF NOT EXISTS '$username'@'localhost' IDENTIFIED BY '$password'");
        echo "✓ Usuario creado/verificado\n";
    } catch (PDOException $e) {
        echo "⚠ Usuario ya existe o error: " . $e->getMessage() . "\n";
    }
    
    // Crear base de datos
    echo "→ Creando base de datos...\n";
    $pdo->exec("CREATE DATABASE IF NOT EXISTS $dbname CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "✓ Base de datos creada/verificada\n";
    
    // Otorgar permisos
    $pdo->exec("GRANT ALL PRIVILEGES ON $dbname.* TO '$username'@'localhost'");
    $pdo->exec("FLUSH PRIVILEGES");
    echo "✓ Permisos otorgados\n";
    
    // Conectar a la base de datos específica
    $pdo = new PDO("mysql:unix_socket=/var/run/mysqld/mysqld.sock;dbname=$dbname;charset=utf8mb4", 'root', '', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    
    echo "\n→ Creando tablas...\n";
    
    // Leer y ejecutar el archivo SQL
    $sql = file_get_contents(__DIR__ . '/database.sql');
    
    // Dividir por punto y coma y ejecutar cada sentencia
    $statements = array_filter(array_map('trim', explode(';', $sql)));
    
    foreach ($statements as $statement) {
        if (!empty($statement) && !preg_match('/^--/', $statement)) {
            try {
                $pdo->exec($statement);
            } catch (PDOException $e) {
                // Ignorar errores de tablas que ya existen
                if (strpos($e->getMessage(), 'already exists') === false) {
                    echo "⚠ Error en sentencia: " . $e->getMessage() . "\n";
                }
            }
        }
    }
    
    echo "✓ Tablas creadas exitosamente\n";
    
    // Crear hash de contraseña para el administrador
    $adminPassword = password_hash('Pgy.2025', PASSWORD_DEFAULT);
    
    // Verificar si el admin ya existe
    $stmt = $pdo->query("SELECT COUNT(*) FROM usuarios WHERE rol = 'admin'");
    $adminCount = $stmt->fetchColumn();
    
    if ($adminCount == 0) {
        echo "\n→ Creando usuario administrador...\n";
        $stmt = $pdo->prepare("INSERT INTO usuarios (cedula_pasaporte, nombre_completo, telefono, password, rol, habilitado) VALUES (?, ?, ?, ?, 'admin', 1)");
        $stmt->execute(['ADMIN001', 'Administrador Principal', '0981000000', $adminPassword]);
        echo "✓ Usuario administrador creado\n";
        echo "  Usuario: Posada\n";
        echo "  Contraseña: Pgy.2025\n";
    } else {
        echo "✓ Usuario administrador ya existe\n";
    }
    
    echo "\n=== Instalación completada exitosamente ===\n";
    echo "\nPuedes acceder al sistema en: http://localhost/posadas-php/\n";
    echo "Usuario admin: Posada\n";
    echo "Contraseña: Pgy.2025\n";
    
} catch (PDOException $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    exit(1);
}
?>
