<?php
require_once 'includes/config.php';

// Obtener tarifas activas
$db = getDBConnection();
$stmt = $db->query("SELECT * FROM tarifas WHERE activa = 1 ORDER BY precio_por_noche ASC");
$tarifas = $stmt->fetchAll();

// Obtener imágenes de la galería
$stmt = $db->query("SELECT * FROM galeria WHERE activa = 1 ORDER BY orden ASC LIMIT 6");
$galeria = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-content">
            <div class="logo-container">
                <img src="assets/images/logo.png" alt="Logo Posada" class="logo">
                <h1 class="site-title">Sistema de Reservas - Posada</h1>
            </div>
            <nav>
                <ul class="nav-menu">
                    <li><a href="index.php">Inicio</a></li>
                    <li><a href="#tarifas">Tarifas</a></li>
                    <li><a href="#galeria">Galería</a></li>
                    <li><a href="huesped/registro.php">Registrarse</a></li>
                    <li><a href="admin/login.php">Administración</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <h1>Bienvenido a Nuestra Posada</h1>
            <p>Un refugio natural en el corazón del campo</p>
            <div class="d-flex justify-between align-center gap-2" style="justify-content: center; margin-top: 30px;">
                <a href="huesped/registro.php" class="btn btn-primary btn-lg">Hacer una Reserva</a>
                <a href="#galeria" class="btn btn-outline btn-lg">Ver Galería</a>
            </div>
        </div>
    </section>

    <!-- Tarifas Section -->
    <section id="tarifas" class="container mt-3">
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">Nuestras Tarifas</h2>
            </div>
            <div class="card-body">
                <div class="grid grid-3">
                    <?php foreach ($tarifas as $tarifa): ?>
                        <div class="card">
                            <div class="card-header">
                                <h3 style="color: var(--color-primary); margin: 0;"><?php echo htmlspecialchars($tarifa['nombre']); ?></h3>
                            </div>
                            <div class="card-body">
                                <p><?php echo htmlspecialchars($tarifa['descripcion']); ?></p>
                                <div style="margin-top: 20px;">
                                    <div style="font-size: 2rem; font-weight: bold; color: var(--color-primary);">
                                        <?php echo formatMoney($tarifa['precio_por_noche']); ?>
                                    </div>
                                    <div style="color: var(--color-text-light); font-size: 0.9rem;">
                                        por noche
                                    </div>
                                    <?php if ($tarifa['precio_por_persona'] > 0): ?>
                                        <div style="margin-top: 10px; color: var(--color-text-light);">
                                            + <?php echo formatMoney($tarifa['precio_por_persona']); ?> por persona adicional
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <a href="huesped/registro.php" class="btn btn-primary btn-block mt-2">Reservar Ahora</a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Galería Section -->
    <section id="galeria" class="container mt-3">
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">Galería de Imágenes</h2>
            </div>
            <div class="card-body">
                <div class="gallery">
                    <?php if (!empty($galeria)): ?>
                        <?php foreach ($galeria as $imagen): ?>
                            <div class="gallery-item">
                                <img src="<?php echo htmlspecialchars($imagen['ruta_archivo']); ?>" 
                                     alt="<?php echo htmlspecialchars($imagen['titulo']); ?>">
                                <div class="gallery-item-overlay">
                                    <h4><?php echo htmlspecialchars($imagen['titulo']); ?></h4>
                                    <?php if ($imagen['descripcion']): ?>
                                        <p><?php echo htmlspecialchars($imagen['descripcion']); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <!-- Mostrar imágenes por defecto si no hay en la base de datos -->
                        <div class="gallery-item">
                            <img src="assets/images/exterior-1.jpg" alt="Exterior de la Posada">
                            <div class="gallery-item-overlay">
                                <h4>Vista Exterior</h4>
                                <p>Nuestra acogedora posada rodeada de naturaleza</p>
                            </div>
                        </div>
                        <div class="gallery-item">
                            <img src="assets/images/habitacion-1.jpg" alt="Habitación">
                            <div class="gallery-item-overlay">
                                <h4>Habitaciones Confortables</h4>
                                <p>Espacios cálidos y acogedores para su descanso</p>
                            </div>
                        </div>
                        <div class="gallery-item">
                            <img src="assets/images/comedor-1.jpg" alt="Comedor">
                            <div class="gallery-item-overlay">
                                <h4>Área de Comedor</h4>
                                <p>Disfrute de deliciosas comidas en un ambiente natural</p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Información Section -->
    <section class="container mt-3 mb-3">
        <div class="grid grid-2">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">¿Por qué elegirnos?</h3>
                </div>
                <div class="card-body">
                    <ul style="list-style: none; padding: 0;">
                        <li style="padding: 10px 0; border-bottom: 1px solid var(--color-border);">
                            ✓ Ubicación privilegiada en plena naturaleza
                        </li>
                        <li style="padding: 10px 0; border-bottom: 1px solid var(--color-border);">
                            ✓ Habitaciones cómodas y equipadas
                        </li>
                        <li style="padding: 10px 0; border-bottom: 1px solid var(--color-border);">
                            ✓ Atención personalizada
                        </li>
                        <li style="padding: 10px 0; border-bottom: 1px solid var(--color-border);">
                            ✓ Ambiente tranquilo y relajante
                        </li>
                        <li style="padding: 10px 0;">
                            ✓ Tarifas accesibles
                        </li>
                    </ul>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Servicios Disponibles</h3>
                </div>
                <div class="card-body">
                    <ul style="list-style: none; padding: 0;">
                        <li style="padding: 10px 0; border-bottom: 1px solid var(--color-border);">
                            ✓ Desayuno incluido
                        </li>
                        <li style="padding: 10px 0; border-bottom: 1px solid var(--color-border);">
                            ✓ Servicio de comidas
                        </li>
                        <li style="padding: 10px 0; border-bottom: 1px solid var(--color-border);">
                            ✓ Área de recreación
                        </li>
                        <li style="padding: 10px 0; border-bottom: 1px solid var(--color-border);">
                            ✓ Estacionamiento gratuito
                        </li>
                        <li style="padding: 10px 0;">
                            ✓ Tours y actividades
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Sistema de Reservas para Posadas. Todos los derechos reservados.</p>
            <p>Desarrollado con ❤️ para brindar la mejor experiencia de hospedaje</p>
        </div>
    </footer>

    <script src="assets/js/main.js"></script>
</body>
</html>
