-- Base de datos para Sistema de Reservas de Posadas
-- Nombre: posadabd
-- Usuario: posadaspgy
-- Contraseña: pos@da@2025

CREATE DATABASE IF NOT EXISTS posadabd CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE posadabd;

-- Tabla de usuarios (administradores y huéspedes)
CREATE TABLE IF NOT EXISTS usuarios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    cedula_pasaporte VARCHAR(50) UNIQUE NOT NULL,
    nombre_completo VARCHAR(200) NOT NULL,
    telefono VARCHAR(50),
    email VARCHAR(100),
    password VARCHAR(255),
    rol ENUM('admin', 'huesped') NOT NULL DEFAULT 'huesped',
    habilitado TINYINT(1) DEFAULT 1,
    fecha_registro DATETIME DEFAULT CURRENT_TIMESTAMP,
    ultima_actualizacion DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_cedula (cedula_pasaporte),
    INDEX idx_rol (rol)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de tarifas
CREATE TABLE IF NOT EXISTS tarifas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre VARCHAR(100) NOT NULL,
    descripcion TEXT,
    precio_por_noche DECIMAL(10,2) NOT NULL,
    precio_por_persona DECIMAL(10,2) DEFAULT 0,
    activa TINYINT(1) DEFAULT 1,
    fecha_creacion DATETIME DEFAULT CURRENT_TIMESTAMP,
    fecha_actualizacion DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de reservas
CREATE TABLE IF NOT EXISTS reservas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    usuario_id INT NOT NULL,
    fecha_entrada DATE NOT NULL,
    fecha_salida DATE NOT NULL,
    cantidad_personas INT NOT NULL DEFAULT 1,
    cantidad_dias INT NOT NULL,
    tarifa_id INT NOT NULL,
    costo_hospedaje DECIMAL(10,2) NOT NULL,
    comentarios TEXT,
    estado ENUM('pendiente', 'confirmada', 'en_curso', 'finalizada', 'cancelada') DEFAULT 'pendiente',
    fecha_reserva DATETIME DEFAULT CURRENT_TIMESTAMP,
    fecha_actualizacion DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE,
    FOREIGN KEY (tarifa_id) REFERENCES tarifas(id),
    INDEX idx_fechas (fecha_entrada, fecha_salida),
    INDEX idx_usuario (usuario_id),
    INDEX idx_estado (estado)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de categorías de productos
CREATE TABLE IF NOT EXISTS categorias_productos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre VARCHAR(100) NOT NULL,
    descripcion TEXT,
    activa TINYINT(1) DEFAULT 1,
    fecha_creacion DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de productos
CREATE TABLE IF NOT EXISTS productos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    categoria_id INT NOT NULL,
    nombre VARCHAR(200) NOT NULL,
    descripcion TEXT,
    precio DECIMAL(10,2) NOT NULL,
    disponible TINYINT(1) DEFAULT 1,
    fecha_creacion DATETIME DEFAULT CURRENT_TIMESTAMP,
    fecha_actualizacion DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (categoria_id) REFERENCES categorias_productos(id) ON DELETE CASCADE,
    INDEX idx_categoria (categoria_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de consumos (gastos de huéspedes)
CREATE TABLE IF NOT EXISTS consumos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    reserva_id INT NOT NULL,
    producto_id INT NOT NULL,
    cantidad INT NOT NULL DEFAULT 1,
    precio_unitario DECIMAL(10,2) NOT NULL,
    subtotal DECIMAL(10,2) NOT NULL,
    fecha_consumo DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (reserva_id) REFERENCES reservas(id) ON DELETE CASCADE,
    FOREIGN KEY (producto_id) REFERENCES productos(id),
    INDEX idx_reserva (reserva_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de promociones
CREATE TABLE IF NOT EXISTS promociones (
    id INT AUTO_INCREMENT PRIMARY KEY,
    titulo VARCHAR(200) NOT NULL,
    descripcion TEXT,
    descuento_porcentaje DECIMAL(5,2) DEFAULT 0,
    descuento_monto DECIMAL(10,2) DEFAULT 0,
    fecha_inicio DATE NOT NULL,
    fecha_fin DATE NOT NULL,
    activa TINYINT(1) DEFAULT 1,
    fecha_creacion DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de galería de imágenes
CREATE TABLE IF NOT EXISTS galeria (
    id INT AUTO_INCREMENT PRIMARY KEY,
    titulo VARCHAR(200),
    descripcion TEXT,
    nombre_archivo VARCHAR(255) NOT NULL,
    ruta_archivo VARCHAR(500) NOT NULL,
    orden INT DEFAULT 0,
    activa TINYINT(1) DEFAULT 1,
    fecha_subida DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_orden (orden)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla de pedidos especiales
CREATE TABLE IF NOT EXISTS pedidos_especiales (
    id INT AUTO_INCREMENT PRIMARY KEY,
    reserva_id INT NOT NULL,
    descripcion TEXT NOT NULL,
    estado ENUM('pendiente', 'en_proceso', 'completado', 'rechazado') DEFAULT 'pendiente',
    fecha_pedido DATETIME DEFAULT CURRENT_TIMESTAMP,
    fecha_actualizacion DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (reserva_id) REFERENCES reservas(id) ON DELETE CASCADE,
    INDEX idx_reserva (reserva_id),
    INDEX idx_estado (estado)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insertar usuario administrador por defecto
INSERT INTO usuarios (cedula_pasaporte, nombre_completo, telefono, password, rol, habilitado) 
VALUES ('ADMIN001', 'Administrador Principal', '0981000000', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 1);
-- Contraseña por defecto: Pgy.2025

-- Insertar tarifas por defecto
INSERT INTO tarifas (nombre, descripcion, precio_por_noche, precio_por_persona, activa) VALUES
('Tarifa Estándar', 'Tarifa regular para habitación doble', 250000, 50000, 1),
('Tarifa Fin de Semana', 'Tarifa especial para viernes a domingo', 300000, 60000, 1),
('Tarifa Familiar', 'Tarifa para grupos familiares (4+ personas)', 450000, 40000, 1);

-- Insertar categorías de productos por defecto
INSERT INTO categorias_productos (nombre, descripcion, activa) VALUES
('Bebidas', 'Bebidas frías y calientes', 1),
('Comidas', 'Desayunos, almuerzos y cenas', 1),
('Snacks', 'Aperitivos y golosinas', 1),
('Servicios Adicionales', 'Servicios extra como lavandería, tours, etc.', 1);

-- Insertar productos por defecto
INSERT INTO productos (categoria_id, nombre, descripcion, precio, disponible) VALUES
(1, 'Agua Mineral', 'Botella de agua 500ml', 5000, 1),
(1, 'Refresco', 'Lata de refresco 350ml', 8000, 1),
(1, 'Café', 'Café caliente', 10000, 1),
(1, 'Jugo Natural', 'Jugo de frutas naturales', 15000, 1),
(2, 'Desayuno Completo', 'Desayuno continental', 35000, 1),
(2, 'Almuerzo', 'Almuerzo del día', 45000, 1),
(2, 'Cena', 'Cena especial', 50000, 1),
(3, 'Galletas', 'Paquete de galletas', 6000, 1),
(3, 'Chips', 'Bolsa de papas fritas', 7000, 1),
(4, 'Lavandería', 'Servicio de lavandería por pieza', 8000, 1),
(4, 'Tour Local', 'Tour guiado por la zona', 80000, 1);
