<?php
require_once '../includes/config.php';
if (!isLoggedIn() || !isAdmin()) redirect('login.php');
$db = getDBConnection();
$mes = $_GET['mes'] ?? date('Y-m');
list($anio, $mes_num) = explode('-', $mes);
$stmt = $db->prepare("
    SELECT r.*, u.nombre_completo, u.cedula_pasaporte
    FROM reservas r
    JOIN usuarios u ON r.usuario_id = u.id
    WHERE YEAR(r.fecha_reserva) = ? AND MONTH(r.fecha_reserva) = ?
    ORDER BY r.fecha_reserva DESC
");
$stmt->execute([$anio, $mes_num]);
$reservas = $stmt->fetchAll();
$total_ingresos = array_sum(array_column($reservas, 'costo_hospedaje'));
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reportes - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-container">
                <img src="../assets/images/logo.png" alt="Logo" class="logo">
                <h1 class="site-title">Reportes</h1>
            </div>
            <nav>
                <ul class="nav-menu">
                    <li><a href="dashboard.php">← Dashboard</a></li>
                    <li><a href="logout.php">Cerrar Sesión</a></li>
                </ul>
            </nav>
        </div>
    </header>
    <div class="container mt-3">
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">📈 Reporte Mensual</h2>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label class="form-label">Seleccione Mes:</label>
                    <input type="month" value="<?php echo $mes; ?>" onchange="window.location.href='?mes='+this.value" class="form-control" style="width: auto;">
                </div>
                <div style="background: var(--color-primary); color: white; padding: 20px; border-radius: var(--radius); text-align: center; margin: 20px 0;">
                    <h3>Total Ingresos: <?php echo formatMoney($total_ingresos); ?></h3>
                    <p>Cantidad de Reservas: <?php echo count($reservas); ?></p>
                </div>
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Huésped</th>
                            <th>Entrada</th>
                            <th>Salida</th>
                            <th>Días</th>
                            <th>Personas</th>
                            <th>Costo</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($reservas as $r): ?>
                            <tr>
                                <td>#<?php echo str_pad($r['id'], 6, '0', STR_PAD_LEFT); ?></td>
                                <td><?php echo htmlspecialchars($r['nombre_completo']); ?></td>
                                <td><?php echo formatDate($r['fecha_entrada']); ?></td>
                                <td><?php echo formatDate($r['fecha_salida']); ?></td>
                                <td><?php echo $r['cantidad_dias']; ?></td>
                                <td><?php echo $r['cantidad_personas']; ?></td>
                                <td><?php echo formatMoney($r['costo_hospedaje']); ?></td>
                                <td><?php echo strtoupper($r['estado']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <div style="text-align: center; margin-top: 20px;">
                    <button onclick="window.print()" class="btn btn-primary">📄 Imprimir Reporte</button>
                </div>
            </div>
        </div>
    </div>
    <footer class="footer"><div class="container"><p>&copy; <?php echo date('Y'); ?> Sistema de Reservas para Posadas.</p></div></footer>
    <script src="../assets/js/main.js"></script>
</body>
</html>
