<?php
require_once '../includes/config.php';
if (!isLoggedIn() || !isAdmin()) redirect('login.php');
$db = getDBConnection();
$mensaje = '';
if (isset($_POST['cambiar_estado'])) {
    $usuario_id = (int)$_POST['usuario_id'];
    $habilitado = (int)$_POST['habilitado'];
    $stmt = $db->prepare("UPDATE usuarios SET habilitado = ? WHERE id = ?");
    $stmt->execute([$habilitado, $usuario_id]);
    $mensaje = 'Estado actualizado';
}
$stmt = $db->query("SELECT * FROM usuarios WHERE rol = 'huesped' ORDER BY nombre_completo");
$huespedes = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Huéspedes - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-container">
                <img src="../assets/images/logo.png" alt="Logo" class="logo">
                <h1 class="site-title">Gestión de Huéspedes</h1>
            </div>
            <nav>
                <ul class="nav-menu">
                    <li><a href="dashboard.php">← Dashboard</a></li>
                    <li><a href="logout.php">Cerrar Sesión</a></li>
                </ul>
            </nav>
        </div>
    </header>
    <div class="container mt-3">
        <?php if ($mensaje): ?><div class="alert alert-success"><?php echo $mensaje; ?></div><?php endif; ?>
        <div class="card">
            <div class="card-header"><h2 class="card-title">👥 Lista de Huéspedes</h2></div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Nombre</th>
                            <th>CI/Pasaporte</th>
                            <th>Teléfono</th>
                            <th>Email</th>
                            <th>Fecha Registro</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($huespedes as $h): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($h['nombre_completo']); ?></td>
                                <td><?php echo htmlspecialchars($h['cedula_pasaporte']); ?></td>
                                <td><?php echo htmlspecialchars($h['telefono']); ?></td>
                                <td><?php echo htmlspecialchars($h['email'] ?? '-'); ?></td>
                                <td><?php echo formatDate($h['fecha_registro']); ?></td>
                                <td>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="usuario_id" value="<?php echo $h['id']; ?>">
                                        <select name="habilitado" class="form-control" style="width: auto; font-size: 0.85rem;" onchange="this.form.submit()">
                                            <option value="1" <?php echo $h['habilitado'] ? 'selected' : ''; ?>>Habilitado</option>
                                            <option value="0" <?php echo !$h['habilitado'] ? 'selected' : ''; ?>>Deshabilitado</option>
                                        </select>
                                        <button type="submit" name="cambiar_estado" style="display: none;"></button>
                                    </form>
                                </td>
                                <td>
                                    <a href="reservas.php?huesped_id=<?php echo $h['id']; ?>" class="btn btn-sm btn-info">Ver Reservas</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <footer class="footer"><div class="container"><p>&copy; <?php echo date('Y'); ?> Sistema de Reservas para Posadas.</p></div></footer>
    <script src="../assets/js/main.js"></script>
</body>
</html>
