<?php
require_once '../includes/config.php';

// Verificar que sea administrador
if (!isLoggedIn() || !isAdmin()) {
    redirect('login.php');
}

$db = getDBConnection();

// Obtener estadísticas
$stmt = $db->query("SELECT COUNT(*) as total FROM reservas WHERE estado = 'pendiente'");
$reservas_pendientes = $stmt->fetch()['total'];

$stmt = $db->query("SELECT COUNT(*) as total FROM reservas WHERE estado = 'confirmada'");
$reservas_confirmadas = $stmt->fetch()['total'];

$stmt = $db->query("SELECT COUNT(*) as total FROM reservas WHERE estado = 'en_curso'");
$reservas_en_curso = $stmt->fetch()['total'];

$stmt = $db->query("SELECT COUNT(*) as total FROM usuarios WHERE rol = 'huesped' AND habilitado = 1");
$huespedes_activos = $stmt->fetch()['total'];

// Obtener reservas recientes
$stmt = $db->query("
    SELECT r.*, u.nombre_completo, u.cedula_pasaporte 
    FROM reservas r
    JOIN usuarios u ON r.usuario_id = u.id
    ORDER BY r.fecha_reserva DESC
    LIMIT 10
");
$reservas_recientes = $stmt->fetchAll();

// Obtener ingresos del mes actual
$stmt = $db->query("
    SELECT SUM(costo_hospedaje) as total
    FROM reservas
    WHERE MONTH(fecha_reserva) = MONTH(CURRENT_DATE())
    AND YEAR(fecha_reserva) = YEAR(CURRENT_DATE())
    AND estado IN ('confirmada', 'en_curso', 'finalizada')
");
$ingresos_mes = $stmt->fetch()['total'] ?? 0;
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Administrador - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-content">
            <div class="logo-container">
                <img src="../assets/images/logo.png" alt="Logo Posada" class="logo">
                <h1 class="site-title">Panel de Administración</h1>
            </div>
            <nav>
                <ul class="nav-menu">
                    <li><span style="color: white;">👤 <?php echo htmlspecialchars($_SESSION['user_name']); ?></span></li>
                    <li><a href="logout.php">Cerrar Sesión</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <div class="container-fluid mt-3">
        <div class="grid" style="grid-template-columns: 250px 1fr; gap: 20px; align-items: start;">
            <!-- Sidebar -->
            <div class="sidebar">
                <h3 style="color: var(--color-primary); margin-bottom: 20px;">Menú</h3>
                <ul class="sidebar-menu">
                    <li><a href="dashboard.php" class="active">📊 Dashboard</a></li>
                    <li><a href="reservas.php">📅 Reservas</a></li>
                    <li><a href="huespedes.php">👥 Huéspedes</a></li>
                    <li><a href="productos.php">🛒 Productos</a></li>
                    <li><a href="categorias.php">📁 Categorías</a></li>
                    <li><a href="tarifas.php">💰 Tarifas</a></li>
                    <li><a href="promociones.php">🎁 Promociones</a></li>
                    <li><a href="galeria.php">🖼️ Galería</a></li>
                    <li><a href="reportes.php">📈 Reportes</a></li>
                </ul>
            </div>

            <!-- Contenido principal -->
            <div>
                <h2 style="color: var(--color-primary); margin-bottom: 20px;">Bienvenido al Panel de Administración</h2>
                
                <!-- Estadísticas -->
                <div class="dashboard-stats">
                    <div class="stat-card" style="background: linear-gradient(135deg, #d4a017, #c19a6b);">
                        <div class="stat-value"><?php echo $reservas_pendientes; ?></div>
                        <div class="stat-label">Reservas Pendientes</div>
                    </div>
                    <div class="stat-card" style="background: linear-gradient(135deg, #4a7c2c, #2d5016);">
                        <div class="stat-value"><?php echo $reservas_confirmadas; ?></div>
                        <div class="stat-label">Reservas Confirmadas</div>
                    </div>
                    <div class="stat-card" style="background: linear-gradient(135deg, #5b8a72, #4a7c2c);">
                        <div class="stat-value"><?php echo $reservas_en_curso; ?></div>
                        <div class="stat-label">Reservas en Curso</div>
                    </div>
                    <div class="stat-card" style="background: linear-gradient(135deg, #8b6f47, #6d5838);">
                        <div class="stat-value"><?php echo $huespedes_activos; ?></div>
                        <div class="stat-label">Huéspedes Activos</div>
                    </div>
                </div>

                <!-- Ingresos del mes -->
                <div class="card mt-2">
                    <div class="card-header">
                        <h3 class="card-title">💵 Ingresos del Mes Actual</h3>
                    </div>
                    <div class="card-body">
                        <div style="font-size: 2.5rem; font-weight: bold; color: var(--color-primary); text-align: center;">
                            <?php echo formatMoney($ingresos_mes); ?>
                        </div>
                        <p style="text-align: center; color: var(--color-text-light); margin-top: 10px;">
                            Correspondiente a <?php echo date('F Y'); ?>
                        </p>
                    </div>
                </div>

                <!-- Reservas recientes -->
                <div class="card mt-2">
                    <div class="card-header">
                        <h3 class="card-title">📋 Reservas Recientes</h3>
                    </div>
                    <div class="card-body">
                        <?php if (empty($reservas_recientes)): ?>
                            <p style="text-align: center; color: var(--color-text-light); padding: 20px;">
                                No hay reservas registradas
                            </p>
                        <?php else: ?>
                            <div style="overflow-x: auto;">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Huésped</th>
                                            <th>Entrada</th>
                                            <th>Salida</th>
                                            <th>Personas</th>
                                            <th>Costo</th>
                                            <th>Estado</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($reservas_recientes as $reserva): ?>
                                            <tr>
                                                <td>#<?php echo str_pad($reserva['id'], 6, '0', STR_PAD_LEFT); ?></td>
                                                <td>
                                                    <?php echo htmlspecialchars($reserva['nombre_completo']); ?><br>
                                                    <small style="color: var(--color-text-light);">
                                                        <?php echo htmlspecialchars($reserva['cedula_pasaporte']); ?>
                                                    </small>
                                                </td>
                                                <td><?php echo formatDate($reserva['fecha_entrada']); ?></td>
                                                <td><?php echo formatDate($reserva['fecha_salida']); ?></td>
                                                <td><?php echo $reserva['cantidad_personas']; ?></td>
                                                <td><?php echo formatMoney($reserva['costo_hospedaje']); ?></td>
                                                <td>
                                                    <?php
                                                    $badgeClass = 'badge-secondary';
                                                    switch($reserva['estado']) {
                                                        case 'pendiente': $badgeClass = 'badge-warning'; break;
                                                        case 'confirmada': $badgeClass = 'badge-success'; break;
                                                        case 'en_curso': $badgeClass = 'badge-info'; break;
                                                        case 'finalizada': $badgeClass = 'badge-secondary'; break;
                                                        case 'cancelada': $badgeClass = 'badge-danger'; break;
                                                    }
                                                    ?>
                                                    <span class="badge <?php echo $badgeClass; ?>">
                                                        <?php echo strtoupper($reserva['estado']); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <a href="reservas.php?ver=<?php echo $reserva['id']; ?>" class="btn btn-sm btn-primary">
                                                        Ver
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <div style="text-align: center; margin-top: 20px;">
                                <a href="reservas.php" class="btn btn-primary">Ver Todas las Reservas</a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Accesos rápidos -->
                <div class="card mt-2">
                    <div class="card-header">
                        <h3 class="card-title">⚡ Accesos Rápidos</h3>
                    </div>
                    <div class="card-body">
                        <div class="grid grid-4">
                            <a href="reservas.php?accion=nueva" class="btn btn-primary btn-block">
                                ➕ Nueva Reserva
                            </a>
                            <a href="productos.php?accion=nuevo" class="btn btn-success btn-block">
                                🛒 Nuevo Producto
                            </a>
                            <a href="tarifas.php?accion=nueva" class="btn btn-info btn-block">
                                💰 Nueva Tarifa
                            </a>
                            <a href="reportes.php" class="btn btn-secondary btn-block">
                                📈 Ver Reportes
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Sistema de Reservas para Posadas. Todos los derechos reservados.</p>
        </div>
    </footer>

    <script src="../assets/js/main.js"></script>
</body>
</html>
