# Sistema de Reservas para Posadas

Sistema completo de gestión de reservas para posadas desarrollado en **PHP puro** con **MySQL**.

## 📋 Características Principales

### Módulo de Huéspedes
- ✅ Registro de huéspedes con autocompletado por cédula/pasaporte
- ✅ Sistema de reservas con calendario de disponibilidad
- ✅ Selección de fechas de entrada y salida
- ✅ Cálculo automático de costos según tarifa y cantidad de personas
- ✅ Generación de comprobante en PDF
- ✅ Visualización de gastos y consumos

### Módulo de Administrador
- ✅ Panel de control con estadísticas en tiempo real
- ✅ Gestión completa de reservas (aprobar, modificar, cancelar, eliminar)
- ✅ Gestión de huéspedes (habilitar/deshabilitar)
- ✅ Gestión de productos y categorías
- ✅ Gestión de tarifas de hospedaje
- ✅ Control de gastos y consumos por huésped
- ✅ Generación de reportes en PDF
- ✅ Gestión de galería de imágenes
- ✅ Sistema de promociones

## 🚀 Requisitos del Sistema

- **PHP 7.4 o superior**
- **MySQL 5.7 o superior**
- **Servidor web** (Apache, Nginx, etc.)
- **Extensiones PHP requeridas:**
  - php-mysql
  - php-mbstring
  - php-xml
  - php-gd

## 📦 Instalación

### Paso 1: Copiar archivos
Copie todos los archivos del sistema a su directorio web (por ejemplo: `/var/www/html/posadas-php/`)

### Paso 2: Configurar la base de datos

#### Opción A: Instalación automática
1. Asegúrese de que MySQL esté corriendo
2. Ejecute el script de instalación:
```bash
php install.php
```

#### Opción B: Instalación manual
1. Cree la base de datos y el usuario:
```sql
CREATE DATABASE posadabd CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE USER 'posadaspgy'@'localhost' IDENTIFIED BY 'pos@da@2025';
GRANT ALL PRIVILEGES ON posadabd.* TO 'posadaspgy'@'localhost';
FLUSH PRIVILEGES;
```

2. Importe el esquema:
```bash
mysql -u root -p posadabd < database.sql
```

### Paso 3: Configurar permisos
```bash
chmod -R 755 /ruta/a/posadas-php
chmod -R 777 /ruta/a/posadas-php/uploads
```

### Paso 4: Configurar el servidor web

#### Apache
Asegúrese de que el módulo `mod_rewrite` esté habilitado y que el archivo `.htaccess` esté configurado correctamente.

#### Nginx
Agregue la siguiente configuración a su bloque `server`:
```nginx
location / {
    try_files $uri $uri/ /index.php?$query_string;
}

location ~ \.php$ {
    fastcgi_pass unix:/var/run/php/php-fpm.sock;
    fastcgi_index index.php;
    include fastcgi_params;
}
```

## 🔐 Credenciales de Acceso

### Administrador
- **URL:** `http://tu-dominio.com/posadas-php/admin/login.php`
- **Usuario:** `Posada`
- **Contraseña:** `Pgy.2025`

### Configuración de Base de Datos
- **Host:** localhost
- **Base de datos:** posadabd
- **Usuario:** posadaspgy
- **Contraseña:** pos@da@2025

## 📖 Manual de Uso

### Para Huéspedes

1. **Registro:**
   - Acceda a la página principal
   - Haga clic en "Registrarse" o "Hacer una Reserva"
   - Ingrese su cédula o pasaporte (si ya está registrado, sus datos se completarán automáticamente)
   - Complete los datos faltantes

2. **Crear Reserva:**
   - Seleccione la tarifa deseada
   - Elija las fechas de entrada y salida
   - Indique la cantidad de personas
   - Agregue comentarios si lo desea
   - Confirme la reserva

3. **Descargar Comprobante:**
   - Después de crear la reserva, podrá descargar el comprobante en PDF
   - Guarde este comprobante para sus registros

### Para Administradores

1. **Acceso al Panel:**
   - Ingrese a `/admin/login.php`
   - Use las credenciales de administrador

2. **Gestión de Reservas:**
   - Vea todas las reservas en el menú "Reservas"
   - Cambie el estado de las reservas (Pendiente → Confirmada → En Curso → Finalizada)
   - Elimine reservas si es necesario

3. **Gestión de Gastos:**
   - Acceda a una reserva y haga clic en el ícono de gastos (💰)
   - Agregue consumos de productos
   - Vea el total de gastos del huésped
   - Imprima el detalle de gastos en PDF

4. **Gestión de Productos:**
   - Cree categorías de productos
   - Agregue productos con sus precios
   - Active o desactive productos según disponibilidad

5. **Gestión de Tarifas:**
   - Cree diferentes tarifas de hospedaje
   - Defina precio por noche y por persona adicional
   - Active o desactive tarifas según temporada

6. **Reportes:**
   - Acceda al menú "Reportes"
   - Genere reportes mensuales en PDF o Excel
   - Vea estadísticas de ingresos y ocupación

## 📁 Estructura de Archivos

```
posadas-php/
├── admin/              # Panel de administración
│   ├── login.php       # Login de administrador
│   ├── dashboard.php   # Dashboard principal
│   ├── reservas.php    # Gestión de reservas
│   ├── gastos.php      # Control de gastos
│   ├── productos.php   # Gestión de productos
│   ├── categorias.php  # Gestión de categorías
│   ├── tarifas.php     # Gestión de tarifas
│   └── logout.php      # Cerrar sesión
├── huesped/            # Módulo de huéspedes
│   ├── registro.php    # Registro de huéspedes
│   ├── reserva.php     # Crear reserva
│   └── comprobante.php # Ver/descargar comprobante
├── assets/             # Recursos estáticos
│   ├── css/           # Estilos
│   ├── js/            # JavaScript
│   └── images/        # Imágenes
├── includes/           # Archivos de configuración
│   ├── config.php     # Configuración general
│   └── fpdf/          # Librería para PDFs
├── uploads/            # Archivos subidos
├── index.php           # Página principal
├── database.sql        # Esquema de base de datos
├── install.php         # Script de instalación
└── README.md           # Este archivo
```

## 🎨 Personalización

### Cambiar Colores
Edite el archivo `assets/css/style.css` y modifique las variables CSS en `:root`:
```css
:root {
    --color-primary: #2d5016;
    --color-secondary: #8b6f47;
    /* ... más colores ... */
}
```

### Cambiar Logo
Reemplace el archivo `assets/images/logo.png` con su propio logo.

### Modificar Tarifas
Acceda al panel de administración → Tarifas → Agregue o modifique las tarifas existentes.

## 🔧 Solución de Problemas

### Error de conexión a la base de datos
- Verifique que MySQL esté corriendo: `sudo service mysql status`
- Verifique las credenciales en `includes/config.php`
- Asegúrese de que el usuario tenga permisos sobre la base de datos

### No se generan los PDFs
- Verifique que la librería FPDF esté en `includes/fpdf/`
- Asegúrese de que PHP tenga permisos de escritura en el directorio temporal

### Las sesiones no funcionan
- Verifique que `session.save_path` esté configurado correctamente en `php.ini`
- Asegúrese de que el directorio de sesiones tenga permisos de escritura

## 📞 Soporte

Para soporte o consultas sobre el sistema, contacte al desarrollador.

## 📝 Licencia

Este sistema fue desarrollado específicamente para gestión de posadas. Todos los derechos reservados.

## 🔄 Actualizaciones Futuras

Funcionalidades planificadas:
- Sistema de notificaciones por email
- Integración con pasarelas de pago
- App móvil para huéspedes
- Sistema de check-in/check-out digital
- Integración con redes sociales

---

**Versión:** 1.0.0  
**Fecha:** Noviembre 2024  
**Desarrollado con:** PHP + MySQL
