# Manual de Usuario - Sistema Médico

## Índice
1. [Inicio de Sesión](#inicio-de-sesión)
2. [Dashboard Principal](#dashboard-principal)
3. [Gestión de Pacientes](#gestión-de-pacientes)
4. [Registro de Consultas](#registro-de-consultas)
5. [Gestión de Citas](#gestión-de-citas)
6. [Alertas Médicas](#alertas-médicas)

---

## Inicio de Sesión

### Acceder al Sistema

1. Abrir el navegador web
2. Ingresar la URL del sistema: `http://[servidor]/sistema-medico/login.php`
3. Ingresar credenciales:
   - **Usuario:** centro
   - **Contraseña:** medico
4. Hacer clic en "Iniciar Sesión"

### Cerrar Sesión

- Hacer clic en "🚪 Cerrar Sesión" en el menú lateral

---

## Dashboard Principal

Al iniciar sesión, se muestra el dashboard con:

### Estadísticas Generales
- **Total Pacientes:** Número total de pacientes registrados
- **Citas Hoy:** Cantidad de citas programadas para hoy
- **Citas Pendientes:** Citas que faltan confirmar o completar
- **Pacientes con Alertas:** Pacientes con alergias o condiciones especiales

### Próximas Citas
- Lista de las próximas 10 citas programadas
- Información: fecha, paciente, médico, tipo y estado

### Accesos Rápidos
- Buscar Paciente
- Nuevo Paciente
- Gestionar Citas
- Cita de Urgencia

---

## Gestión de Pacientes

### Buscar Paciente

1. Hacer clic en "🔍 Buscar Paciente" en el menú
2. Ingresar término de búsqueda:
   - Nombre
   - Apellido
   - Cédula
3. Hacer clic en "🔍 Buscar"
4. Seleccionar "Ver Ficha" en el paciente deseado

**Nota:** Los pacientes con alertas médicas se muestran con un indicador parpadeante.

### Registrar Nuevo Paciente

1. Hacer clic en "➕ Nuevo Paciente"
2. Completar **Datos Personales:**
   - Nombre (obligatorio)
   - Apellido (obligatorio)
   - Cédula (obligatorio)
   - Fecha de Nacimiento (obligatorio)
   - Teléfono
   - Domicilio

3. Completar **Alertas Médicas** (si aplica):
   - Alergias
   - Resistencias a Medicamentos
   - Medicamentos de por Vida
   - Otras Dolencias o Condiciones Crónicas

4. Hacer clic en "💾 Registrar Paciente"

**Importante:** Las alertas médicas aparecerán parpadeando en naranja en la ficha del paciente.

### Ficha del Paciente

La ficha muestra:

#### Alertas Médicas (si existen)
- Panel parpadeante en naranja con todas las alertas activas
- Tipos: alergias, resistencias, medicamentos permanentes, otras dolencias

#### Información del Paciente
- Nombre completo
- Cédula
- Fecha de nacimiento y edad
- Teléfono
- Domicilio
- Fecha de registro

#### Datos de la Última Visita
- Panel amarillo con información destacada:
  - Peso (kg)
  - Presión Arterial
  - Masa Muscular (%)

#### Acciones Disponibles
- **➕ Nueva Consulta:** Registrar una nueva consulta médica
- **📅 Agendar Cita:** Programar una cita futura
- **✏️ Editar Datos:** Modificar información del paciente

#### Historial de Consultas
- Lista cronológica de todas las consultas
- Para cada consulta se muestra:
  - Fecha y hora
  - Médico que atendió
  - Motivo de la visita
  - Signos vitales
  - Diagnóstico
  - Observaciones
  - Tratamientos prescritos
  - Medicamentos recetados

### Editar Paciente

1. Desde la ficha del paciente, hacer clic en "✏️ Editar Datos"
2. Modificar los datos necesarios
3. Hacer clic en "💾 Actualizar Datos"

#### Gestionar Alertas Médicas

En la misma página de edición:

**Ver Alertas Existentes:**
- Alertas activas (destacadas)
- Alertas inactivas (en gris)

**Desactivar una Alerta:**
- Hacer clic en "Desactivar" junto a la alerta
- Confirmar la acción

**Agregar Nueva Alerta:**
1. Seleccionar tipo de alerta
2. Ingresar descripción
3. Seleccionar severidad (baja, media, alta, crítica)
4. Hacer clic en "⚠️ Agregar Alerta"

---

## Registro de Consultas

### Nueva Consulta

1. Desde la ficha del paciente, hacer clic en "➕ Nueva Consulta"
2. El sistema muestra:
   - Alertas médicas del paciente (si existen)
   - Información básica del paciente
   - Datos de la última visita

#### Completar Datos de la Consulta

**Motivo de la Visita** (obligatorio)
- Describir el motivo por el cual el paciente acude a consulta

**Signos Vitales**
- Peso (kg)
- Presión Arterial (ej: 120/80)
- Masa Muscular (%)

**Diagnóstico y Observaciones**
- Diagnóstico médico
- Observaciones adicionales

#### Registrar Tratamiento Médico

Para cada tratamiento:
- Descripción del tratamiento
- Duración (ej: 2 semanas)
- Indicaciones especiales

**Agregar más tratamientos:** Hacer clic en "+ Agregar Otro Tratamiento"

#### Registrar Medicamentos Recetados

Para cada medicamento:
- Nombre del medicamento
- Dosis (ej: 500 mg)
- Frecuencia (ej: Cada 8 horas)
- Duración (ej: 7 días)
- Indicaciones (ej: Tomar con alimentos)

**Agregar más medicamentos:** Hacer clic en "+ Agregar Otro Medicamento"

3. Hacer clic en "💾 Registrar Consulta"

---

## Gestión de Citas

### Ver Todas las Citas

1. Hacer clic en "📅 Citas" en el menú
2. Usar filtros para ver:
   - **Todas:** Últimas 30 días
   - **Hoy:** Citas de hoy
   - **Próximas:** Citas futuras no canceladas
   - **Pendientes:** Citas pendientes de confirmación
   - **Completadas:** Citas ya realizadas

### Agendar Nueva Cita

1. Buscar al paciente
2. Desde la ficha del paciente, hacer clic en "📅 Agendar Cita"
3. Completar información:
   - Fecha de la cita
   - Hora de la cita
   - Médico
   - Tipo de cita:
     - Normal
     - Seguimiento
     - Urgencia
   - Motivo
   - Observaciones

4. Hacer clic en "📅 Agendar Cita"

### Actualizar Estado de Cita

1. Desde la lista de citas, hacer clic en "Actualizar"
2. Cambiar estado:
   - **Pendiente:** Cita programada sin confirmar
   - **Confirmada:** Cita confirmada por el paciente
   - **Completada:** Cita realizada
   - **Cancelada:** Cita cancelada

3. Agregar observaciones si es necesario
4. Hacer clic en "💾 Actualizar Cita"

### Citas de Urgencia

Para registrar una cita de urgencia:

1. Hacer clic en "🚨 Citas de Urgencia" en el menú
2. **Buscar al paciente:**
   - Ingresar cédula, nombre o apellido
   - Hacer clic en "🔍 Buscar"

3. Si el paciente existe:
   - Se muestra su información
   - Se muestran sus alertas médicas (si existen)

4. **Registrar la urgencia:**
   - Seleccionar médico que atenderá
   - Describir motivo de la urgencia
   - Agregar observaciones
   - Hacer clic en "🚨 Registrar Urgencia"

**Nota:** Las citas de urgencia se registran con fecha y hora actual, y estado "confirmada".

### Ver Urgencias Recientes

En la misma página de Citas de Urgencia se muestra una lista de las últimas 20 urgencias registradas.

---

## Alertas Médicas

### Tipos de Alertas

1. **Alergias**
   - Medicamentos
   - Alimentos
   - Sustancias

2. **Resistencias a Medicamentos**
   - Antibióticos
   - Otros medicamentos

3. **Medicamentos de por Vida**
   - Insulina
   - Anticoagulantes
   - Antihipertensivos
   - Otros

4. **Otras Dolencias o Condiciones Crónicas**
   - Diabetes
   - Hipertensión
   - Asma
   - Otras enfermedades crónicas

### Severidad de Alertas

- **Baja:** Condiciones menores
- **Media:** Condiciones moderadas (por defecto)
- **Alta:** Condiciones importantes
- **Crítica:** Condiciones que requieren atención especial

### Visualización de Alertas

Las alertas se muestran:
- **En la ficha del paciente:** Panel parpadeante en naranja
- **En búsqueda de pacientes:** Indicador de alertas
- **En nueva consulta:** Panel destacado al inicio
- **En citas de urgencia:** Panel destacado al buscar paciente

---

## Consejos y Mejores Prácticas

### Registro de Pacientes
- Verificar que la cédula no esté duplicada
- Registrar todas las alergias conocidas
- Mantener actualizado el teléfono de contacto

### Consultas Médicas
- Registrar siempre los signos vitales
- Ser específico en el diagnóstico
- Detallar claramente las indicaciones de medicamentos

### Gestión de Citas
- Confirmar citas con anticipación
- Actualizar el estado de las citas realizadas
- Usar el tipo "seguimiento" para controles

### Alertas Médicas
- Verificar alertas antes de prescribir medicamentos
- Mantener alertas actualizadas
- Desactivar alertas que ya no aplican

### Seguridad
- Cerrar sesión al terminar
- No compartir credenciales
- Cambiar contraseña periódicamente

---

## Atajos y Navegación Rápida

### Desde el Dashboard
- Clic en estadísticas para ver detalles
- Acceso directo a funciones principales

### Desde la Ficha del Paciente
- Nueva consulta
- Agendar cita
- Editar datos

### Búsqueda Rápida
- Usar cédula para búsqueda exacta
- Usar nombre/apellido para búsqueda amplia

---

## Preguntas Frecuentes

**¿Cómo cambio mi contraseña?**
- Contactar al administrador del sistema

**¿Puedo eliminar un paciente?**
- No, para mantener integridad del historial. Se puede desactivar.

**¿Cómo imprimo una receta?**
- Usar la función de impresión del navegador desde la ficha del paciente

**¿Puedo ver consultas de otros médicos?**
- Sí, el sistema muestra todo el historial del paciente

**¿Qué hago si no encuentro un paciente?**
- Verificar cédula o nombre
- Registrar como nuevo paciente si no existe

---

## Soporte Técnico

Para problemas técnicos o dudas sobre el uso del sistema, consultar:
- README.md (documentación técnica)
- INSTALACION.txt (guía de instalación)
- Administrador del sistema

---

**Sistema Médico v1.0**  
**Manual de Usuario**  
**Última actualización: 2025**

