<?php
/**
 * Sistema Médico - Agendar Cita
 */
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

$page_title = 'Agendar Cita';

$database = new Database();
$db = $database->getConnection();

$paciente_id = $_GET['paciente_id'] ?? 0;

if (!$paciente_id) {
    header('Location: buscar_paciente.php');
    exit();
}

// Obtener datos del paciente
$query = "SELECT * FROM pacientes WHERE id = :id";
$stmt = $db->prepare($query);
$stmt->bindParam(':id', $paciente_id);
$stmt->execute();
$paciente = $stmt->fetch();

if (!$paciente) {
    header('Location: buscar_paciente.php');
    exit();
}

// Obtener médicos
$query = "SELECT id, nombre_completo FROM usuarios WHERE activo = 1 ORDER BY nombre_completo";
$stmt = $db->query($query);
$medicos = $stmt->fetchAll();

$mensaje = '';
$tipo_mensaje = '';

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fecha_cita = $_POST['fecha_cita'] ?? '';
    $hora_cita = $_POST['hora_cita'] ?? '';
    $medico_id = $_POST['medico_id'] ?? 0;
    $tipo = $_POST['tipo'] ?? 'normal';
    $motivo = trim($_POST['motivo'] ?? '');
    $observaciones = trim($_POST['observaciones'] ?? '');

    try {
        $fecha_hora_cita = $fecha_cita . ' ' . $hora_cita;

        $query = "INSERT INTO citas (paciente_id, medico_id, fecha_cita, tipo, motivo, observaciones, estado) 
                  VALUES (:paciente_id, :medico_id, :fecha_cita, :tipo, :motivo, :observaciones, 'pendiente')";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(':paciente_id', $paciente_id);
        $stmt->bindParam(':medico_id', $medico_id);
        $stmt->bindParam(':fecha_cita', $fecha_hora_cita);
        $stmt->bindParam(':tipo', $tipo);
        $stmt->bindParam(':motivo', $motivo);
        $stmt->bindParam(':observaciones', $observaciones);
        $stmt->execute();

        $mensaje = 'Cita agendada exitosamente';
        $tipo_mensaje = 'success';

        // Redirigir a la ficha del paciente después de 2 segundos
        header("refresh:2;url=ficha_paciente.php?id=$paciente_id");

    } catch (Exception $e) {
        $mensaje = 'Error al agendar cita: ' . $e->getMessage();
        $tipo_mensaje = 'error';
    }
}

include '../includes/header.php';
?>

<div class="patient-info">
    <h3>Paciente: <?php echo htmlspecialchars($paciente['nombre'] . ' ' . $paciente['apellido']); ?></h3>
    <div class="patient-details">
        <div class="detail-item">
            <span class="detail-label">Cédula</span>
            <span class="detail-value"><?php echo htmlspecialchars($paciente['cedula']); ?></span>
        </div>
        <div class="detail-item">
            <span class="detail-label">Teléfono</span>
            <span class="detail-value"><?php echo htmlspecialchars($paciente['telefono']); ?></span>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h2>Agendar Nueva Cita</h2>
    </div>
    <div class="card-body">
        <?php if ($mensaje): ?>
            <div class="alert alert-<?php echo $tipo_mensaje; ?>">
                <?php echo htmlspecialchars($mensaje); ?>
            </div>
        <?php endif; ?>

        <form method="POST" action="">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                <div class="form-group">
                    <label for="fecha_cita">Fecha de la Cita *</label>
                    <input type="date" id="fecha_cita" name="fecha_cita" min="<?php echo date('Y-m-d'); ?>" required>
                </div>

                <div class="form-group">
                    <label for="hora_cita">Hora de la Cita *</label>
                    <input type="time" id="hora_cita" name="hora_cita" required>
                </div>

                <div class="form-group">
                    <label for="medico_id">Médico *</label>
                    <select id="medico_id" name="medico_id" required>
                        <option value="">Seleccione un médico...</option>
                        <?php foreach ($medicos as $medico): ?>
                            <option value="<?php echo $medico['id']; ?>">
                                <?php echo htmlspecialchars($medico['nombre_completo']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="tipo">Tipo de Cita *</label>
                    <select id="tipo" name="tipo" required>
                        <option value="normal">Normal</option>
                        <option value="seguimiento">Seguimiento</option>
                        <option value="urgencia">Urgencia</option>
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label for="motivo">Motivo de la Cita *</label>
                <textarea id="motivo" name="motivo" rows="3" required></textarea>
            </div>

            <div class="form-group">
                <label for="observaciones">Observaciones</label>
                <textarea id="observaciones" name="observaciones" rows="3"></textarea>
            </div>

            <div style="display: flex; gap: 15px; margin-top: 30px;">
                <button type="submit" class="btn btn-success">📅 Agendar Cita</button>
                <a href="ficha_paciente.php?id=<?php echo $paciente_id; ?>" class="btn btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

