<?php
/**
 * Sistema Médico - Header común
 */

// Cargar permisos si no está cargado
if (!class_exists('Permissions')) {
    require_once dirname(__FILE__) . '/permissions.php';
}

if (!Auth::isLoggedIn()) {
    header('Location: login.php');
    exit();
}

$current_user = Auth::getCurrentUser();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=yes">
    <title><?php echo $page_title ?? 'Dashboard'; ?> - <?php echo SITE_NAME; ?></title>
    <?php
    // Detectar si estamos en una subcarpeta
    $base_path = (basename(dirname($_SERVER['PHP_SELF'])) == 'pages') ? '../' : '';
    ?>
    <link rel="stylesheet" href="<?php echo $base_path; ?>assets/css/style.css">
    <script src="<?php echo $base_path; ?>assets/js/main.js" defer></script>
</head>
<body>
    <!-- Botón hamburguesa para móviles -->
    <button class="menu-toggle" id="menuToggle" onclick="toggleMenu()">☰</button>
    
    <!-- Overlay para cerrar menú -->
    <div class="sidebar-overlay" id="sidebarOverlay" onclick="toggleMenu()"></div>
    
    <div class="main-container">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <img src="<?php echo $base_path; ?>assets/images/logo.jpg" alt="Logo" class="sidebar-logo">
                <h2><?php echo SITE_NAME; ?></h2>
                <p><?php echo SITE_RUC; ?></p>
                <div style="margin-top: 15px; padding: 10px; background: rgba(255,255,255,0.1); border-radius: 5px; text-align: center;">
                    <div style="font-size: 12px; opacity: 0.8;">Usuario:</div>
                    <div style="font-weight: bold; margin-top: 3px;"><?php echo htmlspecialchars($current_user['nombre_completo']); ?></div>
                    <div style="font-size: 11px; margin-top: 5px; padding: 3px 8px; background: rgba(255,255,255,0.2); border-radius: 3px; display: inline-block;">
                        <?php echo Permissions::getRoleName($current_user['rol']); ?>
                    </div>
                </div>
            </div>

            <nav>
                <ul class="sidebar-menu">
                    <li><a href="<?php echo $base_path; ?>index.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">🏠 Dashboard</a></li>
                    
                    <?php if (Permissions::canViewPatients()): ?>
                    <li><a href="<?php echo $base_path; ?>pages/buscar_paciente.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'buscar_paciente.php' ? 'active' : ''; ?>">🔍 Buscar Paciente</a></li>
                    <?php endif; ?>
                    
                    <?php if (Permissions::canRegisterPatients()): ?>
                    <li><a href="<?php echo $base_path; ?>pages/nuevo_paciente.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'nuevo_paciente.php' ? 'active' : ''; ?>">➕ Nuevo Paciente</a></li>
                    <?php endif; ?>
                    
                    <?php if (Permissions::canManageAppointments()): ?>
                    <li><a href="<?php echo $base_path; ?>pages/citas.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'citas.php' ? 'active' : ''; ?>">📅 Citas</a></li>
                    <li><a href="<?php echo $base_path; ?>pages/citas_urgencia.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'citas_urgencia.php' ? 'active' : ''; ?>">🚨 Citas de Urgencia</a></li>
                    <?php endif; ?>
                    
                    <?php if (Permissions::canCreateInvoices()): ?>
                    <li><a href="<?php echo $base_path; ?>pages/facturacion.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'facturacion.php' ? 'active' : ''; ?>">💰 Facturación</a></li>
                    <li><a href="<?php echo $base_path; ?>pages/facturas.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'facturas.php' ? 'active' : ''; ?>">📄 Ver Facturas</a></li>
                    <?php endif; ?>
                    
                    <?php if (Permissions::canManageProductsServices()): ?>
                    <li><a href="<?php echo $base_path; ?>pages/admin/productos.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'productos.php' ? 'active' : ''; ?>">📦 Productos</a></li>
                    <li><a href="<?php echo $base_path; ?>pages/admin/servicios.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'servicios.php' ? 'active' : ''; ?>">🏥 Servicios</a></li>
                    <?php endif; ?>
                    
                    <?php if (Permissions::canViewReports()): ?>
                    <li><a href="<?php echo $base_path; ?>pages/admin/reportes.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'reportes.php' ? 'active' : ''; ?>">📊 Reportes</a></li>
                    <?php endif; ?>
                    
                    <li><a href="<?php echo $base_path; ?>logout.php">🚪 Cerrar Sesión</a></li>
                </ul>
            </nav>
        </aside>

        <!-- Contenido principal -->
        <main class="main-content">
            <!-- Header -->
            <header class="header">
                <div class="header-title">
                    <h1><?php echo $page_title ?? 'Dashboard'; ?></h1>
                </div>
                <div class="header-info">
                    <div class="user-info">
                        <div>
                            <p class="user-name"><?php echo htmlspecialchars($current_user['nombre_completo']); ?></p>
                            <p><?php echo htmlspecialchars($current_user['rol']); ?></p>
                        </div>
                    </div>
                    <p style="margin-top: 10px;"><?php echo SITE_ADDRESS; ?></p>
                    <p><?php echo SITE_PHONE; ?></p>
                </div>
            </header>

            <!-- Contenido de la página -->
            <div class="page-content">

